/* ============================================================
 * File  : gallerympform.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-02
 * Description :
 *
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <tdeapplication.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <kurl.h>

#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqtextstream.h>

#include <cstring>
#include <cstdio>

#include "gallerympform.h"
#include "gallerytalker.h"

namespace KIPIGalleryExportPlugin
{

GalleryMPForm::GalleryMPForm()
{
    m_boundary  = "----------";
    m_boundary += TDEApplication::randomString( 42 + 13 ).ascii();

    if (GalleryTalker::isGallery2())
    {
      addPairRaw("g2_controller", "remote:GalleryRemote");
      TQString auth_token = GalleryTalker::getAuthToken();
      if (!auth_token.isEmpty())
        addPairRaw("g2_authToken", auth_token);
    }
}

GalleryMPForm::~GalleryMPForm()
{
}

void GalleryMPForm::reset()
{
    m_buffer.resize(0);
}

void GalleryMPForm::finish()
{
    TQCString str;
    str += "--";
    str += m_boundary;
    str += "--";
    str += "\r\n";

    TQTextStream ts(m_buffer, IO_Append|IO_WriteOnly);
    ts.setEncoding(TQTextStream::UnicodeUTF8);
    ts << str << '\0';
}

bool GalleryMPForm::addPair(const TQString& name, const TQString& value)
{
    if (GalleryTalker::isGallery2())
      return addPairRaw(TQString("g2_form[%1]").arg(name), value);

    return addPairRaw(name, value);
}

bool GalleryMPForm::addPairRaw(const TQString& name, const TQString& value)
{
    TQCString str;

    str += "--";
    str += m_boundary;
    str += "\r\n";
    str += "Content-Disposition: form-data; name=\"";
    str += name.ascii();
    str += "\"";
    str += "\r\n\r\n";
    str += value.ascii();
    str += "\r\n";

    //uint oldSize = m_buffer.size();
    //m_buffer.resize(oldSize + str.size());
    //memcpy(m_buffer.data() + oldSize, str.data(), str.size());

    TQTextStream ts(m_buffer, IO_Append|IO_WriteOnly);
    ts.setEncoding(TQTextStream::UnicodeUTF8);
    ts << str;

    return true;
}

bool GalleryMPForm::addFile(const TQString& path, const TQString& displayFilename)
{
    TQString filename = "userfile_name";
    if (GalleryTalker::isGallery2())
        filename = "g2_userfile_name";

    if (!addPairRaw(filename, displayFilename))
    {
        return false;
    }

    KMimeType::Ptr ptr = KMimeType::findByURL(path);
    TQString mime = ptr->name();
    if (mime.isEmpty())
    {
        // if we ourselves can't determine the mime of the local file,
        // very unlikely the remote gallery will be able to identify it
        return false;
    }

    TQFile imageFile(path);
    if ( !imageFile.open( IO_ReadOnly ) )
        return false;
    TQByteArray imageData = imageFile.readAll();
    imageFile.close();

    TQCString str;

    str += "--";
    str += m_boundary;
    str += "\r\n";
    str += "Content-Disposition: form-data; name=\"";
    if (GalleryTalker::isGallery2())
      str += "g2_userfile";
    else
      str += "userfile";
    str += "\"; ";
    str += "filename=\"";
    str += TQFile::encodeName(KURL(path).filename());
    str += "\"";
    str += "\r\n";
    str += "Content-Type: ";
    str +=  mime.ascii();
    str += "\r\n\r\n";

    TQTextStream ts(m_buffer, IO_Append|IO_WriteOnly);
    ts.setEncoding(TQTextStream::UnicodeUTF8);
    ts << str;

    int oldSize = m_buffer.size();
    m_buffer.resize(oldSize + imageData.size() + 2);
    memcpy(m_buffer.data()+oldSize, imageData.data(), imageData.size());
    m_buffer[m_buffer.size()-2] = '\r';
    m_buffer[m_buffer.size()-1] = '\n';

    return true;
}

TQString GalleryMPForm::contentType() const
{
    return TQString("Content-Type: multipart/form-data; boundary=" + m_boundary);
}

TQString GalleryMPForm::boundary() const
{
    return m_boundary;
}

TQByteArray GalleryMPForm::formData() const
{
    return m_buffer;
}

}
