/***************************************************************************
                          xmlutils.h  -  description
                             -------------------
    begin                : Mit Mai 7 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLUTILS_H
#define XMLUTILS_H

#include <tqmap.h>
#include <tqsortedlist.h>

class DocumentItem;
class BarcodeItem;
class Barkode;
class Definition;
class TokenProvider;
class MyCanvasView;
class TQColor;
class TQDomDocument;
class TQDomElement;
class TQDomNode;
class TQRect;
class TQString;
class TQWidget;
typedef TQSortedList<DocumentItem> DocumentItemList;

/** This class provides helper function for saving and reading to XML files.
  *
  * @author Dominik Seichter
  */
class XMLUtils {
    public: 
        XMLUtils();
        ~XMLUtils();

        void readXMLHeader( TQDomDocument* doc, TQString & description, bool & kbarcode18, Definition** def );
        void writeXMLHeader( TQDomNode* root, const TQString & description, Definition* def );
                
        void readDocumentItems( DocumentItemList* list, TQDomDocument* doc, TokenProvider* token, bool kbarcode18 );

        void writeXMLDocumentItem( TQDomElement* root, DocumentItem** item );
        bool readXMLDocumentItem( TQDomElement* tag, DocumentItem** item, TokenProvider* token );
        
        void writeXMLColor( TQDomElement* tag, const TQString & prefix, TQColor c ) const;
        TQColor readXMLColor( TQDomElement* tag, const TQString & prefix, TQColor c );

        //void writeXMLRect( TQDomElement* tag, TQRect r, TQPoint ptOrigin ) const;
        TQRect readXMLRect( TQDomElement* tag );

        void writeDefinition( TQDomElement* tag, Definition* d ) const;
        Definition* readDefinition( TQDomElement* tag );

        void writeBarcode( TQDomElement* tag, const Barkode* data, bool cache = false ) const; 
        void readBarcode( TQDomElement* tag, Barkode* bcode );

    private:
        static TQMap<TQString,TQString> legacy;
};

#endif
