// This defines the interface to the TQextScintillaLexerDiff class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLALEXERDIFF_H
#define TQEXTSCINTILLALEXERDIFF_H


#include <tqobject.h>

#include <tqextscintillaglobal.h>
#include <tqextscintillalexer.h>


//! \brief The TQextScintillaLexerDiff class encapsulates the Scintilla Diff
//! lexer.
class TQEXTSCINTILLA_EXPORT TQextScintillaLexerDiff : public TQextScintillaLexer
{
	TQ_OBJECT
  

public:
	//! This enum defines the meanings of the different styles used by the
	//! Diff lexer.
	enum {
		//! The default.
		Default = 0,

		//! A comment.
		Comment = 1,

		//! A command.
		Command = 2,

		//! A header.
		Header = 3,

		//! A position.
		Position = 4,

		//! A removed line.
		LineRemoved = 5,

		//! An added line.
		LineAdded = 6
	};

	//! Construct a TQextScintillaLexerDiff with parent \a parent and name
	//! \a name.  \a parent is typically the TQextScintilla instance.
	TQextScintillaLexerDiff(TQObject *parent = 0,const char *name = 0);

	//! Destroys the TQextScintillaLexerDiff instance.
	virtual ~TQextScintillaLexerDiff();

	//! Returns the name of the language.
	const char *language() const;

	//! Returns the name of the lexer.  Some lexers support a number of
	//! languages.
	const char *lexer() const;

	//! \internal Returns the string of characters that comprise a word.
	const char *wordCharacters() const;

	//! Returns the foreground colour of the text for style number
	//! \a style.
	//!
	//! \sa paper()
	TQColor color(int style) const;

	//! Returns the descriptive name for style number \a style.  If the
	//! style is invalid for this language then TQString() is returned.
	//! This is intended to be used in user preference dialogs.
	TQString description(int style) const;

private:
#if defined(TQ_DISABLE_COPY)
	TQextScintillaLexerDiff(const TQextScintillaLexerDiff &);
	TQextScintillaLexerDiff &operator=(const TQextScintillaLexerDiff &);
#endif
};

#endif
