/*
 * This file is part of the PolKit-tqt project
 * Copyright (C) 2009 Radek Novacek <rnovacek@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef POLKIT_TQT_TEMPORARY_AUTHORIZATION_H
#define POLKIT_TQT_TEMPORARY_AUTHORIZATION_H

#include "polkit-tqt-export.h"
#include "polkit-tqt-subject.h"

typedef struct _PolkitTemporaryAuthorization PolkitTemporaryAuthorization;

class TQDateTime;
class TQString;
template<typename> class TQValueList;


/**
 * \namespace PolkitTQt PolkitTQt
 *
 * \brief Namespace wrapping PolicyKit-TQt classes
 *
 * This namespace wraps all PolicyKit-TQt classes.
 */
namespace PolkitTQt
{

/**
 * \class TemporaryAuthorization polkit-tqt-temporaryauthorization.h TemporaryAuthorization
 * \author Radek Novacek <rnovacek@redhat.com>
 *
 * \brief This class represents PolicyKit temporary authorization
 *
 * This class encapsulates the PolkitTemporaryAuthorization interface.
 */
class POLKIT_TQT_EXPORT TemporaryAuthorization
{
  public:
    typedef TQValueList<TemporaryAuthorization> List;
		 
    TemporaryAuthorization();
    TemporaryAuthorization(const TemporaryAuthorization &other);
    ~TemporaryAuthorization();

    /**
     * Creates TemporaryAuthorization object from PolkitTemporaryAuthorization
     *
     * \warning It shouldn't be used directly unless you are completely aware of what are you doing
     *
     * \param pkTemporaryAuthorization PolkitTemporaryAuthorization object
     */
    TemporaryAuthorization(PolkitTemporaryAuthorization *pkTemporaryAuthorization);

    TemporaryAuthorization& operator=(const TemporaryAuthorization &other);

    /**
     * \brief Gets the identifier for the authorization.
     *
     * This identifier can be user by the revokeTemporaryAuthorization function
     *
     * \return Unique identifier for the authorization
     */
    TQString id() const;

    /**
     * \brief Gets the identifier of the action that authorization is for
     *
     * \return String that identifies the action
     */
    TQString actionId() const;

    /**
     * \brief Gets the subject that authorization is for
     *
     * \return A Subject.
     */
    Subject subject() const;

    /**
     * \brief Gets the time when authorization was obtained
     *
     * \return Time of obtaining the authorization
     */
    TQDateTime obtainedAt() const;

    /**
     * \brief Gets the time when authorizaton will expire
     *
     * \return Time of expiration
     */
    TQDateTime expirationTime() const;

    /**
     * \brief Revoke temporary authorization
     *
     * \return \c true Authorization has been revoked
     *         \c false Revoking authorization failed
     */
    bool revoke();

  private:
    class Data;
    Data *d;
};

}

#endif
