// File autogenerated

// declaration include
#include "emailInterface.h"

// TQt includes
#include <tqdom.h>
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusvariant.h>


namespace org
{
namespace freedesktop
{
namespace impl
{
namespace portal
{

void EmailInterface::buildIntrospectionData(TQDomElement& interfaceElement)
{
    interfaceElement.setAttribute("name", "org.freedesktop.impl.portal.Email");

    TQDomDocument document = interfaceElement.ownerDocument();
    TQDomElement methodElement = document.createElement("method");
    methodElement.setAttribute("name", "ComposeEmail");

    TQDomElement argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "handle");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "app_id");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "parent_window");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "options");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "response");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "results");
    argumentElement.setAttribute("type",      "a{sv}");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);
}

TQT_DBusMessage EmailInterface::callComposeEmail(const TQT_DBusMessage& message)
{
    TQT_DBusError   error;
    TQT_DBusMessage reply;

    TQT_DBusObjectPath _handle = message[0].toObjectPath();
    TQString _app_id = message[1].toString();
    TQString _parent_window = message[2].toString();
    TQMap< TQString, TQT_DBusVariant > _options = message[3].toStringKeyMap().toVariantMap();
    TQ_UINT32 _response;
    TQMap< TQString, TQT_DBusVariant > _results;

    if (ComposeEmail(_handle, _app_id, _parent_window, _options, _response, _results, error))
    {
        reply = TQT_DBusMessage::methodReply(message);
        reply << TQT_DBusData::fromUInt32(_response);
        reply << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(_results));
    }
    else
    {
        if (!error.isValid())
        {
            tqWarning("Call to implementation of org::freedesktop::impl::portal::EmailInterface::ComposeEmail returned 'false' but error object is not valid!");

            error = TQT_DBusError::stdFailed("org.freedesktop.impl.portal.Email.ComposeEmail execution failed");
        }

        reply = TQT_DBusMessage::methodError(message, error);
    }

    return reply;
}

bool EmailInterface::handleMethodCall(const TQT_DBusMessage& message)
{
    if (message.interface() != "org.freedesktop.impl.portal.Email") return false;

    if (message.member() == "ComposeEmail")
    {
        TQT_DBusMessage reply = callComposeEmail(message);
        handleMethodReply(reply);

        return true;
    }

    return false; 
}

}; // namespace portal

}; // namespace impl

}; // namespace freedesktop

}; // namespace org

// End of File

