// This defines the interface to the TQextScintillaMacro class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLAMACRO_H
#define TQEXTSCINTILLAMACRO_H


#include <tqobject.h>
#include <tqcstring.h>
#include <tqvaluelist.h>

#include <tqextscintillaglobal.h>


class TQString;
class TQextScintilla;


//! \brief The TQextScintillaMacro class represents a sequence of recordable
//! editor commands.
//!
//! Methods are provided to convert convert a macro to and from a textual
//! representation so that they can be easily written to and read from
//! permanent storage.
class TQEXTSCINTILLA_EXPORT TQextScintillaMacro : public TQObject
{
	TQ_OBJECT
  

public:
	//! Construct a TQextScintillaMacro with parent \a parent and name
	//! \a name.
	TQextScintillaMacro(TQextScintilla *parent,const char *name = 0);

	//! Construct a TQextScintillaMacro from the printable ASCII
	//! representation \a asc, with parent \a parent and name \a name.
	TQextScintillaMacro(const TQCString &asc,TQextScintilla *parent,
			   const char *name = 0);

	//! Destroy the TQextScintillaMacro instance.
	virtual ~TQextScintillaMacro();

	//! Clear the contents of the macro.
	void clear();

	//! Load the macro from the printable ASCII representation \a asc.
	//! Returns true if there was no error.
	//!
	//! \sa save()
	bool load(const TQCString &asc);

	//! Return a printable ASCII representation of the macro.  It is
	//! guaranteed that only printable ASCII characters are used and that
	//! double quote characters will not be used.
	//!
	//! \sa load()
	TQCString save() const;

public slots:
	//! Play the macro.
	virtual void play();

	//! Start recording user commands and add them to the macro.
	virtual void startRecording();

	//! Stop recording user commands.
	virtual void endRecording();

private slots:
	void record(unsigned int msg,unsigned long wParam,long lParam);

private:
	struct Macro {
		unsigned int msg;
		unsigned long wParam;
		TQByteArray text;
	};

	TQextScintilla *tqsci;
	TQValueList<Macro> macro;

#if defined(TQ_DISABLE_COPY)
	TQextScintillaMacro(const TQextScintillaMacro &);
	TQextScintillaMacro &operator=(const TQextScintillaMacro &);
#endif
};

#endif
