// File autogenerated

// declaration include
#include "agent1Interface.h"

// TQt includes
#include <tqdom.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>


namespace org
{
namespace bluez
{

void Agent1Interface::buildIntrospectionData(TQDomElement& interfaceElement)
{
    interfaceElement.setAttribute("name", "org.bluez.Agent1");

    TQDomDocument document = interfaceElement.ownerDocument();
    TQDomElement methodElement = document.createElement("method");
    methodElement.setAttribute("name", "Release");

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    TQDomElement asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "RequestPinCode");

    TQDomElement argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "pincode");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "DisplayPinCode");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "pincode");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "RequestPasskey");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "passkey");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "DisplayPasskey");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "passkey");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "entered");
    argumentElement.setAttribute("type",      "q");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "RequestConfirmation");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "passkey");
    argumentElement.setAttribute("type",      "u");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "RequestAuthorization");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    asyncAnnotationElement = document.createElement("annotation");
    asyncAnnotationElement.setAttribute("name", "org.freedesktop.DBus.GLib.Async");
    asyncAnnotationElement.setAttribute("value", "true");
    methodElement.appendChild(asyncAnnotationElement);
    methodElement.setAttribute("name", "AuthorizeService");

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "device");
    argumentElement.setAttribute("type",      "o");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "uuid");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "in");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);

    methodElement = document.createElement("method");
    methodElement.setAttribute("name", "Cancel");

    interfaceElement.appendChild(methodElement);
}

void Agent1Interface::RequestPinCodeAsyncReply(int asyncCallId, const TQString& pincode)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);
    reply << TQT_DBusData::fromString(pincode);

    handleMethodReply(reply);
}

void Agent1Interface::RequestPinCodeAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::DisplayPinCodeAsyncReply(int asyncCallId)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);

    handleMethodReply(reply);
}

void Agent1Interface::DisplayPinCodeAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::RequestPasskeyAsyncReply(int asyncCallId, TQ_UINT32 passkey)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);
    reply << TQT_DBusData::fromUInt32(passkey);

    handleMethodReply(reply);
}

void Agent1Interface::RequestPasskeyAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::DisplayPasskeyAsyncReply(int asyncCallId)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);

    handleMethodReply(reply);
}

void Agent1Interface::DisplayPasskeyAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::RequestConfirmationAsyncReply(int asyncCallId)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);

    handleMethodReply(reply);
}

void Agent1Interface::RequestConfirmationAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::RequestAuthorizationAsyncReply(int asyncCallId)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);

    handleMethodReply(reply);
}

void Agent1Interface::RequestAuthorizationAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

void Agent1Interface::AuthorizeServiceAsyncReply(int asyncCallId)

{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(call);

    handleMethodReply(reply);
}

void Agent1Interface::AuthorizeServiceAsyncError(int asyncCallId, const TQT_DBusError& error)
{
    TQMap<int, TQT_DBusMessage>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    TQT_DBusMessage call = findIt.data();
    m_asyncCalls.erase(findIt);

    TQT_DBusMessage reply = TQT_DBusMessage::methodError(call, error);
    handleMethodReply(reply);
}

TQT_DBusMessage Agent1Interface::callRelease(const TQT_DBusMessage& message)
{
    TQT_DBusError   error;
    TQT_DBusMessage reply;


    if (Release(error))
    {
        reply = TQT_DBusMessage::methodReply(message);
    }
    else
    {
        if (!error.isValid())
        {
            tqWarning("Call to implementation of org::bluez::Agent1Interface::Release returned 'false' but error object is not valid!");

            error = TQT_DBusError::stdFailed("org.bluez.Agent1.Release execution failed");
        }

        reply = TQT_DBusMessage::methodError(message, error);
    }

    return reply;
}

TQT_DBusMessage Agent1Interface::callCancel(const TQT_DBusMessage& message)
{
    TQT_DBusError   error;
    TQT_DBusMessage reply;


    if (Cancel(error))
    {
        reply = TQT_DBusMessage::methodReply(message);
    }
    else
    {
        if (!error.isValid())
        {
            tqWarning("Call to implementation of org::bluez::Agent1Interface::Cancel returned 'false' but error object is not valid!");

            error = TQT_DBusError::stdFailed("org.bluez.Agent1.Cancel execution failed");
        }

        reply = TQT_DBusMessage::methodError(message, error);
    }

    return reply;
}

void Agent1Interface::callRequestPinCodeAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    RequestPinCodeAsync(_asyncCallId, _device);

    return;
}

void Agent1Interface::callDisplayPinCodeAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();
    TQString _pincode = message[1].toString();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    DisplayPinCodeAsync(_asyncCallId, _device, _pincode);

    return;
}

void Agent1Interface::callRequestPasskeyAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    RequestPasskeyAsync(_asyncCallId, _device);

    return;
}

void Agent1Interface::callDisplayPasskeyAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();
    TQ_UINT32 _passkey = message[1].toUInt32();
    TQ_UINT16 _entered = message[2].toUInt16();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    DisplayPasskeyAsync(_asyncCallId, _device, _passkey, _entered);

    return;
}

void Agent1Interface::callRequestConfirmationAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();
    TQ_UINT32 _passkey = message[1].toUInt32();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    RequestConfirmationAsync(_asyncCallId, _device, _passkey);

    return;
}

void Agent1Interface::callRequestAuthorizationAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    RequestAuthorizationAsync(_asyncCallId, _device);

    return;
}

void Agent1Interface::callAuthorizeServiceAsync(const TQT_DBusMessage& message)
{
    TQT_DBusObjectPath _device = message[0].toObjectPath();
    TQString _uuid = message[1].toString();

    int _asyncCallId = 0;
    while (m_asyncCalls.find(_asyncCallId) != m_asyncCalls.end())
    {
        ++_asyncCallId;
    }
    m_asyncCalls.insert(_asyncCallId, message);

    AuthorizeServiceAsync(_asyncCallId, _device, _uuid);

    return;
}

bool Agent1Interface::handleMethodCall(const TQT_DBusMessage& message)
{
    if (message.interface() != "org.bluez.Agent1") return false;

    if (message.member() == "Release")
    {
        TQT_DBusMessage reply = callRelease(message);
        handleMethodReply(reply);

        return true;
    }

    if (message.member() == "RequestPinCode")
    {
        callRequestPinCodeAsync(message);

        return true;
    }

    if (message.member() == "DisplayPinCode")
    {
        callDisplayPinCodeAsync(message);

        return true;
    }

    if (message.member() == "RequestPasskey")
    {
        callRequestPasskeyAsync(message);

        return true;
    }

    if (message.member() == "DisplayPasskey")
    {
        callDisplayPasskeyAsync(message);

        return true;
    }

    if (message.member() == "RequestConfirmation")
    {
        callRequestConfirmationAsync(message);

        return true;
    }

    if (message.member() == "RequestAuthorization")
    {
        callRequestAuthorizationAsync(message);

        return true;
    }

    if (message.member() == "AuthorizeService")
    {
        callAuthorizeServiceAsync(message);

        return true;
    }

    if (message.member() == "Cancel")
    {
        TQT_DBusMessage reply = callCancel(message);
        handleMethodReply(reply);

        return true;
    }

    return false; 
}

}; // namespace bluez

}; // namespace org

// End of File

