/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2004 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
**************************************************************************** */
#ifndef CATALOGSETTINGS_H
#define CATALOGSETTINGS_H

#include <tqstring.h>
#include <tqregexp.h>
#include <tqdatetime.h>
#include <tdemacros.h>

class TQTextCodec;
class TQStringList;

namespace KBabel
{

struct TDE_EXPORT SaveSettings
{
    bool autoUpdate;
    bool updateLastTranslator;
    bool updateRevisionDate;
    bool updateLanguageTeam;
    bool updateCharset;
    bool updateEncoding;
    
    bool updateProject;
    bool updateDescription;
    TQString descriptionString;
    bool updateTranslatorCopyright;
    int FSFCopyright;

    int encoding;
    bool useOldEncoding;

    TQt::DateFormat dateFormat;
    TQString customDateFormat;
    
    TQString projectString;

    bool autoSyntaxCheck;
    bool saveObsolete;
    
    int autoSaveDelay;
};

struct TDE_EXPORT IdentitySettings
{
    TQString authorName;
    TQString authorLocalizedName;
    TQString authorEmail;
    TQString languageName;
    TQString languageCode;
    TQString mailingList;
    TQString timeZone;

   /**
    * The number of plural forms. If <= 0 the number is determined
    * automatically.
    */
   int numberOfPluralForms;
   /**
    * Whether the %n argument should be always present in translation
    */
   bool checkPluralArgument;

   TQString gnuPluralFormHeader;
};


struct TDE_EXPORT MiscSettings
{
   /** 
    * The char, that marks keyboard accelerators.
    * Default is '&' as used by TQt
    */
   TQChar accelMarker;
   
   /**
    * The regular expression for what is context information.
    * Default is "^_:.+" as used in KDE
    */ 
   TQRegExp contextInfo;

   /** 
    * The regular expression for strings that contain a message for
    * singular and one for plural
    */
   TQRegExp singularPlural;

  /**
   * The method used for compresion of email attachments. Use
   * tar/bzip2 if true, tar/gzip if false.
   * Default is true.
   */
  bool useBzip;

  /**
   * Use compression for single file attachments. 
   * Default is true.
   */
  bool compressSingleFile;
};

struct TagSettings
{
    /**
    * A list of regular expressions defining tags
    */
    TQStringList tagExpressions;
    /**
    * A list of regular expressions defining arguments
    */
    TQStringList argExpressions;
};

TDE_EXPORT TQString charsetString(const int encoding);
TDE_EXPORT TQString charsetString(const TQTextCodec *codec);
TDE_EXPORT TQString GNUPluralForms(const TQString& lang);

namespace Defaults
{
   class TDE_EXPORT Identity
   {
    public:
       static TQString authorName();
       static TQString authorLocalizedName();
       static TQString authorEmail();
       static TQString languageCode();
       static TQString mailingList();
       static TQString timezone();
   };

   class TDE_EXPORT Tag
   {
      public:
	 static TQStringList tagExpressions();
	 static TQStringList argExpressions();
   };
   
}

}


#endif
