/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.validator3.domain.metrics.RsyncMetricsService;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsyncMetricsService {
    private static final Logger log = LoggerFactory.getLogger(RsyncMetricsService.class);
    @Autowired
    private MeterRegistry registry;
    private ConcurrentHashMap<Tuple2<String, Integer>, RsyncMetric> rsyncMetrics = new ConcurrentHashMap();

    public void update(String uri, int statusDescription, long durationMs) {
        this.update(URI.create(uri), statusDescription, durationMs);
    }

    public void update(URI uri, int statusDescription, long durationMs) {
        String rootURL = uri.resolve("/").toASCIIString();
        this.rsyncMetrics.computeIfAbsent(new Tuple2((Object)rootURL, (Object)statusDescription), key -> new RsyncMetric(this.registry, rootURL, (long)statusDescription)).update(durationMs);
    }
}

