/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.config;

import javax.annotation.PreDestroy;
import net.ripe.rpki.validator3.api.util.BuildInformation;
import net.ripe.rpki.validator3.util.HappyEyeballsResolver;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class HttpClientConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConfig.class);
    @Value(value="${rpki.validator.http.proxy.host:#{null}}")
    private String proxyHost;
    @Value(value="${rpki.validator.http.proxy.port:#{null}}")
    private Integer proxyPort;
    @Value(value="${rpki.validator.rrdp.trust.all.tls.certificates}")
    private boolean trustAllTlsCertificates;
    private HttpClient httpClientInstance;

    @Bean
    @Scope(value="singleton")
    public HttpClient client(BuildInformation buildInformation) throws Exception {
        if (this.trustAllTlsCertificates) {
            log.warn("All TLS certificates are being accepted: HTTPS is effectively disabled. This is **NOT** recommended.");
        }
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(this.trustAllTlsCertificates);
        this.httpClientInstance = new HttpClient((SslContextFactory)sslContextFactory);
        log.info("Trust all TLS certificates: {}, proxy host is {}, proxy port is {}", new Object[]{this.trustAllTlsCertificates, this.proxyHost, this.proxyPort});
        if (this.proxyHost != null && this.proxyPort != null) {
            ProxyConfiguration proxyConfig = this.httpClientInstance.getProxyConfiguration();
            HttpProxy proxy = new HttpProxy(this.proxyHost, this.proxyPort.intValue());
            proxyConfig.getProxies().add(proxy);
        }
        this.httpClientInstance.setSocketAddressResolver((SocketAddressResolver)new HappyEyeballsResolver(this.httpClientInstance));
        this.httpClientInstance.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, String.format("RIPE NCC RPKI Validator/%s", buildInformation.getVersion())));
        this.httpClientInstance.start();
        return this.httpClientInstance;
    }

    @PreDestroy
    public void stopHttpClient() throws Exception {
        log.info("Stopping http client");
        this.httpClientInstance.stop();
    }
}

