/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.mapped;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.MemoryUtil;
import org.lwjgl.test.mapped.MappedFloat;
import org.lwjgl.test.mapped.MappedSomething;
import org.lwjgl.test.mapped.MappedVec2;
import org.lwjgl.test.mapped.MappedVec3;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedSet;
import org.lwjgl.util.mapped.MappedSet2;

public class MappedObjectTests3 {
    static void testMappedBuffer() {
        int elementCount = 4;
        MappedSomething some = (MappedSomething)MappedSomething.malloc((int)elementCount);
        assert (some.data != some.data);
        long addr1 = MemoryUtil.getAddress((ByteBuffer)some.backingByteBuffer());
        ByteBuffer mapped = some.data;
        long addr2 = MemoryUtil.getAddress((ByteBuffer)mapped);
        assert (addr2 - addr1 == 4L);
        assert (mapped.capacity() == MappedSomething.SIZEOF - 4);
        assert (some.shared == 0);
        assert (mapped.getInt(8) == 0);
        some.shared = 1234;
        assert (some.shared == 1234);
        assert (mapped.getInt(8) == 1234);
        ++some.view;
        mapped = some.data;
        long addr3 = MemoryUtil.getAddress((ByteBuffer)mapped);
        assert (addr3 - addr1 == (long)(4 + MappedSomething.SIZEOF));
        assert (addr3 - addr2 == (long)(0 + MappedSomething.SIZEOF));
        assert (mapped.capacity() == MappedSomething.SIZEOF - 4);
    }

    static void testForeach() {
        int elementCount = 10;
        MappedSomething some = (MappedSomething)MappedSomething.malloc((int)elementCount);
        int i = 0;
        for (MappedSomething item : MappedObject.foreach((MappedObject)some, (int)(elementCount / 2))) {
            assert (item.view == i++);
        }
        assert (some.view == elementCount / 2 - 1);
        System.out.println("current.view=" + some.view + ", not " + elementCount / 2 + ", as you might expect");
        i = 0;
        for (MappedSomething item : MappedObject.foreach((MappedObject)some)) {
            assert (item.view == i++);
        }
        assert (some.view == elementCount - 1);
    }

    static void testConstructor() {
        int capacity = 1024;
        ByteBuffer bb = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        long address = MemoryUtil.getAddress((ByteBuffer)bb);
        MappedFloat mf = (MappedFloat)MappedFloat.map((long)address, (int)capacity);
        assert (address == mf.baseAddress);
        assert (mf.value == 0.0f);
        mf.view = 1;
        assert (mf.value == 0.0f);
        mf.runViewConstructor();
        assert (mf.value == 4.0f);
        Xyz.malloc((int)3);
    }

    static void testMappedSet() {
        MappedVec2 vec2 = (MappedVec2)MappedVec2.malloc((int)3);
        MappedVec3 vec3 = (MappedVec3)MappedVec3.malloc((int)3);
        MappedSet2 set = MappedSet.create((MappedObject)vec2, (MappedObject)vec3);
        assert (vec2.view == 0);
        assert (vec3.view == 0);
        set.view = 2;
        assert (vec2.view == 2);
        assert (vec3.view == 2);
        set.view = 0;
        assert (vec2.view == 0);
        assert (vec3.view == 0);
        set.next();
        assert (vec2.view == 1);
        assert (vec3.view == 1);
    }

    public static class Xyz
    extends MappedObject {
        int x;
        int y;
        int z;
    }
}

