/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JLabel;

public final class TileBounds {
    public static final int UNIT_OFFSET = 20;
    public static final int OTHER_UNITS_OFFSET_X = -5;
    public static final int OTHER_UNITS_OFFSET_Y = 1;
    public static final int OTHER_UNITS_WIDTH = 3;
    public static final int MAX_OTHER_UNITS = 10;
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private int halfWidth;
    private float scaleFactor;

    TileBounds(Dimension tileSize, float scaleFactor) {
        this.tileHeight = tileSize.height;
        this.tileWidth = tileSize.width;
        this.halfHeight = tileSize.height / 2;
        this.halfWidth = tileSize.width / 2;
        this.scaleFactor = scaleFactor;
    }

    public int getWidth() {
        return this.tileWidth;
    }

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public int getHeight() {
        return this.tileHeight;
    }

    public int getHalfHeight() {
        return this.halfHeight;
    }

    Point calculateUnitLabelPositionInTile(JLabel unitLabel, Point tileP) {
        if (tileP == null) {
            return null;
        }
        int labelX = tileP.x + this.tileWidth / 2 - unitLabel.getWidth() / 2;
        int labelY = tileP.y + this.tileHeight / 2 - unitLabel.getHeight() / 2;
        return new Point(labelX, labelY);
    }
}

