"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataView = void 0;
var _index_pattern = require("../../index_patterns/index_patterns/index_pattern");
var _ = require("../");
var _constants = require("../../constants");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * @experimental This class is experimental and may change in future versions
 */
class DataView extends _index_pattern.IndexPattern {
  constructor({
    spec = {},
    fieldFormats,
    shortDotsEnable = false,
    metaFields = [],
    savedObjectsClient
  }) {
    super({
      spec,
      fieldFormats,
      shortDotsEnable,
      metaFields,
      savedObjectsClient
    });
    _defineProperty(this, "savedObjectsClient", void 0);
    this.savedObjectsClient = savedObjectsClient;
  }
  async initializeDataSourceRef() {
    var _this$dataSourceRef;
    if (!((_this$dataSourceRef = this.dataSourceRef) !== null && _this$dataSourceRef !== void 0 && _this$dataSourceRef.id)) return;
    try {
      // FIXME: dataSourceRef.type is overloaded with conflicting meanings:
      // - For INDEX_PATTERN datasets: contains saved object type 'data-source' (correct)
      // - For INDEX datasets: contains structure type 'DATA_SOURCE' (incorrect - should be 'data-source')
      // - After initialization: contains engine type like 'OpenSearch', 'S3_GLUE' (metadata, not saved object type)
      //
      // The DataSource interface (src/plugins/data/common/datasets/types.ts:17) claims type is
      // "The engine type of the data source", but actual usage violates this contract:
      // - index_type.ts:56 sets type to DataStructure.type ('DATA_SOURCE')
      // - index_pattern_type.ts:148 sets type to dataSourceEngineType ('OpenSearch', 'S3_GLUE')
      // - SavedObjectReference.type expects saved object type ('data-source')
      //
      // This causes savedObjectsClient.get() to fail for INDEX datasets because 'DATA_SOURCE'
      // is not a registered saved object type. Valid saved object types are:
      // - 'data-source' (defined in src/plugins/data_source/server/saved_objects/data_source.ts:15)
      // - 'data-connection' (defined in src/plugins/data_source/server/saved_objects/data_connection.ts:9)
      //
      // TEMPORARY FIX: Hardcoding 'data-source' instead of using this.dataSourceRef.type
      // This works for INDEX_PATTERN datasets (already 'data-source') and fixes INDEX datasets
      // (which incorrectly have 'DATA_SOURCE'), but assumes all data sources are 'data-source' type.
      //
      // TODO: Proper fix - Normalize structure types to saved object types before calling get():
      //   const savedObjectType = this.dataSourceRef.type === 'DATA_SOURCE' ? 'data-source' : this.dataSourceRef.type;
      //   await this.savedObjectsClient.get(savedObjectType, this.dataSourceRef.id);
      const dataSourceSavedObject = await this.savedObjectsClient.get('data-source', this.dataSourceRef.id);
      const attributes = dataSourceSavedObject.attributes;
      this.dataSourceRef = {
        id: this.dataSourceRef.id,
        type: attributes.dataSourceEngineType || this.dataSourceRef.type,
        version: attributes.dataSourceVersion || this.dataSourceRef.version,
        name: attributes.title || this.dataSourceRef.name || this.dataSourceRef.id
      };
    } catch (error) {
      // If data source fetch fails, keep the existing dataSourceRef as-is
      // This ensures the DataView can still be used even if the data source is unavailable
    }
  }

  /**
   * Converts a DataView to a serializable Dataset object
   * Maps dataSourceRef and includes only essential properties for backward compatibility
   */
  async toDataset() {
    const defaultType = _constants.DEFAULT_DATA.SET_TYPES.INDEX_PATTERN;
    const dataSourceReference = this.dataSourceRef || this.dataSource;
    let dataSource;
    let datasetType = this.type || defaultType;
    if (dataSourceReference !== null && dataSourceReference !== void 0 && dataSourceReference.id) {
      try {
        const dataSourceSavedObject = await this.savedObjectsClient.get('data-source', dataSourceReference.id);
        const attributes = dataSourceSavedObject.attributes;
        if (dataSourceReference.name && dataSourceReference.name !== 'dataSource') {
          const extractedType = (0, _.extractDatasetTypeFromUri)(dataSourceReference.name);
          if (extractedType) {
            datasetType = extractedType;
          }
        }
        dataSource = {
          id: dataSourceReference.id,
          title: attributes.title || dataSourceReference.id,
          type: attributes.dataSourceEngineType || 'OpenSearch',
          version: attributes.dataSourceVersion || ''
        };
      } catch (error) {
        // If we can't fetch the data source, create a minimal version
        dataSource = {
          id: dataSourceReference.id,
          title: dataSourceReference.name && dataSourceReference.name !== 'dataSource' ? dataSourceReference.name : dataSourceReference.id,
          type: 'OpenSearch',
          version: ''
        };
      }
    }
    return {
      id: this.id || '',
      title: this.title,
      type: datasetType,
      timeFieldName: this.timeFieldName,
      displayName: this.displayName,
      description: this.description,
      schemaMappings: this.schemaMappings,
      dataSource
    };
  }
}
exports.DataView = DataView;