"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  defineRoutes: true
};
exports.defineRoutes = defineRoutes;
var _dsl_route = require("./dsl_route");
var _metrics_route = require("./metrics_route");
var _search_relevance_route_service = require("./search_relevance_route_service");
Object.keys(_search_relevance_route_service).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _search_relevance_route_service[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _search_relevance_route_service[key];
    }
  });
});
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoutes(router, openSearchServiceSetup, dataSourceEnabled) {
  (0, _dsl_route.registerDslRoute)(router, openSearchServiceSetup, dataSourceEnabled);
  (0, _metrics_route.registerMetricsRoute)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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