/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.CommitmentPolicy;
import software.amazon.cryptography.materialproviders.model.EncryptedDataKey;

public class DecryptMaterialsInput {
    private final AlgorithmSuiteId algorithmSuiteId;
    private final CommitmentPolicy commitmentPolicy;
    private final List<EncryptedDataKey> encryptedDataKeys;
    private final Map<String, String> encryptionContext;
    private final Map<String, String> reproducedEncryptionContext;

    protected DecryptMaterialsInput(BuilderImpl builder) {
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.commitmentPolicy = builder.commitmentPolicy();
        this.encryptedDataKeys = builder.encryptedDataKeys();
        this.encryptionContext = builder.encryptionContext();
        this.reproducedEncryptionContext = builder.reproducedEncryptionContext();
    }

    public AlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public CommitmentPolicy commitmentPolicy() {
        return this.commitmentPolicy;
    }

    public List<EncryptedDataKey> encryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Map<String, String> reproducedEncryptionContext() {
        return this.reproducedEncryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteId algorithmSuiteId;
        protected CommitmentPolicy commitmentPolicy;
        protected List<EncryptedDataKey> encryptedDataKeys;
        protected Map<String, String> encryptionContext;
        protected Map<String, String> reproducedEncryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptMaterialsInput model) {
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.commitmentPolicy = model.commitmentPolicy();
            this.encryptedDataKeys = model.encryptedDataKeys();
            this.encryptionContext = model.encryptionContext();
            this.reproducedEncryptionContext = model.reproducedEncryptionContext();
        }

        @Override
        public Builder algorithmSuiteId(AlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public AlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder commitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this.commitmentPolicy = commitmentPolicy;
            return this;
        }

        @Override
        public CommitmentPolicy commitmentPolicy() {
            return this.commitmentPolicy;
        }

        @Override
        public Builder encryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
            this.encryptedDataKeys = encryptedDataKeys;
            return this;
        }

        @Override
        public List<EncryptedDataKey> encryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder reproducedEncryptionContext(Map<String, String> reproducedEncryptionContext) {
            this.reproducedEncryptionContext = reproducedEncryptionContext;
            return this;
        }

        @Override
        public Map<String, String> reproducedEncryptionContext() {
            return this.reproducedEncryptionContext;
        }

        @Override
        public DecryptMaterialsInput build() {
            if (Objects.isNull(this.algorithmSuiteId())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuiteId`");
            }
            if (Objects.isNull(this.commitmentPolicy())) {
                throw new IllegalArgumentException("Missing value for required field `commitmentPolicy`");
            }
            if (Objects.isNull(this.encryptedDataKeys())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedDataKeys`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            return new DecryptMaterialsInput(this);
        }
    }

    public static interface Builder {
        public Builder algorithmSuiteId(AlgorithmSuiteId var1);

        public AlgorithmSuiteId algorithmSuiteId();

        public Builder commitmentPolicy(CommitmentPolicy var1);

        public CommitmentPolicy commitmentPolicy();

        public Builder encryptedDataKeys(List<EncryptedDataKey> var1);

        public List<EncryptedDataKey> encryptedDataKeys();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder reproducedEncryptionContext(Map<String, String> var1);

        public Map<String, String> reproducedEncryptionContext();

        public DecryptMaterialsInput build();
    }
}

