/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.IndexWorkflowRequest;
import org.opensearch.commons.alerting.action.IndexWorkflowResponse;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/alerting/resthandler/RestIndexWorkflowAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "indexMonitorResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/commons/alerting/action/IndexWorkflowResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "restMethod", "Lorg/opensearch/rest/RestRequest$Method;", "opensearch-alerting"})
public final class RestIndexWorkflowAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_workflow_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.WORKFLOW_BASE_URI), new RestHandler.Route(RestRequest.Method.PUT, AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id = request.param("workflowID", "");
        if (request.method() == RestRequest.Method.PUT && Intrinsics.areEqual((Object)"", (Object)id)) {
            throw AlertingException.Companion.wrap((Exception)new IllegalArgumentException("Missing workflow ID"));
        }
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Intrinsics.checkNotNull((Object)xcp);
        Intrinsics.checkNotNull((Object)id);
        Workflow workflow = Workflow.Companion.parse$default((Workflow.Companion)Workflow.Companion, (XContentParser)xcp, (String)id, (long)0L, (int)4, null);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Workflow workflow2 = Workflow.copy$default((Workflow)workflow, null, (long)0L, null, (boolean)false, null, (Instant)instant, null, null, null, (int)0, null, null, null, null, (int)16351, null);
        List rbacRoles = (List)request.contentParser().map().get("rbac_roles");
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNull((Object)refreshPolicy);
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        IndexWorkflowRequest workflowRequest = new IndexWorkflowRequest(id, seqNo, primaryTerm, refreshPolicy, method, workflow2, rbacRoles);
        return arg_0 -> RestIndexWorkflowAction.prepareRequest$lambda$0(client, workflowRequest, this, request, arg_0);
    }

    private final RestResponseListener<IndexWorkflowResponse> indexMonitorResponse(RestChannel channel, RestRequest.Method restMethod) {
        return (RestResponseListener)new RestResponseListener<IndexWorkflowResponse>(channel, restMethod){
            final /* synthetic */ RestChannel $channel;
            final /* synthetic */ RestRequest.Method $restMethod;
            {
                this.$channel = $channel;
                this.$restMethod = $restMethod;
                super($channel);
            }

            public RestResponse buildResponse(IndexWorkflowResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                RestStatus returnStatus = RestStatus.CREATED;
                if (this.$restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"newBuilder(...)");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response2.toXContent(xContentBuilder, params));
                if (returnStatus == RestStatus.CREATED) {
                    String location = AlertingPlugin.WORKFLOW_BASE_URI + "/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, IndexWorkflowRequest $workflowRequest, RestIndexWorkflowAction this$0, RestRequest $request, RestChannel channel) {
        ActionRequest actionRequest = (ActionRequest)$workflowRequest;
        Intrinsics.checkNotNull((Object)channel);
        RestRequest.Method method = $request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        $client.execute(AlertingActions.INDEX_WORKFLOW_ACTION_TYPE, actionRequest, (ActionListener)this$0.indexMonitorResponse(channel, method));
    }
}

