/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.DocValueFormat;

@PublicApi(since="1.0.0")
public class SearchSortValues
implements ToXContentFragment,
Writeable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final SearchSortValues EMPTY = new SearchSortValues(EMPTY_ARRAY);
    private final Object[] formattedSortValues;
    private final Object[] rawSortValues;

    SearchSortValues(Object[] sortValues) {
        this.formattedSortValues = Objects.requireNonNull(sortValues, "sort values must not be empty");
        this.rawSortValues = EMPTY_ARRAY;
    }

    public SearchSortValues(Object[] rawSortValues, DocValueFormat[] sortValueFormats) {
        Objects.requireNonNull(rawSortValues);
        Objects.requireNonNull(sortValueFormats);
        if (rawSortValues.length != sortValueFormats.length) {
            throw new IllegalArgumentException("formattedSortValues and sortValueFormats must hold the same number of items");
        }
        this.rawSortValues = rawSortValues;
        this.formattedSortValues = Arrays.copyOf(rawSortValues, rawSortValues.length);
        for (int i = 0; i < rawSortValues.length; ++i) {
            Object sortValue = rawSortValues[i];
            if (sortValue instanceof BytesRef) {
                BytesRef bytesRef = (BytesRef)sortValue;
                this.formattedSortValues[i] = sortValueFormats[i].format(bytesRef);
                continue;
            }
            if (sortValue instanceof Long) {
                Long longValue = (Long)sortValue;
                if (sortValueFormats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                    this.formattedSortValues[i] = sortValueFormats[i].format(longValue);
                    continue;
                }
            }
            if (sortValue instanceof Long) {
                Long longValue = (Long)sortValue;
                if (sortValueFormats[i] == DocValueFormat.UNSIGNED_LONG) {
                    this.formattedSortValues[i] = sortValueFormats[i].format(longValue);
                    continue;
                }
            }
            this.formattedSortValues[i] = sortValue;
        }
    }

    SearchSortValues(StreamInput in) throws IOException {
        this.formattedSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
        this.rawSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(Lucene::writeSortValue, this.formattedSortValues);
        out.writeArray(Lucene::writeSortValue, this.rawSortValues);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.formattedSortValues.length > 0) {
            builder.startArray("sort");
            for (Object sortValue : this.formattedSortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        return builder;
    }

    public static SearchSortValues fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return new SearchSortValues(parser.list().toArray());
    }

    public Object[] getFormattedSortValues() {
        return this.formattedSortValues;
    }

    public Object[] getRawSortValues() {
        return this.rawSortValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSortValues that = (SearchSortValues)o;
        return Arrays.equals(this.formattedSortValues, that.formattedSortValues) && Arrays.equals(this.rawSortValues, that.rawSortValues);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.formattedSortValues);
        result = 31 * result + Arrays.hashCode(this.rawSortValues);
        return result;
    }
}

