/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.cache.request;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class RequestCacheStats
implements Writeable,
ToXContentFragment {
    private long memorySize;
    private long evictions;
    private long hitCount;
    private long missCount;

    public RequestCacheStats() {
    }

    private RequestCacheStats(Builder builder) {
        this.memorySize = builder.memorySize;
        this.evictions = builder.evictions;
        this.hitCount = builder.hitCount;
        this.missCount = builder.missCount;
    }

    public RequestCacheStats(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        this.hitCount = in.readVLong();
        this.missCount = in.readVLong();
    }

    @Deprecated
    public RequestCacheStats(long memorySize, long evictions, long hitCount, long missCount) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.hitCount = hitCount;
        this.missCount = missCount;
    }

    public void add(RequestCacheStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        this.hitCount += stats.hitCount;
        this.missCount += stats.missCount;
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        out.writeVLong(this.hitCount);
        out.writeVLong(this.missCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("request_cache");
        builder.humanReadableField("memory_size_in_bytes", "memory_size", (Object)this.getMemorySize());
        builder.field("evictions", this.getEvictions());
        builder.field("hit_count", this.getHitCount());
        builder.field("miss_count", this.getMissCount());
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private long memorySize = 0L;
        private long evictions = 0L;
        private long hitCount = 0L;
        private long missCount = 0L;

        public Builder memorySize(long count) {
            this.memorySize = count;
            return this;
        }

        public Builder evictions(long count) {
            this.evictions = count;
            return this;
        }

        public Builder hitCount(long count) {
            this.hitCount = count;
            return this;
        }

        public Builder missCount(long count) {
            this.missCount = count;
            return this;
        }

        public RequestCacheStats build() {
            return new RequestCacheStats(this);
        }
    }

    static final class Fields {
        static final String REQUEST_CACHE_STATS = "request_cache";
        static final String MEMORY_SIZE = "memory_size";
        static final String MEMORY_SIZE_IN_BYTES = "memory_size_in_bytes";
        static final String EVICTIONS = "evictions";
        static final String HIT_COUNT = "hit_count";
        static final String MISS_COUNT = "miss_count";

        Fields() {
        }
    }
}

