/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.sandbox.index.MergeOnFlushMergePolicy;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSortConfig;
import org.opensearch.index.LogByteSizeMergePolicyProvider;
import org.opensearch.index.MergePolicyProvider;
import org.opensearch.index.MergeSchedulerConfig;
import org.opensearch.index.TieredMergePolicyProvider;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeIndexSettings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.node.Node;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.search.SearchService;

@PublicApi(since="1.0.0")
public final class IndexSettings {
    private static final String DEFAULT_POLICY = "default";
    private static final String MERGE_ON_FLUSH_MERGE_POLICY = "merge-on-flush";
    public static final Setting<List<String>> DEFAULT_FIELD_SETTING = Setting.listSetting("index.query.default_field", Collections.singletonList("*"), Function.identity(), Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> QUERY_STRING_LENIENT_SETTING = Setting.boolSetting("index.query_string.lenient", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> QUERY_STRING_ANALYZE_WILDCARD = Setting.boolSetting("indices.query.query_string.analyze_wildcard", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> QUERY_STRING_ALLOW_LEADING_WILDCARD = Setting.boolSetting("indices.query.query_string.allowLeadingWildcard", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_UNMAPPED = Setting.boolSetting("index.query.parse.allow_unmapped_fields", true, Setting.Property.IndexScope);
    public static final Setting<Boolean> ALLOW_DERIVED_FIELDS = Setting.boolSetting("index.query.derived_field.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_TRANSLOG_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.translog.sync_interval", TimeValue.timeValueSeconds((long)5L), TimeValue.timeValueMillis((long)100L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_PUBLISH_REFERENCED_SEGMENTS_INTERVAL_SETTING = Setting.timeSetting("index.segment_replication.publish_referenced_segments_interval", TimeValue.timeValueMinutes((long)10L), TimeValue.timeValueSeconds((long)1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_IDLE_AFTER = Setting.timeSetting("index.search.idle.after", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMinutes((long)0L), Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Translog.Durability> INDEX_TRANSLOG_DURABILITY_SETTING = new Setting<Translog.Durability>("index.translog.durability", Translog.Durability.REQUEST.name(), value -> Translog.Durability.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_WARMER_ENABLED_SETTING = Setting.boolSetting("index.warmer.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> INDEX_CHECK_ON_STARTUP = new Setting<String>("index.shard.check_on_startup", "false", s -> {
        switch (s) {
            case "false": 
            case "true": 
            case "checksum": {
                return s;
            }
        }
        throw new IllegalArgumentException("unknown value for [index.shard.check_on_startup] must be one of [true, false, checksum] but was: " + s);
    }, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_result_window", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_INNER_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_inner_result_window", 100, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SCRIPT_FIELDS_SETTING = Setting.intSetting("index.max_script_fields", 32, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_TOKEN_COUNT_SETTING = Setting.intSetting("index.analyze.max_token_count", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_ANALYZED_OFFSET_SETTING = Setting.intSetting("index.highlight.max_analyzed_offset", 1000000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_TERMS_COUNT_SETTING = Setting.intSetting("index.max_terms_count", 65536, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_NESTED_QUERY_DEPTH_SETTING = Setting.intSetting("index.query.max_nested_depth", 20, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_NGRAM_DIFF_SETTING = Setting.intSetting("index.max_ngram_diff", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SHINGLE_DIFF_SETTING = Setting.intSetting("index.max_shingle_diff", 3, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_DOCVALUE_FIELDS_SEARCH_SETTING = Setting.intSetting("index.max_docvalue_fields_search", 100, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESCORE_WINDOW_SETTING = Setting.intSetting("index.max_rescore_window", MAX_RESULT_WINDOW_SETTING, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_ADJACENCY_MATRIX_FILTERS_SETTING = Setting.intSetting("index.max_adjacency_matrix_filters", 100, 2, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    public static final TimeValue DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
    public static final TimeValue MINIMUM_REFRESH_INTERVAL = new TimeValue(-1L, TimeUnit.MILLISECONDS);
    public static final Setting<TimeValue> INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.refresh_interval", DEFAULT_REFRESH_INTERVAL, MINIMUM_REFRESH_INTERVAL, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_PERIODIC_FLUSH_INTERVAL = TimeValue.MINUS_ONE;
    public static final TimeValue MINIMUM_PERIODIC_FLUSH_INTERVAL = TimeValue.MINUS_ONE;
    public static final Setting<TimeValue> INDEX_PERIODIC_FLUSH_INTERVAL_SETTING = Setting.timeSetting("index.periodic_flush_interval", settings -> {
        String ingestionSourceType = IndexMetadata.INGESTION_SOURCE_TYPE_SETTING.get((Settings)settings);
        if (ingestionSourceType != null && !"none".equals(ingestionSourceType)) {
            return TimeValue.timeValueMinutes((long)10L);
        }
        return DEFAULT_PERIODIC_FLUSH_INTERVAL;
    }, MINIMUM_PERIODIC_FLUSH_INTERVAL, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue((long)(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1), ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.flush_after_merge", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue(0L, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.generation_threshold_size", new ByteSizeValue(64L, ByteSizeUnit.MB), new ByteSizeValue((long)(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1), ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_GC_DELETES = TimeValue.timeValueSeconds((long)60L);
    public static final Setting<TimeValue> INDEX_GC_DELETES_SETTING = Setting.timeSetting("index.gc_deletes", DEFAULT_GC_DELETES, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_SOFT_DELETES_SETTING = Setting.boolSetting("index.soft_deletes.enabled", true, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> INDEX_CONTEXT_AWARE_ENABLED_SETTING = Setting.boolSetting("index.context_aware.enabled", false, value -> {
        if (!FeatureFlags.isEnabled("opensearch.experimental.feature.context_aware.migration.enabled") && value.booleanValue()) {
            throw new IllegalArgumentException("FeatureFlag opensearch.experimental.feature.context_aware.migration.enabled must be enabled to set this property to true");
        }
    }, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Integer> INDEX_MAX_RETRY_ON_LOOKUP_MAP_LOCK_ACQUISITION_EXCEPTION = Setting.intSetting("index.context_aware.max_retry_on_lookup_map_acquisition_exception", 15, 5, 100, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Long> INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING = Setting.longSetting("index.soft_deletes.retention.operations", 0L, 0L, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> INDEX_TRANSLOG_RETENTION_AGE_SETTING = Setting.timeSetting("index.translog.retention.age", settings -> IndexSettings.shouldDisableTranslogRetention(settings) ? TimeValue.MINUS_ONE : TimeValue.timeValueHours((long)12L), TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_RETENTION_SIZE_SETTING = Setting.byteSizeSetting("index.translog.retention.size", settings -> IndexSettings.shouldDisableTranslogRetention(settings) ? "-1" : "512MB", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING = Setting.intSetting("index.translog.retention.total_files", 100, 0, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING = Setting.timeSetting("index.soft_deletes.retention_lease.period", TimeValue.timeValueHours((long)12L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_REFRESH_LISTENERS_PER_SHARD = Setting.intSetting("index.max_refresh_listeners", 1000, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SLICES_PER_SCROLL = Setting.intSetting("index.max_slices_per_scroll", 1024, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SLICES_PER_PIT = Setting.intSetting("index.max_slices_per_pit", 1024, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_REGEX_LENGTH_SETTING = Setting.intSetting("index.max_regex_length", 1000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> DEFAULT_PIPELINE = new Setting("index.default_pipeline", "_none", Function.identity(), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> FINAL_PIPELINE = new Setting("index.final_pipeline", "_none", Function.identity(), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_SEARCH_THROTTLED = Setting.boolSetting("index.search.throttled", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Dynamic);
    public static final Setting<Boolean> INDEX_UNREFERENCED_FILE_CLEANUP = Setting.boolSetting("index.unreferenced_file_cleanup.enabled", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Double> FILE_BASED_RECOVERY_THRESHOLD_SETTING = Setting.doubleSetting("index.recovery.file_based_threshold", 0.1, 0.0, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_MERGE_ON_FLUSH_MAX_FULL_FLUSH_MERGE_WAIT_TIME = Setting.timeSetting("index.merge_on_flush.max_full_flush_merge_wait_time", new TimeValue(10L, TimeUnit.SECONDS), new TimeValue(1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_MERGE_ON_FLUSH_ENABLED = Setting.boolSetting("index.merge_on_flush.enabled", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<String> INDEX_MERGE_ON_FLUSH_POLICY = Setting.simpleString("index.merge_on_flush.policy", "default", Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<String> INDEX_MERGE_POLICY = Setting.simpleString("index.merge.policy", "default", IndexMergePolicy::fromString, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_CHECK_PENDING_FLUSH_ENABLED = Setting.boolSetting("index.check_pending_flush.enabled", true, Setting.Property.IndexScope);
    public static final Setting<String> TIME_SERIES_INDEX_MERGE_POLICY = Setting.simpleString("indices.time_series_index.default_index_merge_policy", "default", IndexMergePolicy::fromString, Setting.Property.NodeScope);
    public static final Setting<String> SEARCHABLE_SNAPSHOT_REPOSITORY = Setting.simpleString("index.searchable_snapshot.repository", Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final Setting<String> SEARCHABLE_SNAPSHOT_ID_UUID = Setting.simpleString("index.searchable_snapshot.snapshot_id.uuid", Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final Setting<String> SEARCHABLE_SNAPSHOT_ID_NAME = Setting.simpleString("index.searchable_snapshot.snapshot_id.name", Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final Setting<String> SEARCHABLE_SNAPSHOT_INDEX_ID = Setting.simpleString("index.searchable_snapshot.index.id", Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final Setting<RemoteStoreEnums.PathType> SEARCHABLE_SNAPSHOT_SHARD_PATH_TYPE = new Setting<RemoteStoreEnums.PathType>("index.searchable_snapshot.shard_path_type", RemoteStoreEnums.PathType.FIXED.toString(), RemoteStoreEnums.PathType::parseString, Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final Setting<String> DEFAULT_SEARCH_PIPELINE = new Setting("index.search.default_pipeline", "_none", Function.identity(), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_CONCURRENT_SEGMENT_SEARCH_SETTING = Setting.boolSetting("index.search.concurrent_segment_search.enabled", false, Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.Deprecated);
    public static final Setting<String> INDEX_CONCURRENT_SEGMENT_SEARCH_MODE = Setting.simpleString("index.search.concurrent_segment_search.mode", "none", value -> {
        switch (value) {
            case "all": 
            case "none": 
            case "auto": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Setting value must be one of [all, none, auto]");
            }
        }
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_CONCURRENT_SEGMENT_SEARCH_MAX_SLICE_COUNT = Setting.intSetting("index.search.concurrent.max_slice_count", SearchService.CONCURRENT_SEGMENT_SEARCH_DEFAULT_SLICE_COUNT_VALUE, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_DOC_ID_FUZZY_SET_ENABLED_SETTING = Setting.boolSetting("index.optimize_doc_id_lookup.fuzzy_set.enabled", false, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Double> INDEX_DOC_ID_FUZZY_SET_FALSE_POSITIVE_PROBABILITY_SETTING = Setting.doubleSetting("index.optimize_doc_id_lookup.fuzzy_set.false_positive_probability", 0.2047, 0.01, 0.5, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final TimeValue DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL = new TimeValue(650L, TimeUnit.MILLISECONDS);
    public static final TimeValue MINIMUM_REMOTE_TRANSLOG_BUFFER_INTERVAL = TimeValue.ZERO;
    public static final Setting<TimeValue> INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING = Setting.timeSetting("index.remote_store.translog.buffer_interval", DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL, MINIMUM_REMOTE_TRANSLOG_BUFFER_INTERVAL, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_REMOTE_TRANSLOG_KEEP_EXTRA_GEN_SETTING = Setting.intSetting("index.remote_store.translog.keep_extra_gen", 100, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_CONTEXT_CREATED_VERSION = Setting.longSetting("index.context.created_version", 0L, 0L, Setting.Property.PrivateIndex, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_CONTEXT_CURRENT_VERSION = Setting.longSetting("index.context.current_version", 0L, 0L, Setting.Property.PrivateIndex, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_AUTO_FORCE_MERGES_ENABLED = Setting.boolSetting("index.auto_force_merge.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_DERIVED_SOURCE_SETTING = Setting.boolSetting("index.derived_source.enabled", false, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> INDEX_DERIVED_SOURCE_TRANSLOG_ENABLED_SETTING = Setting.boolSetting("index.derived_source.translog.enabled", INDEX_DERIVED_SOURCE_SETTING, Setting.Property.IndexScope, Setting.Property.Dynamic);
    private final Index index;
    private final Version version;
    private final Logger logger;
    private final String nodeName;
    private final Settings nodeSettings;
    private final int numberOfShards;
    private final ReplicationType replicationType;
    private volatile boolean isRemoteStoreEnabled;
    private final boolean isWarmIndex;
    private volatile TimeValue remoteTranslogUploadBufferInterval;
    private volatile String remoteStoreTranslogRepository;
    private volatile String remoteStoreRepository;
    private volatile String remoteStoreSegmentPathPrefix;
    private int remoteTranslogKeepExtraGen;
    private boolean autoForcemergeEnabled;
    private volatile Settings settings;
    private volatile IndexMetadata indexMetadata;
    private volatile List<String> defaultFields;
    private final boolean queryStringLenient;
    private final boolean queryStringAnalyzeWildcard;
    private final boolean queryStringAllowLeadingWildcard;
    private final boolean defaultAllowUnmappedFields;
    private volatile Translog.Durability durability;
    private volatile TimeValue syncInterval;
    private volatile TimeValue publishReferencedSegmentsInterval;
    private volatile TimeValue refreshInterval;
    private volatile TimeValue periodicFlushInterval;
    private volatile ByteSizeValue flushThresholdSize;
    private volatile TimeValue translogRetentionAge;
    private volatile ByteSizeValue translogRetentionSize;
    private volatile ByteSizeValue generationThresholdSize;
    private volatile ByteSizeValue flushAfterMergeThresholdSize;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final TieredMergePolicyProvider tieredMergePolicyProvider;
    private final LogByteSizeMergePolicyProvider logByteSizeMergePolicyProvider;
    private final IndexSortConfig indexSortConfig;
    private final IndexScopedSettings scopedSettings;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private final boolean softDeleteEnabled;
    private final boolean contextAwareEnabled;
    private int maxRetryOnLookupMapAcquisitionException;
    private volatile long softDeleteRetentionOperations;
    private volatile long retentionLeaseMillis;
    private volatile String defaultSearchPipeline;
    private final boolean widenIndexSortType;
    private final boolean assignedOnRemoteNode;
    private final RemoteStorePathStrategy remoteStorePathStrategy;
    private final boolean isTranslogMetadataEnabled;
    private volatile boolean allowDerivedField;
    private final boolean derivedSourceEnabled;
    private volatile boolean derivedSourceEnabledForTranslog;
    private volatile boolean warmerEnabled;
    private volatile int maxResultWindow;
    private volatile int maxInnerResultWindow;
    private volatile int maxAdjacencyMatrixFilters;
    private volatile int maxRescoreWindow;
    private volatile int maxDocvalueFields;
    private volatile int maxScriptFields;
    private volatile int maxTokenCount;
    private volatile int maxNgramDiff;
    private volatile int maxShingleDiff;
    private volatile TimeValue searchIdleAfter;
    private volatile int maxAnalyzedOffset;
    private volatile int maxTermsCount;
    private volatile int maxNestedQueryDepth;
    private volatile String defaultPipeline;
    private volatile String requiredPipeline;
    private volatile boolean searchThrottled;
    private volatile boolean shouldCleanupUnreferencedFiles;
    private volatile long mappingNestedFieldsLimit;
    private volatile long mappingNestedDocsLimit;
    private volatile long mappingTotalFieldsLimit;
    private volatile long mappingDepthLimit;
    private volatile long mappingFieldNameLengthLimit;
    private volatile int maxRefreshListeners;
    private volatile int maxSlicesPerScroll;
    private volatile int maxSlicesPerPit;
    private volatile int maxRegexLength;
    private volatile TimeValue maxFullFlushMergeWaitTime;
    private volatile boolean mergeOnFlushEnabled;
    private volatile UnaryOperator<MergePolicy> mergeOnFlushPolicy;
    private final boolean checkPendingFlushEnabled;
    private volatile boolean enableFuzzySetForDocId;
    private volatile double docIdFuzzySetFalsePositiveProbability;
    private final boolean isCompositeIndex;
    private volatile boolean isStarTreeIndexEnabled;

    public long getRetentionLeaseMillis() {
        return this.retentionLeaseMillis;
    }

    private void setRetentionLeaseMillis(TimeValue retentionLease) {
        this.retentionLeaseMillis = retentionLease.millis();
    }

    public List<String> getDefaultFields() {
        return this.defaultFields;
    }

    private void setDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
    }

    private void setAllowDerivedField(boolean allowDerivedField) {
        this.allowDerivedField = allowDerivedField;
    }

    public boolean isQueryStringLenient() {
        return this.queryStringLenient;
    }

    public boolean isQueryStringAnalyzeWildcard() {
        return this.queryStringAnalyzeWildcard;
    }

    public boolean isQueryStringAllowLeadingWildcard() {
        return this.queryStringAllowLeadingWildcard;
    }

    public boolean isDefaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public boolean isDerivedFieldAllowed() {
        return this.allowDerivedField;
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings) {
        this(indexMetadata, nodeSettings, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings, IndexScopedSettings indexScopedSettings) {
        this.scopedSettings = indexScopedSettings.copy(nodeSettings, indexMetadata);
        this.nodeSettings = nodeSettings;
        this.settings = Settings.builder().put(nodeSettings).put(indexMetadata.getSettings()).build();
        this.index = indexMetadata.getIndex();
        this.version = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(this.settings);
        this.logger = Loggers.getLogger(this.getClass(), this.index, new String[0]);
        this.nodeName = Node.NODE_NAME_SETTING.get(this.settings);
        this.indexMetadata = indexMetadata;
        this.numberOfShards = this.settings.getAsInt("index.number_of_shards", null);
        this.replicationType = IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.get(this.settings);
        this.isRemoteStoreEnabled = this.settings.getAsBoolean("index.remote_store.enabled", false);
        this.isWarmIndex = this.settings.getAsBoolean(IndexModule.IS_WARM_INDEX_SETTING.getKey(), false);
        this.remoteStoreTranslogRepository = this.settings.get("index.remote_store.translog.repository");
        this.remoteTranslogUploadBufferInterval = INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.get(this.settings);
        this.remoteStoreRepository = this.settings.get("index.remote_store.segment.repository");
        this.remoteTranslogKeepExtraGen = INDEX_REMOTE_TRANSLOG_KEEP_EXTRA_GEN_SETTING.get(this.settings);
        String rawPrefix = IndexMetadata.INDEX_REMOTE_STORE_SEGMENT_PATH_PREFIX.get(this.settings);
        this.remoteStoreSegmentPathPrefix = rawPrefix != null && !rawPrefix.trim().isEmpty() ? rawPrefix : null;
        this.searchThrottled = INDEX_SEARCH_THROTTLED.get(this.settings);
        this.shouldCleanupUnreferencedFiles = INDEX_UNREFERENCED_FILE_CLEANUP.get(this.settings);
        this.queryStringLenient = QUERY_STRING_LENIENT_SETTING.get(this.settings);
        this.queryStringAnalyzeWildcard = QUERY_STRING_ANALYZE_WILDCARD.get(nodeSettings);
        this.queryStringAllowLeadingWildcard = QUERY_STRING_ALLOW_LEADING_WILDCARD.get(nodeSettings);
        this.defaultAllowUnmappedFields = this.scopedSettings.get(ALLOW_UNMAPPED);
        this.allowDerivedField = this.scopedSettings.get(ALLOW_DERIVED_FIELDS);
        this.durability = this.scopedSettings.get(INDEX_TRANSLOG_DURABILITY_SETTING);
        this.defaultFields = this.scopedSettings.get(DEFAULT_FIELD_SETTING);
        this.syncInterval = INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.get(this.settings);
        this.publishReferencedSegmentsInterval = INDEX_PUBLISH_REFERENCED_SEGMENTS_INTERVAL_SETTING.get(this.settings);
        this.refreshInterval = this.scopedSettings.get(INDEX_REFRESH_INTERVAL_SETTING);
        this.periodicFlushInterval = this.scopedSettings.get(INDEX_PERIODIC_FLUSH_INTERVAL_SETTING);
        this.flushThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        this.generationThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        this.flushAfterMergeThresholdSize = this.scopedSettings.get(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING);
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this);
        this.gcDeletesInMillis = this.scopedSettings.get(INDEX_GC_DELETES_SETTING).getMillis();
        this.softDeleteEnabled = this.scopedSettings.get(INDEX_SOFT_DELETES_SETTING);
        this.contextAwareEnabled = this.scopedSettings.get(INDEX_CONTEXT_AWARE_ENABLED_SETTING);
        this.maxRetryOnLookupMapAcquisitionException = this.scopedSettings.get(INDEX_MAX_RETRY_ON_LOOKUP_MAP_LOCK_ACQUISITION_EXCEPTION);
        assert (this.softDeleteEnabled || this.version.before(Version.V_2_0_0)) : "soft deletes must be enabled in version " + String.valueOf(this.version);
        this.softDeleteRetentionOperations = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING);
        this.retentionLeaseMillis = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING).millis();
        this.warmerEnabled = this.scopedSettings.get(INDEX_WARMER_ENABLED_SETTING);
        this.maxResultWindow = this.scopedSettings.get(MAX_RESULT_WINDOW_SETTING);
        this.maxInnerResultWindow = this.scopedSettings.get(MAX_INNER_RESULT_WINDOW_SETTING);
        this.maxAdjacencyMatrixFilters = this.scopedSettings.get(MAX_ADJACENCY_MATRIX_FILTERS_SETTING);
        this.maxRescoreWindow = this.scopedSettings.get(MAX_RESCORE_WINDOW_SETTING);
        this.maxDocvalueFields = this.scopedSettings.get(MAX_DOCVALUE_FIELDS_SEARCH_SETTING);
        this.maxScriptFields = this.scopedSettings.get(MAX_SCRIPT_FIELDS_SETTING);
        this.maxTokenCount = this.scopedSettings.get(MAX_TOKEN_COUNT_SETTING);
        this.maxNgramDiff = this.scopedSettings.get(MAX_NGRAM_DIFF_SETTING);
        this.maxShingleDiff = this.scopedSettings.get(MAX_SHINGLE_DIFF_SETTING);
        this.maxRefreshListeners = this.scopedSettings.get(MAX_REFRESH_LISTENERS_PER_SHARD);
        this.maxSlicesPerScroll = this.scopedSettings.get(MAX_SLICES_PER_SCROLL);
        this.maxSlicesPerPit = this.scopedSettings.get(MAX_SLICES_PER_PIT);
        this.maxAnalyzedOffset = this.scopedSettings.get(MAX_ANALYZED_OFFSET_SETTING);
        this.maxTermsCount = this.scopedSettings.get(MAX_TERMS_COUNT_SETTING);
        this.maxNestedQueryDepth = this.scopedSettings.get(MAX_NESTED_QUERY_DEPTH_SETTING);
        this.maxRegexLength = this.scopedSettings.get(MAX_REGEX_LENGTH_SETTING);
        this.tieredMergePolicyProvider = new TieredMergePolicyProvider(this.logger, this);
        this.logByteSizeMergePolicyProvider = new LogByteSizeMergePolicyProvider(this.logger, this);
        this.indexSortConfig = new IndexSortConfig(this);
        this.searchIdleAfter = this.scopedSettings.get(INDEX_SEARCH_IDLE_AFTER);
        this.defaultPipeline = this.scopedSettings.get(DEFAULT_PIPELINE);
        this.setTranslogRetentionAge(this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_AGE_SETTING));
        this.setTranslogRetentionSize(this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_SIZE_SETTING));
        this.mappingNestedFieldsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING);
        this.mappingNestedDocsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING);
        this.mappingTotalFieldsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        this.mappingDepthLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        this.mappingFieldNameLengthLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING);
        this.maxFullFlushMergeWaitTime = this.scopedSettings.get(INDEX_MERGE_ON_FLUSH_MAX_FULL_FLUSH_MERGE_WAIT_TIME);
        this.mergeOnFlushEnabled = this.scopedSettings.get(INDEX_MERGE_ON_FLUSH_ENABLED);
        this.setMergeOnFlushPolicy(this.scopedSettings.get(INDEX_MERGE_ON_FLUSH_POLICY));
        this.checkPendingFlushEnabled = this.scopedSettings.get(INDEX_CHECK_PENDING_FLUSH_ENABLED);
        this.defaultSearchPipeline = this.scopedSettings.get(DEFAULT_SEARCH_PIPELINE);
        this.derivedSourceEnabled = this.scopedSettings.get(INDEX_DERIVED_SOURCE_SETTING);
        this.derivedSourceEnabledForTranslog = this.scopedSettings.get(INDEX_DERIVED_SOURCE_TRANSLOG_ENABLED_SETTING);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_DERIVED_SOURCE_TRANSLOG_ENABLED_SETTING, this::setDerivedSourceEnabledForTranslog);
        this.widenIndexSortType = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(this.settings).before(Version.V_2_7_0);
        this.assignedOnRemoteNode = RemoteStoreNodeAttribute.isRemoteDataAttributePresent(this.getNodeSettings());
        this.remoteStorePathStrategy = RemoteStoreUtils.determineRemoteStorePathStrategy(indexMetadata);
        this.isTranslogMetadataEnabled = RemoteStoreUtils.determineTranslogMetadataEnabled(indexMetadata);
        this.setEnableFuzzySetForDocId(this.scopedSettings.get(INDEX_DOC_ID_FUZZY_SET_ENABLED_SETTING));
        this.setDocIdFuzzySetFalsePositiveProbability(this.scopedSettings.get(INDEX_DOC_ID_FUZZY_SET_FALSE_POSITIVE_PROBABILITY_SETTING));
        this.isCompositeIndex = this.scopedSettings.get(StarTreeIndexSettings.IS_COMPOSITE_INDEX_SETTING);
        this.isStarTreeIndexEnabled = this.scopedSettings.get(StarTreeIndexSettings.STAR_TREE_SEARCH_ENABLED_SETTING);
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_COMPOUND_FORMAT_SETTING, this.tieredMergePolicyProvider::setNoCFSRatio);
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING, this.tieredMergePolicyProvider::setDeletesPctAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, this.tieredMergePolicyProvider::setExpungeDeletesAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, this.tieredMergePolicyProvider::setFloorSegmentSetting);
        this.scopedSettings.addSettingsUpdateConsumer(this::updateMaxMergesAtOnce, List.of(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING));
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, this.tieredMergePolicyProvider::setMaxMergedSegment);
        this.scopedSettings.addSettingsUpdateConsumer(TieredMergePolicyProvider.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, this.tieredMergePolicyProvider::setSegmentsPerTier);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_MERGE_POLICY_MERGE_FACTOR_SETTING, this.logByteSizeMergePolicyProvider::setLBSMergeFactor);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_MERGE_POLICY_MIN_MERGE_SETTING, this.logByteSizeMergePolicyProvider::setLBSMinMergedMB);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_MAX_MERGE_SEGMENT_SETTING, this.logByteSizeMergePolicyProvider::setLBSMaxMergeSegment);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_MAX_MERGE_SEGMENT_FOR_FORCED_MERGE_SETTING, this.logByteSizeMergePolicyProvider::setLBSMaxMergeMBForForcedMerge);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_MAX_MERGED_DOCS_SETTING, this.logByteSizeMergePolicyProvider::setLBSMaxMergeDocs);
        this.scopedSettings.addSettingsUpdateConsumer(LogByteSizeMergePolicyProvider.INDEX_LBS_NO_CFS_RATIO_SETTING, this.logByteSizeMergePolicyProvider::setLBSNoCFSRatio);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, this.mergeSchedulerConfig::setMaxThreadAndMergeCount);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.AUTO_THROTTLE_SETTING, this.mergeSchedulerConfig::setAutoThrottle);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_FORCE_MERGE_MB_PER_SEC_SETTING, value -> this.mergeSchedulerConfig.updateMaxForceMergeMBPerSec(this));
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_DURABILITY_SETTING, this::setTranslogDurability);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_SYNC_INTERVAL_SETTING, this::setTranslogSyncInterval);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_PUBLISH_REFERENCED_SEGMENTS_INTERVAL_SETTING, this::setPublishReferencedSegmentsInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESULT_WINDOW_SETTING, this::setMaxResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_INNER_RESULT_WINDOW_SETTING, this::setMaxInnerResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_ADJACENCY_MATRIX_FILTERS_SETTING, this::setMaxAdjacencyMatrixFilters);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESCORE_WINDOW_SETTING, this::setMaxRescoreWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_DOCVALUE_FIELDS_SEARCH_SETTING, this::setMaxDocvalueFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SCRIPT_FIELDS_SETTING, this::setMaxScriptFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_TOKEN_COUNT_SETTING, this::setMaxTokenCount);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_NGRAM_DIFF_SETTING, this::setMaxNgramDiff);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SHINGLE_DIFF_SETTING, this::setMaxShingleDiff);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_WARMER_ENABLED_SETTING, this::setEnableWarmer);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_GC_DELETES_SETTING, this::setGCDeletes);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, this::setTranslogFlushThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING, this::setFlushAfterMergeThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING, this::setGenerationThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_AGE_SETTING, this::setTranslogRetentionAge);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_SIZE_SETTING, this::setTranslogRetentionSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_PERIODIC_FLUSH_INTERVAL_SETTING, this::setPeriodicFlushInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REFRESH_LISTENERS_PER_SHARD, this::setMaxRefreshListeners);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_ANALYZED_OFFSET_SETTING, this::setHighlightMaxAnalyzedOffset);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_TERMS_COUNT_SETTING, this::setMaxTermsCount);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_NESTED_QUERY_DEPTH_SETTING, this::setMaxNestedQueryDepth);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SLICES_PER_SCROLL, this::setMaxSlicesPerScroll);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SLICES_PER_PIT, this::setMaxSlicesPerPit);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_FIELD_SETTING, this::setDefaultFields);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SEARCH_IDLE_AFTER, this::setSearchIdleAfter);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REGEX_LENGTH_SETTING, this::setMaxRegexLength);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_PIPELINE, this::setDefaultPipeline);
        this.scopedSettings.addSettingsUpdateConsumer(FINAL_PIPELINE, this::setRequiredPipeline);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING, this::setSoftDeleteRetentionOperations);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SEARCH_THROTTLED, this::setSearchThrottled);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_UNREFERENCED_FILE_CLEANUP, this::setShouldCleanupUnreferencedFiles);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, this::setRetentionLeaseMillis);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING, this::setMappingNestedFieldsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING, this::setMappingNestedDocsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING, this::setMappingTotalFieldsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING, this::setMappingDepthLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING, this::setMappingFieldNameLengthLimit);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_MERGE_ON_FLUSH_MAX_FULL_FLUSH_MERGE_WAIT_TIME, this::setMaxFullFlushMergeWaitTime);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_MERGE_ON_FLUSH_ENABLED, this::setMergeOnFlushEnabled);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_MERGE_ON_FLUSH_POLICY, this::setMergeOnFlushPolicy);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_SEARCH_PIPELINE, this::setDefaultSearchPipeline);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_MAX_RETRY_ON_LOOKUP_MAP_LOCK_ACQUISITION_EXCEPTION, this::setMaxRetryOnLookupMapAcquisitionException);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING, this::setRemoteTranslogUploadBufferInterval);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REMOTE_TRANSLOG_KEEP_EXTRA_GEN_SETTING, this::setRemoteTranslogKeepExtraGen);
        this.autoForcemergeEnabled = this.scopedSettings.get(INDEX_AUTO_FORCE_MERGES_ENABLED);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_AUTO_FORCE_MERGES_ENABLED, this::setAutoForcemergeEnabled);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_DOC_ID_FUZZY_SET_ENABLED_SETTING, this::setEnableFuzzySetForDocId);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_DOC_ID_FUZZY_SET_FALSE_POSITIVE_PROBABILITY_SETTING, this::setDocIdFuzzySetFalsePositiveProbability);
        this.scopedSettings.addSettingsUpdateConsumer(ALLOW_DERIVED_FIELDS, this::setAllowDerivedField);
        this.scopedSettings.addSettingsUpdateConsumer(IndexMetadata.INDEX_REMOTE_STORE_ENABLED_SETTING, this::setRemoteStoreEnabled);
        this.scopedSettings.addSettingsUpdateConsumer(IndexMetadata.INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING, this::setRemoteStoreRepository);
        this.scopedSettings.addSettingsUpdateConsumer(IndexMetadata.INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING, this::setRemoteStoreTranslogRepository);
        this.scopedSettings.addSettingsUpdateConsumer(StarTreeIndexSettings.STAR_TREE_SEARCH_ENABLED_SETTING, this::setStarTreeIndexEnabled);
    }

    private void setSearchIdleAfter(TimeValue searchIdleAfter) {
        if (this.isRemoteStoreEnabled) {
            this.logger.warn("Search idle is not supported for remote backed indices");
        }
        if (this.replicationType == ReplicationType.SEGMENT && this.getNumberOfReplicas() > 0) {
            this.logger.warn("Search idle is not supported for indices with replicas using 'replication.type: SEGMENT'");
        }
        this.searchIdleAfter = searchIdleAfter;
    }

    private void setTranslogFlushThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushThresholdSize = byteSizeValue;
    }

    private void setFlushAfterMergeThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushAfterMergeThresholdSize = byteSizeValue;
    }

    private void setTranslogRetentionSize(ByteSizeValue byteSizeValue) {
        this.translogRetentionSize = IndexSettings.shouldDisableTranslogRetention(this.settings) && byteSizeValue.getBytes() >= 0L ? new ByteSizeValue(-1L) : byteSizeValue;
    }

    private void setTranslogRetentionAge(TimeValue age) {
        this.translogRetentionAge = IndexSettings.shouldDisableTranslogRetention(this.settings) && age.millis() >= 0L ? TimeValue.MINUS_ONE : age;
    }

    private void setGenerationThresholdSize(ByteSizeValue generationThresholdSize) {
        this.generationThresholdSize = generationThresholdSize;
    }

    private void setGCDeletes(TimeValue timeValue) {
        this.gcDeletesInMillis = timeValue.getMillis();
    }

    private void setRefreshInterval(TimeValue timeValue) {
        this.refreshInterval = timeValue;
    }

    private void setPeriodicFlushInterval(TimeValue timeValue) {
        this.periodicFlushInterval = timeValue;
    }

    void setDefaultMaxMergesAtOnce(int newDefaultMaxMergesAtOnce) {
        this.tieredMergePolicyProvider.setDefaultMaxMergesAtOnce(newDefaultMaxMergesAtOnce);
        if (!TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING.exists(this.getSettings())) {
            this.tieredMergePolicyProvider.setMaxMergesAtOnceToDefault();
        }
    }

    void setDefaultMaxThreadAndMergeCount(int maxThreadCount, int maxMergeCount) {
        boolean overrideExistingConfigs = !MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING.exists(this.getSettings()) && !MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING.exists(this.getSettings());
        this.mergeSchedulerConfig.setDefaultMaxThreadAndMergeCount(maxThreadCount, maxMergeCount, overrideExistingConfigs);
    }

    void setDefaultAutoThrottleEnabled(boolean enabled) {
        this.mergeSchedulerConfig.setDefaultAutoThrottleEnabled(enabled, !MergeSchedulerConfig.AUTO_THROTTLE_SETTING.exists(this.getSettings()));
    }

    void updateMaxMergesAtOnce(Settings updatedSettings) {
        if (!TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING.exists(updatedSettings)) {
            this.logger.debug("Resetting maxMergesAtOnce to cluster default");
            this.tieredMergePolicyProvider.setMaxMergesAtOnceToDefault();
        } else {
            this.tieredMergePolicyProvider.setMaxMergesAtOnce(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING.get(updatedSettings));
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getUUID() {
        return this.getIndex().getUUID();
    }

    public boolean hasCustomDataPath() {
        return !Strings.isEmpty((CharSequence)this.customDataPath());
    }

    public String customDataPath() {
        return IndexMetadata.INDEX_DATA_PATH_SETTING.get(this.settings);
    }

    public Version getIndexVersionCreated() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.settings.getAsInt("index.number_of_replicas", null);
    }

    public boolean isCompositeIndex() {
        return this.isCompositeIndex;
    }

    public boolean isSegRepEnabledOrRemoteNode() {
        return ReplicationType.SEGMENT.equals((Object)this.replicationType) || this.isAssignedOnRemoteNode();
    }

    public boolean isSegRepLocalEnabled() {
        return ReplicationType.SEGMENT.equals((Object)this.replicationType) && !this.isRemoteStoreEnabled();
    }

    public boolean isDocumentReplication() {
        return ReplicationType.DOCUMENT.equals((Object)this.replicationType);
    }

    public boolean isRemoteStoreEnabled() {
        return this.isRemoteStoreEnabled;
    }

    public boolean isAssignedOnRemoteNode() {
        return this.assignedOnRemoteNode;
    }

    public boolean isRemoteTranslogStoreEnabled() {
        return this.remoteStoreTranslogRepository != null && !this.remoteStoreTranslogRepository.isEmpty();
    }

    public String getRemoteStoreRepository() {
        return this.remoteStoreRepository;
    }

    public String getRemoteStoreTranslogRepository() {
        return this.remoteStoreTranslogRepository;
    }

    public String getRemoteStoreSegmentPathPrefix() {
        return this.remoteStoreSegmentPathPrefix;
    }

    public boolean isWarmIndex() {
        return this.isWarmIndex;
    }

    public boolean isRemoteSnapshot() {
        return this.indexMetadata.isRemoteSnapshot();
    }

    @Deprecated
    public Version getExtendedCompatibilitySnapshotVersion() {
        throw new UnsupportedOperationException("Experimental feature has been removed");
    }

    public Settings getNodeSettings() {
        return this.nodeSettings;
    }

    public synchronized boolean updateIndexMetadata(IndexMetadata indexMetadata) {
        String restoreUUID;
        Settings newSettings = indexMetadata.getSettings();
        if (!this.version.equals((Object)IndexMetadata.indexCreated(newSettings))) {
            throw new IllegalArgumentException("version mismatch on settings update expected: " + String.valueOf(this.version) + " but was: " + String.valueOf(IndexMetadata.indexCreated(newSettings)));
        }
        String newUUID = newSettings.get("index.uuid", "_na_");
        if (!newUUID.equals(this.getUUID())) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + this.getUUID() + " but was: " + newUUID);
        }
        String newRestoreUUID = newSettings.get("index.history.uuid", "_na_");
        if (!newRestoreUUID.equals(restoreUUID = this.settings.get("index.history.uuid", "_na_"))) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + restoreUUID + " but was: " + newRestoreUUID);
        }
        this.indexMetadata = indexMetadata;
        Settings newIndexSettings = Settings.builder().put(this.nodeSettings).put(newSettings).build();
        if (IndexSettings.same(this.settings, newIndexSettings)) {
            return false;
        }
        this.scopedSettings.applySettings(newSettings);
        this.settings = newIndexSettings;
        return true;
    }

    public static boolean same(Settings left, Settings right) {
        return left.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE).equals(right.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE)) && left.filter(IndexScopedSettings.ARCHIVED_SETTINGS_KEY_PREDICATE).equals(right.filter(IndexScopedSettings.ARCHIVED_SETTINGS_KEY_PREDICATE));
    }

    public Translog.Durability getTranslogDurability() {
        return this.durability;
    }

    private void setTranslogDurability(Translog.Durability durability) {
        this.durability = durability;
    }

    public boolean isWarmerEnabled() {
        return this.warmerEnabled;
    }

    private void setEnableWarmer(boolean enableWarmer) {
        this.warmerEnabled = enableWarmer;
    }

    public TimeValue getTranslogSyncInterval() {
        return this.syncInterval;
    }

    public void setTranslogSyncInterval(TimeValue translogSyncInterval) {
        this.syncInterval = translogSyncInterval;
    }

    public TimeValue getPublishReferencedSegmentsInterval() {
        return this.publishReferencedSegmentsInterval;
    }

    public void setPublishReferencedSegmentsInterval(TimeValue publishReferencedSegmentsInterval) {
        this.publishReferencedSegmentsInterval = publishReferencedSegmentsInterval;
    }

    public TimeValue getRemoteTranslogUploadBufferInterval() {
        return this.remoteTranslogUploadBufferInterval;
    }

    public int getRemoteTranslogExtraKeep() {
        return this.remoteTranslogKeepExtraGen;
    }

    public boolean isRemoteTranslogBufferIntervalExplicit() {
        return INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.exists(this.settings);
    }

    public void setRemoteTranslogUploadBufferInterval(TimeValue remoteTranslogUploadBufferInterval) {
        this.remoteTranslogUploadBufferInterval = remoteTranslogUploadBufferInterval;
    }

    public void setRemoteTranslogKeepExtraGen(int extraGen) {
        this.remoteTranslogKeepExtraGen = extraGen;
    }

    public void setAutoForcemergeEnabled(boolean autoForcemergeEnabled) {
        this.autoForcemergeEnabled = autoForcemergeEnabled;
    }

    public boolean isAutoForcemergeEnabled() {
        return this.autoForcemergeEnabled;
    }

    public TimeValue getRefreshInterval() {
        return this.refreshInterval;
    }

    public TimeValue getPeriodicFlushInterval() {
        return this.periodicFlushInterval;
    }

    public ByteSizeValue getFlushThresholdSize() {
        return this.flushThresholdSize;
    }

    public ByteSizeValue getFlushAfterMergeThresholdSize() {
        return this.flushAfterMergeThresholdSize;
    }

    public ByteSizeValue getTranslogRetentionSize() {
        assert (!IndexSettings.shouldDisableTranslogRetention(this.settings) || this.translogRetentionSize.getBytes() == -1L) : this.translogRetentionSize;
        return this.translogRetentionSize;
    }

    public TimeValue getTranslogRetentionAge() {
        assert (!IndexSettings.shouldDisableTranslogRetention(this.settings) || this.translogRetentionAge.millis() == -1L) : this.translogRetentionSize;
        return this.translogRetentionAge;
    }

    public int getTranslogRetentionTotalFiles() {
        return INDEX_TRANSLOG_RETENTION_TOTAL_FILES_SETTING.get(this.getSettings());
    }

    private static boolean shouldDisableTranslogRetention(Settings settings) {
        return INDEX_SOFT_DELETES_SETTING.get(settings);
    }

    public ByteSizeValue getGenerationThresholdSize() {
        return this.generationThresholdSize;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public int getMaxResultWindow() {
        return this.maxResultWindow;
    }

    private void setMaxResultWindow(int maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }

    public int getMaxInnerResultWindow() {
        return this.maxInnerResultWindow;
    }

    private void setMaxInnerResultWindow(int maxInnerResultWindow) {
        this.maxInnerResultWindow = maxInnerResultWindow;
    }

    @Deprecated
    public int getMaxAdjacencyMatrixFilters() {
        return this.maxAdjacencyMatrixFilters;
    }

    @Deprecated
    private void setMaxAdjacencyMatrixFilters(int maxAdjacencyFilters) {
        this.maxAdjacencyMatrixFilters = maxAdjacencyFilters;
    }

    public int getMaxRescoreWindow() {
        return this.maxRescoreWindow;
    }

    private void setMaxRescoreWindow(int maxRescoreWindow) {
        this.maxRescoreWindow = maxRescoreWindow;
    }

    public int getMaxDocvalueFields() {
        return this.maxDocvalueFields;
    }

    private void setMaxDocvalueFields(int maxDocvalueFields) {
        this.maxDocvalueFields = maxDocvalueFields;
    }

    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    private void setMaxTokenCount(int maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
    }

    public int getMaxNgramDiff() {
        return this.maxNgramDiff;
    }

    private void setMaxNgramDiff(int maxNgramDiff) {
        this.maxNgramDiff = maxNgramDiff;
    }

    public int getMaxShingleDiff() {
        return this.maxShingleDiff;
    }

    private void setMaxShingleDiff(int maxShingleDiff) {
        this.maxShingleDiff = maxShingleDiff;
    }

    public int getHighlightMaxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    private void setHighlightMaxAnalyzedOffset(int maxAnalyzedOffset) {
        this.maxAnalyzedOffset = maxAnalyzedOffset;
    }

    public int getMaxTermsCount() {
        return this.maxTermsCount;
    }

    private void setMaxTermsCount(int maxTermsCount) {
        this.maxTermsCount = maxTermsCount;
    }

    public int getMaxNestedQueryDepth() {
        return this.maxNestedQueryDepth;
    }

    private void setMaxNestedQueryDepth(int maxNestedQueryDepth) {
        this.maxNestedQueryDepth = maxNestedQueryDepth;
    }

    public int getMaxScriptFields() {
        return this.maxScriptFields;
    }

    private void setMaxScriptFields(int maxScriptFields) {
        this.maxScriptFields = maxScriptFields;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public void setStarTreeIndexEnabled(boolean value) {
        this.isStarTreeIndexEnabled = value;
    }

    public boolean getStarTreeIndexEnabled() {
        return this.isStarTreeIndexEnabled;
    }

    public MergePolicy getMergePolicy(boolean isTimeSeriesIndex) {
        String indexScopedPolicy = this.scopedSettings.get(INDEX_MERGE_POLICY);
        MergePolicyProvider mergePolicyProvider = null;
        IndexMergePolicy indexMergePolicy = IndexMergePolicy.fromString(indexScopedPolicy);
        switch (indexMergePolicy.ordinal()) {
            case 0: {
                mergePolicyProvider = this.tieredMergePolicyProvider;
                break;
            }
            case 1: {
                mergePolicyProvider = this.logByteSizeMergePolicyProvider;
                break;
            }
            case 2: {
                if (isTimeSeriesIndex) {
                    String nodeScopedTimeSeriesIndexPolicy = TIME_SERIES_INDEX_MERGE_POLICY.get(this.nodeSettings);
                    IndexMergePolicy nodeMergePolicy = IndexMergePolicy.fromString(nodeScopedTimeSeriesIndexPolicy);
                    switch (nodeMergePolicy.ordinal()) {
                        case 0: 
                        case 2: {
                            mergePolicyProvider = this.tieredMergePolicyProvider;
                            break;
                        }
                        case 1: {
                            mergePolicyProvider = this.logByteSizeMergePolicyProvider;
                        }
                    }
                    break;
                }
                mergePolicyProvider = this.tieredMergePolicyProvider;
            }
        }
        assert (mergePolicyProvider != null) : "should not happen as validation for invalid merge policy values are part of setting definition";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Index: " + this.index.getName() + ", Merge policy used: " + String.valueOf(mergePolicyProvider));
        }
        return mergePolicyProvider.getMergePolicy();
    }

    public <T> T getValue(Setting<T> setting) {
        return this.scopedSettings.get(setting);
    }

    public int getMaxRefreshListeners() {
        return this.maxRefreshListeners;
    }

    private void setMaxRefreshListeners(int maxRefreshListeners) {
        this.maxRefreshListeners = maxRefreshListeners;
    }

    public int getMaxSlicesPerScroll() {
        return this.maxSlicesPerScroll;
    }

    private void setMaxSlicesPerScroll(int value) {
        this.maxSlicesPerScroll = value;
    }

    public int getMaxSlicesPerPit() {
        return this.maxSlicesPerPit;
    }

    private void setMaxSlicesPerPit(int value) {
        this.maxSlicesPerPit = value;
    }

    public int getMaxRegexLength() {
        return this.maxRegexLength;
    }

    private void setMaxRegexLength(int maxRegexLength) {
        this.maxRegexLength = maxRegexLength;
    }

    public IndexSortConfig getIndexSortConfig() {
        return this.indexSortConfig;
    }

    public IndexScopedSettings getScopedSettings() {
        return this.scopedSettings;
    }

    public boolean isExplicitRefresh() {
        return INDEX_REFRESH_INTERVAL_SETTING.exists(this.settings);
    }

    public TimeValue getSearchIdleAfter() {
        return this.searchIdleAfter;
    }

    public String getDefaultPipeline() {
        return this.defaultPipeline;
    }

    public void setDefaultPipeline(String defaultPipeline) {
        this.defaultPipeline = defaultPipeline;
    }

    public String getRequiredPipeline() {
        return this.requiredPipeline;
    }

    public void setRequiredPipeline(String requiredPipeline) {
        this.requiredPipeline = requiredPipeline;
    }

    public boolean isSoftDeleteEnabled() {
        return this.softDeleteEnabled;
    }

    public boolean isContextAwareEnabled() {
        return this.contextAwareEnabled && FeatureFlags.isEnabled(FeatureFlags.CONTEXT_AWARE_MIGRATION_EXPERIMENTAL_SETTING);
    }

    private void setMaxRetryOnLookupMapAcquisitionException(int maxRetryOnLookupMapAcquisitionException) {
        this.maxRetryOnLookupMapAcquisitionException = maxRetryOnLookupMapAcquisitionException;
    }

    public int getMaxRetryOnLookupMapAcquisitionException() {
        return this.maxRetryOnLookupMapAcquisitionException;
    }

    private void setSoftDeleteRetentionOperations(long ops) {
        this.softDeleteRetentionOperations = ops;
    }

    public long getSoftDeleteRetentionOperations() {
        return this.softDeleteRetentionOperations;
    }

    public boolean isSearchThrottled() {
        return this.searchThrottled;
    }

    private void setSearchThrottled(boolean searchThrottled) {
        this.searchThrottled = searchThrottled;
    }

    public boolean shouldCleanupUnreferencedFiles() {
        return this.shouldCleanupUnreferencedFiles;
    }

    private void setShouldCleanupUnreferencedFiles(boolean shouldCleanupUnreferencedFiles) {
        this.shouldCleanupUnreferencedFiles = shouldCleanupUnreferencedFiles;
    }

    public long getMappingNestedFieldsLimit() {
        return this.mappingNestedFieldsLimit;
    }

    private void setMappingNestedFieldsLimit(long value) {
        this.mappingNestedFieldsLimit = value;
    }

    public long getMappingNestedDocsLimit() {
        return this.mappingNestedDocsLimit;
    }

    private void setMappingNestedDocsLimit(long value) {
        this.mappingNestedDocsLimit = value;
    }

    public long getMappingTotalFieldsLimit() {
        return this.mappingTotalFieldsLimit;
    }

    private void setMappingTotalFieldsLimit(long value) {
        this.mappingTotalFieldsLimit = value;
    }

    public long getMappingDepthLimit() {
        return this.mappingDepthLimit;
    }

    private void setMappingDepthLimit(long value) {
        this.mappingDepthLimit = value;
    }

    public long getMappingFieldNameLengthLimit() {
        return this.mappingFieldNameLengthLimit;
    }

    private void setMappingFieldNameLengthLimit(long value) {
        this.mappingFieldNameLengthLimit = value;
    }

    private void setMaxFullFlushMergeWaitTime(TimeValue timeValue) {
        this.maxFullFlushMergeWaitTime = timeValue;
    }

    private void setMergeOnFlushEnabled(boolean enabled) {
        this.mergeOnFlushEnabled = enabled;
    }

    public TimeValue getMaxFullFlushMergeWaitTime() {
        return this.maxFullFlushMergeWaitTime;
    }

    public boolean isMergeOnFlushEnabled() {
        return this.mergeOnFlushEnabled;
    }

    private void setMergeOnFlushPolicy(String policy) {
        if (Strings.isEmpty((CharSequence)policy) || DEFAULT_POLICY.equalsIgnoreCase(policy)) {
            this.mergeOnFlushPolicy = null;
        } else if (MERGE_ON_FLUSH_MERGE_POLICY.equalsIgnoreCase(policy)) {
            this.mergeOnFlushPolicy = MergeOnFlushMergePolicy::new;
        } else {
            throw new IllegalArgumentException("The " + INDEX_MERGE_ON_FLUSH_POLICY.getKey() + " has unsupported policy specified: " + policy + ". Please use one of: default, merge-on-flush");
        }
    }

    public boolean isCheckPendingFlushEnabled() {
        return this.checkPendingFlushEnabled;
    }

    public Optional<UnaryOperator<MergePolicy>> getMergeOnFlushPolicy() {
        return Optional.ofNullable(this.mergeOnFlushPolicy);
    }

    public String getDefaultSearchPipeline() {
        return this.defaultSearchPipeline;
    }

    public void setDefaultSearchPipeline(String defaultSearchPipeline) {
        this.defaultSearchPipeline = defaultSearchPipeline;
    }

    public boolean shouldWidenIndexSortType() {
        return this.widenIndexSortType;
    }

    public boolean isEnableFuzzySetForDocId() {
        return this.enableFuzzySetForDocId;
    }

    public void setEnableFuzzySetForDocId(boolean enableFuzzySetForDocId) {
        this.enableFuzzySetForDocId = enableFuzzySetForDocId;
    }

    public double getDocIdFuzzySetFalsePositiveProbability() {
        return this.docIdFuzzySetFalsePositiveProbability;
    }

    public void setDocIdFuzzySetFalsePositiveProbability(double docIdFuzzySetFalsePositiveProbability) {
        this.docIdFuzzySetFalsePositiveProbability = docIdFuzzySetFalsePositiveProbability;
    }

    public RemoteStorePathStrategy getRemoteStorePathStrategy() {
        return this.remoteStorePathStrategy;
    }

    public boolean isTranslogMetadataEnabled() {
        return this.isTranslogMetadataEnabled;
    }

    public void setRemoteStoreEnabled(boolean isRemoteStoreEnabled) {
        this.isRemoteStoreEnabled = isRemoteStoreEnabled;
    }

    public void setRemoteStoreRepository(String remoteStoreRepository) {
        this.remoteStoreRepository = remoteStoreRepository;
    }

    public void setRemoteStoreTranslogRepository(String remoteStoreTranslogRepository) {
        this.remoteStoreTranslogRepository = remoteStoreTranslogRepository;
    }

    private void setDerivedSourceEnabledForTranslog(boolean isDerivedSourceEnabledForTranslog) {
        if (isDerivedSourceEnabledForTranslog && !this.isDerivedSourceEnabled()) {
            throw new IllegalArgumentException("The " + INDEX_DERIVED_SOURCE_TRANSLOG_ENABLED_SETTING.getKey() + " can't be set when " + INDEX_DERIVED_SOURCE_SETTING.getKey() + " setting is disabled");
        }
        this.derivedSourceEnabledForTranslog = isDerivedSourceEnabledForTranslog;
    }

    public boolean isDerivedSourceEnabledForTranslog() {
        return this.derivedSourceEnabledForTranslog;
    }

    public boolean isDerivedSourceEnabled() {
        return this.derivedSourceEnabled;
    }

    public static enum IndexMergePolicy {
        TIERED("tiered"),
        LOG_BYTE_SIZE("log_byte_size"),
        DEFAULT_POLICY("default");

        private final String value;

        private IndexMergePolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IndexMergePolicy fromString(String text) {
            for (IndexMergePolicy policy : IndexMergePolicy.values()) {
                if (!policy.value.equals(text)) continue;
                return policy;
            }
            throw new IllegalArgumentException("The setting has unsupported policy specified: " + text + ". Please use one of: " + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(IndexMergePolicy.values()).map(IndexMergePolicy::getValue).toArray(String[]::new)));
        }
    }
}

