/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.judgment;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.searchrelevance.model.JudgmentType;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentRequest;
import reactor.util.annotation.NonNull;

public class PutLlmJudgmentRequest
extends PutJudgmentRequest {
    private final String modelId;
    private final String querySetId;
    private final List<String> searchConfigurationList;
    private int size;
    private int tokenLimit;
    private List<String> contextFields;
    private boolean ignoreFailure;

    public PutLlmJudgmentRequest(@NonNull JudgmentType type, @NonNull String name, @NonNull String description, @NonNull String modelId, @NonNull String querySetId, @NonNull List<String> searchConfigurationList, int size, int tokenLimit, List<String> contextFields, boolean ignoreFailure) {
        super(type, name, description);
        this.modelId = modelId;
        this.querySetId = querySetId;
        this.searchConfigurationList = searchConfigurationList;
        this.size = size;
        this.tokenLimit = tokenLimit;
        this.contextFields = contextFields;
        this.ignoreFailure = ignoreFailure;
    }

    public PutLlmJudgmentRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.querySetId = in.readString();
        this.searchConfigurationList = in.readStringList();
        this.size = in.readInt();
        this.tokenLimit = in.readOptionalInt();
        this.contextFields = in.readOptionalStringList();
        this.ignoreFailure = Boolean.TRUE.equals(in.readOptionalBoolean());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeString(this.querySetId);
        out.writeStringArray(this.searchConfigurationList.toArray(new String[0]));
        out.writeInt(this.size);
        out.writeOptionalInt(Integer.valueOf(this.tokenLimit));
        out.writeOptionalStringArray(this.contextFields.toArray(new String[0]));
        out.writeOptionalBoolean(Boolean.valueOf(this.ignoreFailure));
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getQuerySetId() {
        return this.querySetId;
    }

    public List<String> getSearchConfigurationList() {
        return this.searchConfigurationList;
    }

    public int getSize() {
        return this.size;
    }

    public int getTokenLimit() {
        return this.tokenLimit;
    }

    public List<String> getContextFields() {
        return this.contextFields;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }
}

