/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.searchrelevance.transport.scheduledJob.DeleteScheduledExperimentAction;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestDeleteScheduledExperimentAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestDeleteScheduledExperimentAction.class);
    private static final Logger LOGGER = LogManager.getLogger(RestDeleteScheduledExperimentAction.class);
    private static final String DELETE_SCHEDULED_EXPERIMENT_ACTION = "delete_scheduled_experiment_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return DELETE_SCHEDULED_EXPERIMENT_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_search_relevance/experiments/schedule", "id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        if (!this.settingsAccessor.isScheduledExperimentsEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Scheduled experiments is disabled"));
        }
        String jobId = request.param("id");
        if (jobId == null) {
            throw new SearchRelevanceException("id cannot be null", RestStatus.BAD_REQUEST);
        }
        OpenSearchDocRequest deleteRequest = new OpenSearchDocRequest(jobId);
        return channel -> client.execute((ActionType)DeleteScheduledExperimentAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    deleteResponse.toXContent(builder, (ToXContent.Params)request);
                    channel.sendResponse((RestResponse)new BytesRestResponse(deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND ? RestStatus.NOT_FOUND : RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestDeleteScheduledExperimentAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

