/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchHit;
import org.opensearch.searchrelevance.dao.EvaluationResultDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.experiment.QuerySourceUtil;
import org.opensearch.searchrelevance.metrics.EvaluationMetrics;
import org.opensearch.searchrelevance.metrics.PairwiseComparisonMetrics;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.EvaluationResult;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.model.SearchConfigurationDetails;
import org.opensearch.searchrelevance.model.builder.SearchRequestBuilder;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.transport.client.Client;
import reactor.util.annotation.NonNull;

public class MetricsHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(MetricsHelper.class);
    private final Client client;
    private final JudgmentDao judgmentDao;
    private final EvaluationResultDao evaluationResultDao;
    private final ExperimentVariantDao experimentVariantDao;

    @Inject
    public MetricsHelper(@NonNull ClusterService clusterService, @NonNull Client client, @NonNull JudgmentDao judgmentDao, @NonNull EvaluationResultDao evaluationResultDao, @NonNull ExperimentVariantDao experimentVariantDao) {
        this.client = client;
        this.judgmentDao = judgmentDao;
        this.evaluationResultDao = evaluationResultDao;
        this.experimentVariantDao = experimentVariantDao;
    }

    public void processPairwiseMetrics(String queryText, Map<String, SearchConfigurationDetails> searchConfigurations, int size, final ActionListener<Map<String, Object>> listener) {
        final Map searchConfigToDocIds = Collections.synchronizedMap(new HashMap());
        final AtomicBoolean hasFailure = new AtomicBoolean(false);
        final AtomicInteger pendingSearches = new AtomicInteger(searchConfigurations.size());
        for (Map.Entry<String, SearchConfigurationDetails> entry : searchConfigurations.entrySet()) {
            final String searchConfigId = entry.getKey();
            SearchConfigurationDetails configDetails = entry.getValue();
            SearchRequest searchRequest = SearchRequestBuilder.buildSearchRequest(configDetails.getIndex(), configDetails.getQuery(), queryText, configDetails.getPipeline(), size);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ MetricsHelper this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    if (hasFailure.get()) {
                        return;
                    }
                    try {
                        List docIds = Arrays.stream(response.getHits().getHits()).map(SearchHit::getId).distinct().collect(Collectors.toList());
                        searchConfigToDocIds.put(searchConfigId, docIds);
                        if (pendingSearches.decrementAndGet() == 0) {
                            this.this$0.createPairwiseResults(searchConfigToDocIds, (ActionListener<Map<String, Object>>)listener);
                        }
                    }
                    catch (Exception e) {
                        this.this$0.handleFailure(e, hasFailure, listener);
                    }
                }

                public void onFailure(Exception e) {
                    this.this$0.handleFailure(e, hasFailure, listener);
                }
            });
        }
    }

    private void createPairwiseResults(Map<String, List<String>> searchConfigToDocIds, ActionListener<Map<String, Object>> listener) {
        try {
            HashMap<String, Object> results = new HashMap<String, Object>();
            if (searchConfigToDocIds == null || searchConfigToDocIds.isEmpty()) {
                results.put("metrics", Collections.emptyMap());
                listener.onResponse(results);
                return;
            }
            ArrayList snapShots = new ArrayList();
            searchConfigToDocIds.forEach((configId, docIds) -> {
                HashMap<String, Object> snapshot = new HashMap<String, Object>();
                snapshot.put("searchConfigurationId", configId);
                snapshot.put("docIds", docIds != null ? docIds : Collections.emptyList());
                snapShots.add(snapshot);
            });
            results.put("snapshots", snapShots);
            HashMap<String, List<String>> pairwiseInput = new HashMap<String, List<String>>();
            ArrayList<String> configIds = new ArrayList<String>(searchConfigToDocIds.keySet());
            if (configIds.size() >= 2) {
                pairwiseInput.put("0", searchConfigToDocIds.get(configIds.get(0)));
                pairwiseInput.put("1", searchConfigToDocIds.get(configIds.get(1)));
            }
            results.put("metrics", PairwiseComparisonMetrics.calculatePairwiseMetrics(pairwiseInput));
            listener.onResponse(results);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void handleFailure(Exception error, AtomicBoolean hasFailure, ActionListener<?> listener) {
        if (hasFailure.compareAndSet(false, true)) {
            listener.onFailure(error);
        }
    }

    public void processEvaluationMetrics(final String queryText, final Map<String, List<String>> indexAndQueries, final int size, final List<String> judgmentIds, final ActionListener<Map<String, Object>> listener, final List<ExperimentVariant> experimentVariants) {
        if (indexAndQueries.isEmpty() || judgmentIds.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Missing required parameters"));
            return;
        }
        try {
            final Map configToEvalIds = Collections.synchronizedMap(new HashMap());
            final HashMap docIdToRatings = new HashMap();
            final AtomicInteger completedJudgments = new AtomicInteger(0);
            for (final String judgmentId : judgmentIds) {
                this.judgmentDao.getJudgment(judgmentId, new ActionListener<SearchResponse>(this){
                    final /* synthetic */ MetricsHelper this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onResponse(SearchResponse judgmentResponse) {
                        try {
                            if (judgmentResponse.getHits().getTotalHits().value() == 0L) {
                                log.warn("No judgment found for ID: {}", (Object)judgmentId);
                            } else {
                                Map sourceAsMap = judgmentResponse.getHits().getHits()[0].getSourceAsMap();
                                List judgmentRatings = sourceAsMap.getOrDefault("judgmentRatings", Collections.emptyList());
                                for (Map rating : judgmentRatings) {
                                    if (!queryText.equals(rating.get("query"))) continue;
                                    List docScoreRatings = (List)rating.get("ratings");
                                    docScoreRatings.forEach(docScoreRating -> docIdToRatings.put((String)docScoreRating.get("docId"), (String)docScoreRating.get("rating")));
                                    break;
                                }
                            }
                            if (completedJudgments.incrementAndGet() == judgmentIds.size()) {
                                if (docIdToRatings.isEmpty()) {
                                    log.warn("No ratings found for query: {} in any judgments", (Object)queryText);
                                }
                                this.this$0.processSearchConfigurations(queryText, indexAndQueries, size, judgmentIds, docIdToRatings, configToEvalIds, (ActionListener<Map<String, Object>>)listener, experimentVariants);
                            }
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to fetch judgment {}: {}", (Object)judgmentId, (Object)e);
                        if (completedJudgments.incrementAndGet() == judgmentIds.size()) {
                            if (docIdToRatings.isEmpty()) {
                                listener.onFailure((Exception)new IllegalStateException("Failed to fetch any valid judgments"));
                            } else {
                                this.this$0.processSearchConfigurations(queryText, indexAndQueries, size, judgmentIds, docIdToRatings, configToEvalIds, (ActionListener<Map<String, Object>>)listener, experimentVariants);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Unexpected error in evaluateQueryTextAsync: {}", (Object)e.getMessage());
            listener.onFailure(e);
        }
    }

    private void processSearchConfigurations(String queryText, Map<String, List<String>> indexAndQueries, int size, List<String> judgmentIds, Map<String, String> docIdToScores, Map<String, Object> configToEvalIds, ActionListener<Map<String, Object>> listener, List<ExperimentVariant> experimentVariants) {
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        AtomicInteger pendingConfigurations = this.getNumberOfExperimentRuns(indexAndQueries, experimentVariants);
        if (indexAndQueries.isEmpty()) {
            listener.onResponse(configToEvalIds);
            return;
        }
        for (String searchConfigurationId : indexAndQueries.keySet()) {
            if (hasFailure.get()) {
                return;
            }
            String index = indexAndQueries.get(searchConfigurationId).get(0);
            String query = indexAndQueries.get(searchConfigurationId).get(1);
            String searchPipeline = indexAndQueries.get(searchConfigurationId).get(2);
            if (Objects.isNull(experimentVariants) || experimentVariants.isEmpty()) {
                this.processSearchConfigurationWithEmptyExperimentOptions(queryText, size, judgmentIds, docIdToScores, configToEvalIds, listener, searchConfigurationId, index, query, searchPipeline, hasFailure, pendingConfigurations);
                continue;
            }
            this.processSearchConfigurationWithHybridExperimentOptions(queryText, size, judgmentIds, docIdToScores, configToEvalIds, listener, searchConfigurationId, index, query, hasFailure, pendingConfigurations, experimentVariants);
        }
    }

    private AtomicInteger getNumberOfExperimentRuns(Map<String, List<String>> indexAndQueries, List<ExperimentVariant> experimentVariants) {
        if (Objects.nonNull(experimentVariants)) {
            return new AtomicInteger(indexAndQueries.size() * (experimentVariants.size() == 0 ? 1 : experimentVariants.size()));
        }
        return new AtomicInteger(indexAndQueries.size());
    }

    private void processSearchConfigurationWithEmptyExperimentOptions(final String queryText, final int size, final List<String> judgmentIds, final Map<String, String> docIdToScores, final Map<String, Object> configToEvalIds, final ActionListener<Map<String, Object>> listener, final String searchConfigurationId, String index, String query, String searchPipeline, final AtomicBoolean hasFailure, final AtomicInteger pendingConfigurations) {
        SearchRequest searchRequest = SearchRequestBuilder.buildSearchRequest(index, query, queryText, searchPipeline, size);
        final String evaluationId = UUID.randomUUID().toString();
        log.debug("Configuration {}: index: {}, query: {}, searchPipeline: {}, evaluationId: {}", (Object)searchConfigurationId, (Object)index, (Object)query, (Object)searchPipeline, (Object)evaluationId);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
            final /* synthetic */ MetricsHelper this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse response) {
                if (hasFailure.get()) {
                    return;
                }
                try {
                    if (response.getHits().getTotalHits().value() == 0L) {
                        log.warn("No hits found for search config: {}", (Object)searchConfigurationId);
                        if (pendingConfigurations.decrementAndGet() == 0) {
                            listener.onResponse((Object)configToEvalIds);
                        }
                        return;
                    }
                    SearchHit[] hits = response.getHits().getHits();
                    List<String> docIds = Arrays.stream(hits).map(SearchHit::getId).collect(Collectors.toList());
                    List<Map<String, Object>> metrics = EvaluationMetrics.calculateEvaluationMetrics(docIds, docIdToScores, size);
                    EvaluationResult evaluationResult = new EvaluationResult(evaluationId, TimeUtils.getTimestamp(), searchConfigurationId, queryText, judgmentIds, docIds, metrics);
                    this.this$0.evaluationResultDao.putEvaluationResult(evaluationResult, ActionListener.wrap(success -> {
                        configToEvalIds.put("searchConfigurationId", searchConfigurationId);
                        configToEvalIds.put("evaluationId", evaluationId);
                        if (pendingConfigurations.decrementAndGet() == 0) {
                            listener.onResponse((Object)configToEvalIds);
                        }
                    }, error -> {
                        hasFailure.set(true);
                        listener.onFailure(error);
                    }));
                }
                catch (Exception e) {
                    hasFailure.set(true);
                    listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                hasFailure.set(true);
                listener.onFailure(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSearchConfigurationWithHybridExperimentOptions(final String queryText, final int size, final List<String> judgmentIds, final Map<String, String> docIdToScores, final Map<String, Object> configToExperimentVariants, final ActionListener<Map<String, Object>> listener, final String searchConfigurationId, String index, String query, final AtomicBoolean hasFailure, final AtomicInteger pendingConfigurations, List<ExperimentVariant> experimentVariants) {
        if (Objects.isNull(experimentVariants) || experimentVariants.isEmpty()) {
            throw new IllegalArgumentException("experiment variant for hybrid search cannot be empty");
        }
        Map<String, Object> map = configToExperimentVariants;
        synchronized (map) {
            if (!configToExperimentVariants.containsKey(searchConfigurationId)) {
                configToExperimentVariants.put(searchConfigurationId, new HashMap());
            }
        }
        for (final ExperimentVariant experimentVariant : experimentVariants) {
            Map<String, Object> temporarySearchPipeline = QuerySourceUtil.createDefinitionOfTemporarySearchPipeline(experimentVariant);
            SearchRequest searchRequest = SearchRequestBuilder.buildRequestForHybridSearch(index, query, temporarySearchPipeline, queryText, size);
            final String evaluationId = UUID.randomUUID().toString();
            log.debug("Processing hybrid search sub-experiment: {} configuration: {} index: {}, query: {}, evaluationId: {}", (Object)experimentVariant.getId(), (Object)searchConfigurationId, (Object)index, (Object)query, (Object)evaluationId);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                final /* synthetic */ MetricsHelper this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    if (hasFailure.get()) {
                        return;
                    }
                    try {
                        if (response.getHits().getTotalHits().value() == 0L) {
                            log.warn("No hits found for search config: {}", (Object)searchConfigurationId);
                            if (pendingConfigurations.decrementAndGet() == 0) {
                                listener.onResponse((Object)configToExperimentVariants);
                            }
                            return;
                        }
                        SearchHit[] hits = response.getHits().getHits();
                        List<String> docIds = Arrays.stream(hits).map(SearchHit::getId).collect(Collectors.toList());
                        List<Map<String, Object>> metrics = EvaluationMetrics.calculateEvaluationMetrics(docIds, docIdToScores, size);
                        EvaluationResult evaluationResult = new EvaluationResult(evaluationId, TimeUtils.getTimestamp(), searchConfigurationId, queryText, judgmentIds, docIds, metrics);
                        this.this$0.evaluationResultDao.putEvaluationResult(evaluationResult, ActionListener.wrap(success -> {
                            ExperimentVariant experimentVariantResult = new ExperimentVariant(experimentVariant.getId(), TimeUtils.getTimestamp(), experimentVariant.getType(), AsyncStatus.COMPLETED, experimentVariant.getExperimentId(), experimentVariant.getParameters(), Map.of("evaluationResultId", evaluationId));
                            StepListener voidStepListener = new StepListener();
                            this.this$0.experimentVariantDao.updateExperimentVariant(experimentVariantResult, (ActionListener)voidStepListener);
                            voidStepListener.whenComplete(indexResponse -> {
                                Map map = configToExperimentVariants;
                                synchronized (map) {
                                    Map map2 = (Map)configToExperimentVariants.get(searchConfigurationId);
                                    map2.put(experimentVariant.getId(), evaluationId);
                                }
                                if (pendingConfigurations.decrementAndGet() == 0) {
                                    HashMap<String, Object> transformedConfigToExperimentVariants = new HashMap<String, Object>();
                                    transformedConfigToExperimentVariants.put("searchConfigurationId", searchConfigurationId);
                                    ArrayList evaluationResults = new ArrayList();
                                    Map configMap = (Map)configToExperimentVariants.get(searchConfigurationId);
                                    configMap.forEach((variantId, evalId) -> {
                                        HashMap<String, Object> result = new HashMap<String, Object>();
                                        result.put("evaluationId", evalId);
                                        result.put("experimentVariantId", variantId);
                                        evaluationResults.add(result);
                                    });
                                    transformedConfigToExperimentVariants.put("evaluationResults", evaluationResults);
                                    listener.onResponse(transformedConfigToExperimentVariants);
                                }
                            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                        }, error -> {
                            hasFailure.set(true);
                            listener.onFailure(error);
                        }));
                    }
                    catch (Exception e) {
                        hasFailure.set(true);
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    ExperimentVariant experimentVariantResult = new ExperimentVariant(experimentVariant.getId(), TimeUtils.getTimestamp(), experimentVariant.getType(), AsyncStatus.ERROR, experimentVariant.getExperimentId(), experimentVariant.getParameters(), Map.of("evaluationResultId", evaluationId));
                    this.this$0.experimentVariantDao.updateExperimentVariant(experimentVariantResult, ActionListener.wrap(success -> {}, error -> {
                        hasFailure.set(true);
                        listener.onFailure(error);
                    }));
                    hasFailure.set(true);
                    listener.onFailure(e);
                }
            });
        }
    }
}

