/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.services;

import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.securityanalytics.commons.connector.codec.InputCodec;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.threatIntel.model.JsonPathIocSchema;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.service.JsonPathIocSchemaThreatIntelHandler;

public class JsonPathAwareInputCodec
implements InputCodec<STIX2IOC> {
    private static final Logger logger = LogManager.getLogger(JsonPathAwareInputCodec.class);
    private final SATIFSourceConfig satifSourceConfig;

    public JsonPathAwareInputCodec(SATIFSourceConfig satifSourceConfig) {
        this.satifSourceConfig = satifSourceConfig;
    }

    public void parse(InputStream inputStream, Consumer<STIX2IOC> consumer) {
        try {
            List<STIX2IOC> stix2IOCS = JsonPathIocSchemaThreatIntelHandler.parseCustomSchema((JsonPathIocSchema)this.satifSourceConfig.getIocSchema(), inputStream, this.satifSourceConfig.getName(), this.satifSourceConfig.getId());
            stix2IOCS.forEach(ioc -> {
                try {
                    consumer.accept((STIX2IOC)((Object)ioc));
                }
                catch (Exception e) {
                    logger.error(String.format("Error while indexing STIX2Ioc - type [%s], value [%s]", new Object[0]), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.error(String.format("Error while downloading and indexing STIX2Ioc", new Object[0]), (Throwable)e);
        }
    }
}

