/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.Input;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.Batchifier;
import ai.djl.translate.ServingTranslator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public abstract class SentenceTransformerTranslator
implements ServingTranslator {
    protected HuggingFaceTokenizer tokenizer;

    public Batchifier getBatchifier() {
        return Batchifier.STACK;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Path path = ctx.getModel().getModelPath();
        this.tokenizer = HuggingFaceTokenizer.builder().optPadding(true).optTokenizerPath(path.resolve("tokenizer.json")).build();
    }

    public NDList processInput(TranslatorContext ctx, Input input) {
        String sentence = input.getAsString(0);
        NDManager manager = ctx.getNDManager();
        NDList ndList = new NDList();
        Encoding encodings = this.tokenizer.encode(sentence);
        long[] indices = encodings.getIds();
        long[] attentionMask = encodings.getAttentionMask();
        NDArray indicesArray = manager.create(indices);
        indicesArray.setName("input1.input_ids");
        NDArray attentionMaskArray = manager.create(attentionMask);
        attentionMaskArray.setName("input1.attention_mask");
        ndList.add((Object)indicesArray);
        ndList.add((Object)attentionMaskArray);
        return ndList;
    }

    public void setArguments(Map<String, ?> arguments) {
    }
}

