/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.legacy.query.join.HashJoinElasticRequestBuilder;
import org.opensearch.sql.legacy.query.planner.core.Config;
import org.opensearch.sql.legacy.query.planner.core.QueryParams;
import org.opensearch.sql.legacy.query.planner.core.QueryPlanner;
import org.opensearch.sql.legacy.request.SqlRequest;
import org.opensearch.transport.client.Client;

public class HashJoinQueryPlanRequestBuilder
extends HashJoinElasticRequestBuilder {
    private static final Logger LOG = LogManager.getLogger();
    private final Client client;
    private final SqlRequest request;
    private final Config config;

    public HashJoinQueryPlanRequestBuilder(Client client, SqlRequest request) {
        this.client = client;
        this.request = request;
        this.config = new Config();
    }

    @Override
    public String explain() {
        return this.plan().explain();
    }

    public QueryPlanner plan() {
        this.config.configureLimit(this.getTotalLimit(), this.getFirstTable().getHintLimit(), this.getSecondTable().getHintLimit());
        this.config.configureTermsFilterOptimization(this.isUseTermFiltersOptimization());
        if (this.config.timeout() != 60) {
            TimeValue joinTimeout = TimeValue.timeValueSeconds((long)this.config.timeout());
            LOG.info("HashJoinQueryPlanRequestBuilder: Using JOIN_TIME_OUT hint: {} seconds", (Object)this.config.timeout());
            this.getFirstTable().setHintJoinTimeout(joinTimeout);
            this.getSecondTable().setHintJoinTimeout(joinTimeout);
        }
        return new QueryPlanner(this.client, this.config, new QueryParams(this.getFirstTable(), this.getSecondTable(), this.getJoinType(), this.getT1ToT2FieldsComparison()));
    }

    public Config getConfig() {
        return this.config;
    }
}

