/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;

public class SAML1ArtifactRequestIssuerHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1ArtifactRequestIssuerHandler.class);
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;

    public void setArtifactMap(@Nonnull SAMLArtifactMap map) {
        this.artifactMap = Constraint.isNotNull(map, "SAMLArtifactMap cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (messageContext.getMessage() == null || !(messageContext.getMessage() instanceof Request)) {
            this.log.trace("{} Request message not set, or not of an applicable type", (Object)this.getLogPrefix());
            return;
        }
        Request request = (Request)messageContext.getMessage();
        assert (request != null);
        if (request.getAssertionArtifacts().isEmpty()) {
            this.log.trace("{} Request did not contain any artifacts", (Object)this.getLogPrefix());
            return;
        }
        String artifact = request.getAssertionArtifacts().get(0).getValue();
        if (artifact == null) {
            this.log.trace("{} Request did not contain any artifacts", (Object)this.getLogPrefix());
            return;
        }
        try {
            SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(artifact);
            if (entry == null) {
                this.log.warn("{} Unable to resolve first artifact in request: {}", (Object)this.getLogPrefix(), (Object)artifact);
                return;
            }
            this.log.debug("{} Derived issuer of aritfact resolution request as {}", (Object)this.getLogPrefix(), (Object)entry.getRelyingPartyId());
            messageContext.ensureSubcontext(SAMLPeerEntityContext.class).setEntityId(entry.getRelyingPartyId());
        }
        catch (IOException e) {
            this.log.error("{} Error resolving first artifact in request: {}", new Object[]{this.getLogPrefix(), artifact, e});
        }
    }
}

