/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.SparseModel;
import org.tribuo.math.la.SparseVector;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.Regressor;

public abstract class SkeletalIndependentRegressionSparseModel
extends SparseModel<Regressor> {
    private static final long serialVersionUID = 1L;
    protected final String[] dimensions;

    protected SkeletalIndependentRegressionSparseModel(String name, String[] dimensions, ModelProvenance modelProvenance, ImmutableFeatureMap featureMap, ImmutableOutputInfo<Regressor> outputInfo, Map<String, List<String>> activeFeatures) {
        super(name, modelProvenance, featureMap, outputInfo, false, activeFeatures);
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
    }

    public Prediction<Regressor> predict(Example<Regressor> example) {
        SparseVector features = this.createFeatures(example);
        Regressor.DimensionTuple[] outputs = new Regressor.DimensionTuple[this.dimensions.length];
        for (int i = 0; i < this.dimensions.length; ++i) {
            outputs[i] = this.scoreDimension(i, features);
        }
        return new Prediction((Output)new Regressor(outputs), features.numActiveElements(), example);
    }

    protected SparseVector createFeatures(Example<Regressor> example) {
        return SparseVector.createSparseVector(example, (ImmutableFeatureMap)this.featureIDMap, (boolean)false);
    }

    protected abstract Regressor.DimensionTuple scoreDimension(int var1, SparseVector var2);
}

