/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.parse.RegexCommonUtils;

public final class RexExtractMultiFunction
extends ImplementorUDF {
    public RexExtractMultiFunction() {
        super(new RexExtractMultiImplementor(), NullPolicy.ARG0);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return call -> {
            RelDataType elementType = call.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 2000);
            return call.getTypeFactory().createArrayType(call.getTypeFactory().createTypeWithNullability(elementType, true), -1L);
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)PPLOperandTypes.STRING_STRING_INTEGER_INTEGER.getInnerTypeChecker().or((SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER})));
    }

    public static List<String> extractMultipleGroups(String text, String pattern, int groupIndex, int maxMatch) {
        if (text == null || pattern == null) {
            return null;
        }
        return RexExtractMultiFunction.executeMultipleExtractions(text, pattern, maxMatch, matcher -> {
            if (groupIndex > 0 && groupIndex <= matcher.groupCount()) {
                return matcher.group(groupIndex);
            }
            return null;
        });
    }

    public static List<String> extractMultipleGroups(String text, String pattern, String groupName, int maxMatch) {
        if (text == null || pattern == null || groupName == null) {
            return null;
        }
        return RexExtractMultiFunction.executeMultipleExtractions(text, pattern, maxMatch, matcher -> {
            try {
                return matcher.group(groupName);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
    }

    private static List<String> executeMultipleExtractions(String text, String pattern, int maxMatch, Function<Matcher, String> extractor) {
        try {
            String match;
            Pattern compiledPattern = RegexCommonUtils.getCompiledPattern(pattern);
            Matcher matcher = compiledPattern.matcher(text);
            ArrayList<String> matches = new ArrayList<String>();
            for (int matchCount = 0; matcher.find() && (maxMatch == 0 || matchCount < maxMatch) && (match = extractor.apply(matcher)) != null; ++matchCount) {
                matches.add(match);
            }
            return matches.isEmpty() ? null : matches;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Error in 'rex' command: Encountered the following error while compiling the regex '" + pattern + "': " + e.getMessage());
        }
    }

    private static class RexExtractMultiImplementor
    implements NotNullImplementor {
        private RexExtractMultiImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression field = translatedOperands.get(0);
            Expression pattern = translatedOperands.get(1);
            Expression groupIndexOrName = translatedOperands.get(2);
            Expression maxMatch = translatedOperands.get(3);
            return Expressions.call(RexExtractMultiFunction.class, (String)"extractMultipleGroups", (Expression[])new Expression[]{field, pattern, groupIndexOrName, maxMatch});
        }
    }
}

