/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLambda;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.CalciteFuncSignature;
import org.opensearch.sql.expression.function.CoercionUtils;
import org.opensearch.sql.expression.function.CollectionUDF.MVIndexFunctionImp;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.expression.function.PPLTypeChecker;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import shaded.com.google.common.collect.ImmutableMap;

public class PPLFuncImpTable {
    private static final Logger logger = LogManager.getLogger(PPLFuncImpTable.class);
    public static final PPLFuncImpTable INSTANCE;
    private final ImmutableMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> functionRegistry;
    private final Map<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> externalFunctionRegistry;
    private final ImmutableMap<BuiltinFunctionName, Pair<CalciteFuncSignature, AggHandler>> aggFunctionRegistry;
    private final Map<BuiltinFunctionName, Pair<CalciteFuncSignature, AggHandler>> aggExternalFunctionRegistry;

    private PPLFuncImpTable(Builder builder, AggBuilder aggBuilder) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        builder.map.forEach((k, v) -> mapBuilder.put((Object)k, List.copyOf(v)));
        this.functionRegistry = ImmutableMap.copyOf((Map)mapBuilder.build());
        this.externalFunctionRegistry = new ConcurrentHashMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>>();
        ImmutableMap.Builder aggMapBuilder = ImmutableMap.builder();
        aggBuilder.map.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)aggMapBuilder).put(arg_0, arg_1));
        this.aggFunctionRegistry = ImmutableMap.copyOf((Map)aggMapBuilder.build());
        this.aggExternalFunctionRegistry = new ConcurrentHashMap<BuiltinFunctionName, Pair<CalciteFuncSignature, AggHandler>>();
    }

    public void registerExternalOperator(BuiltinFunctionName functionName, SqlOperator operator) {
        PPLTypeChecker typeChecker = PPLFuncImpTable.wrapSqlOperandTypeChecker(operator.getOperandTypeChecker(), functionName.name(), operator instanceof SqlUserDefinedFunction);
        CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), typeChecker);
        this.externalFunctionRegistry.compute(functionName, (name, existingList) -> {
            ArrayList<Pair> list = existingList == null ? new ArrayList<Pair>() : new ArrayList(existingList);
            list.add(Pair.of((Object)signature, (builder, args) -> builder.makeCall(operator, args)));
            return list;
        });
    }

    public void registerExternalAggOperator(BuiltinFunctionName functionName, SqlUserDefinedAggFunction aggFunction) {
        PPLTypeChecker typeChecker = PPLFuncImpTable.wrapSqlOperandTypeChecker((SqlOperandTypeChecker)aggFunction.getOperandTypeChecker(), functionName.name(), true);
        CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), typeChecker);
        AggHandler handler = (distinct, field, argList, ctx) -> UserDefinedFunctionUtils.makeAggregateCall((SqlAggFunction)aggFunction, List.of(field), argList, ctx.relBuilder);
        this.aggExternalFunctionRegistry.put(functionName, (Pair<CalciteFuncSignature, AggHandler>)Pair.of((Object)signature, (Object)handler));
    }

    public List<RexNode> validateAggFunctionSignature(BuiltinFunctionName functionName, RexNode field, List<RexNode> argList, RexBuilder rexBuilder) {
        Pair<CalciteFuncSignature, AggHandler> implementation = this.getImplementation(functionName);
        return PPLFuncImpTable.validateFunctionArgs(implementation, functionName, field, argList, rexBuilder);
    }

    public RelBuilder.AggCall resolveAgg(BuiltinFunctionName functionName, boolean distinct, RexNode field, List<RexNode> argList, CalcitePlanContext context) {
        Pair<CalciteFuncSignature, AggHandler> implementation = this.getImplementation(functionName);
        List<RexNode> nodes = PPLFuncImpTable.validateFunctionArgs(implementation, functionName, field, argList, context.rexBuilder);
        AggHandler handler = (AggHandler)implementation.getValue();
        return nodes != null ? handler.apply(distinct, nodes.getFirst(), nodes.subList(1, nodes.size()), context) : handler.apply(distinct, field, argList, context);
    }

    static List<RexNode> validateFunctionArgs(Pair<CalciteFuncSignature, AggHandler> implementation, BuiltinFunctionName functionName, RexNode field, List<RexNode> argList, RexBuilder rexBuilder) {
        CalciteFuncSignature signature = (CalciteFuncSignature)implementation.getKey();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        if (field != null) {
            argTypes.add(field.getType());
        }
        List<RelDataType> additionalArgTypes = argList.stream().map(PlanUtils::derefMapCall).map(RexNode::getType).toList();
        argTypes.addAll(additionalArgTypes);
        List<RexNode> coercionNodes = null;
        if (!signature.match(functionName.getName(), argTypes)) {
            ArrayList<RexNode> fields = new ArrayList<RexNode>();
            fields.add(field);
            fields.addAll(argList);
            if (CoercionUtils.hasString(fields)) {
                coercionNodes = CoercionUtils.castArguments(rexBuilder, signature.typeChecker(), fields);
            }
            if (coercionNodes == null) {
                String errorMessagePattern = argTypes.size() <= 1 ? "Aggregation function %s expects field type {%s}, but got %s" : "Aggregation function %s expects field type and additional arguments {%s}, but got %s";
                throw new ExpressionEvaluationException(String.format(errorMessagePattern, new Object[]{functionName, signature.typeChecker().getAllowedSignatures(), PlanUtils.getActualSignature(argTypes)}));
            }
        }
        return coercionNodes;
    }

    private Pair<CalciteFuncSignature, AggHandler> getImplementation(BuiltinFunctionName functionName) {
        Pair implementation = this.aggExternalFunctionRegistry.get((Object)functionName);
        if (implementation == null) {
            implementation = (Pair)this.aggFunctionRegistry.get((Object)functionName);
        }
        if (implementation == null) {
            throw new IllegalStateException(String.format("Cannot resolve function: %s", new Object[]{functionName}));
        }
        return implementation;
    }

    public RexNode resolve(RexBuilder builder, String functionName, RexNode ... args) {
        Optional<BuiltinFunctionName> funcNameOpt = BuiltinFunctionName.of(functionName);
        if (funcNameOpt.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unsupported function: %s", functionName));
        }
        return this.resolve(builder, funcNameOpt.get(), args);
    }

    public RexNode resolve(RexBuilder builder, BuiltinFunctionName functionName, RexNode ... args) {
        List implementList = this.externalFunctionRegistry.get((Object)functionName);
        if (implementList == null) {
            implementList = (List)this.functionRegistry.get((Object)functionName);
        }
        if (implementList == null || implementList.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot resolve function: %s", new Object[]{functionName}));
        }
        this.compulsoryCast(builder, functionName, args);
        List<RelDataType> argTypes = Arrays.stream(args).map(RexNode::getType).toList();
        try {
            for (Map.Entry implement : implementList) {
                if (!((CalciteFuncSignature)implement.getKey()).match(functionName.getName(), argTypes)) continue;
                return ((FunctionImp)implement.getValue()).resolve(builder, args);
            }
            RexNode coerced = this.resolveWithCoercion(builder, functionName, implementList, args);
            if (coerced != null) {
                return coerced;
            }
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(String.format("Cannot resolve function: %s, arguments: %s, caused by: %s", new Object[]{functionName, PlanUtils.getActualSignature(argTypes), e.getMessage()}), e);
        }
        StringJoiner allowedSignatures = new StringJoiner(",");
        for (Pair implement : implementList) {
            String signature = ((CalciteFuncSignature)implement.getKey()).typeChecker().getAllowedSignatures();
            if (signature.isEmpty()) continue;
            allowedSignatures.add(signature);
        }
        throw new ExpressionEvaluationException(String.format("%s function expects {%s}, but got %s", new Object[]{functionName, allowedSignatures, PlanUtils.getActualSignature(argTypes)}));
    }

    private void compulsoryCast(RexBuilder builder, BuiltinFunctionName functionName, RexNode ... args) {
        switch (functionName) {
            case REDUCE: {
                RexLambda call = (RexLambda)args[2];
                args[1] = builder.makeCast(call.getType(), args[1], true, true);
                break;
            }
        }
    }

    @Nullable
    private RexNode resolveWithCoercion(RexBuilder builder, BuiltinFunctionName functionName, List<Pair<CalciteFuncSignature, FunctionImp>> implementList, RexNode ... args) {
        if (BuiltinFunctionName.COMPARATORS.contains((Object)functionName)) {
            for (Map.Entry entry : implementList) {
                boolean matchSignature;
                List<RexNode> widenedArgs = CoercionUtils.widenArguments(builder, List.of(args));
                if (widenedArgs == null || !(matchSignature = ((CalciteFuncSignature)entry.getKey()).typeChecker().checkOperandTypes(widenedArgs.stream().map(RexNode::getType).toList()))) continue;
                return ((FunctionImp)entry.getValue()).resolve(builder, widenedArgs.toArray(new RexNode[0]));
            }
        } else {
            for (Map.Entry entry : implementList) {
                CalciteFuncSignature signature = (CalciteFuncSignature)entry.getKey();
                List<RexNode> castedArgs = CoercionUtils.castArguments(builder, signature.typeChecker(), List.of(args));
                if (castedArgs == null) continue;
                return ((FunctionImp)entry.getValue()).resolve(builder, castedArgs.toArray(new RexNode[0]));
            }
        }
        return null;
    }

    static List<RexNode> resolveTimeField(List<RexNode> argList, CalcitePlanContext ctx) {
        if (argList.isEmpty()) {
            RelDataTypeField timestampField = ctx.relBuilder.peek().getRowType().getField("@timestamp", false, false);
            if (timestampField == null) {
                throw new IllegalArgumentException("Default @timestamp field not found. Please specify a time field explicitly.");
            }
            return List.of(ctx.rexBuilder.makeInputRef(timestampField.getType(), timestampField.getIndex()));
        }
        return argList.stream().map(PlanUtils::derefMapCall).collect(Collectors.toList());
    }

    private static PPLTypeChecker wrapSqlOperandTypeChecker(SqlOperandTypeChecker typeChecker, String functionName, boolean isUserDefinedFunction) {
        PPLTypeChecker pplTypeChecker;
        if (typeChecker instanceof ImplicitCastOperandTypeChecker) {
            ImplicitCastOperandTypeChecker implicitCastTypeChecker = (ImplicitCastOperandTypeChecker)typeChecker;
            pplTypeChecker = PPLTypeChecker.wrapFamily(implicitCastTypeChecker);
        } else if (typeChecker instanceof CompositeOperandTypeChecker) {
            CompositeOperandTypeChecker compositeTypeChecker = (CompositeOperandTypeChecker)typeChecker;
            try {
                pplTypeChecker = PPLTypeChecker.wrapComposite(compositeTypeChecker, !isUserDefinedFunction);
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                logger.debug(String.format("Failed to create composite type checker for operator: %s. Will skip its type checking", functionName), (Throwable)e);
                pplTypeChecker = null;
            }
        } else if (typeChecker instanceof SameOperandTypeChecker) {
            SameOperandTypeChecker comparableTypeChecker = (SameOperandTypeChecker)typeChecker;
            pplTypeChecker = PPLTypeChecker.wrapComparable(comparableTypeChecker);
        } else if (typeChecker instanceof UDFOperandMetadata.UDTOperandMetadata) {
            UDFOperandMetadata.UDTOperandMetadata udtOperandMetadata = (UDFOperandMetadata.UDTOperandMetadata)typeChecker;
            pplTypeChecker = PPLTypeChecker.wrapUDT(udtOperandMetadata.allowedParamTypes());
        } else if (typeChecker != null) {
            pplTypeChecker = PPLTypeChecker.wrapDefault(typeChecker);
        } else {
            logger.info("Cannot create type checker for function: {}. Will skip its type checking", (Object)functionName);
            pplTypeChecker = null;
        }
        return pplTypeChecker;
    }

    private static SqlOperandTypeChecker extractTypeCheckerFromUDF(SqlOperator operator) {
        SqlOperandTypeChecker typeChecker = operator.getOperandTypeChecker();
        if (typeChecker instanceof UDFOperandMetadata) {
            UDFOperandMetadata udfOperandMetadata = (UDFOperandMetadata)typeChecker;
            return udfOperandMetadata.getInnerTypeChecker();
        }
        return typeChecker;
    }

    static {
        Builder builder = new Builder();
        builder.populate();
        AggBuilder aggBuilder = new AggBuilder();
        aggBuilder.populate();
        INSTANCE = new PPLFuncImpTable(builder, aggBuilder);
    }

    private static class Builder
    extends AbstractBuilder {
        private final Map<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>> map = new HashMap<BuiltinFunctionName, List<Pair<CalciteFuncSignature, FunctionImp>>>();

        private Builder() {
        }

        @Override
        void register(BuiltinFunctionName functionName, FunctionImp implement, PPLTypeChecker typeChecker) {
            CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), typeChecker);
            if (this.map.containsKey((Object)functionName)) {
                this.map.get((Object)functionName).add((Pair<CalciteFuncSignature, FunctionImp>)Pair.of((Object)signature, (Object)implement));
            } else {
                this.map.put(functionName, new ArrayList<Pair>(List.of(Pair.of((Object)signature, (Object)implement))));
            }
        }
    }

    private static class AggBuilder {
        private static final double MEDIAN_PERCENTILE = 50.0;
        private final Map<BuiltinFunctionName, Pair<CalciteFuncSignature, AggHandler>> map = new HashMap<BuiltinFunctionName, Pair<CalciteFuncSignature, AggHandler>>();

        private AggBuilder() {
        }

        void register(BuiltinFunctionName functionName, AggHandler aggHandler, PPLTypeChecker typeChecker) {
            CalciteFuncSignature signature = new CalciteFuncSignature(functionName.getName(), typeChecker);
            this.map.put(functionName, (Pair<CalciteFuncSignature, AggHandler>)Pair.of((Object)signature, (Object)aggHandler));
        }

        void registerOperator(BuiltinFunctionName functionName, SqlAggFunction aggFunction) {
            SqlOperandTypeChecker innerTypeChecker = PPLFuncImpTable.extractTypeCheckerFromUDF((SqlOperator)aggFunction);
            PPLTypeChecker typeChecker = PPLFuncImpTable.wrapSqlOperandTypeChecker(innerTypeChecker, functionName.name(), true);
            AggHandler handler = (distinct, field, argList, ctx) -> {
                List<RexNode> newArgList = argList.stream().map(PlanUtils::derefMapCall).collect(Collectors.toList());
                return UserDefinedFunctionUtils.makeAggregateCall(aggFunction, List.of(field), newArgList, ctx.relBuilder);
            };
            this.register(functionName, handler, typeChecker);
        }

        void populate() {
            this.registerOperator(BuiltinFunctionName.MAX, SqlStdOperatorTable.MAX);
            this.registerOperator(BuiltinFunctionName.MIN, SqlStdOperatorTable.MIN);
            this.registerOperator(BuiltinFunctionName.SUM, SqlStdOperatorTable.SUM);
            this.registerOperator(BuiltinFunctionName.VARSAMP, PPLBuiltinOperators.VAR_SAMP_NULLABLE);
            this.registerOperator(BuiltinFunctionName.VARPOP, PPLBuiltinOperators.VAR_POP_NULLABLE);
            this.registerOperator(BuiltinFunctionName.STDDEV_SAMP, PPLBuiltinOperators.STDDEV_SAMP_NULLABLE);
            this.registerOperator(BuiltinFunctionName.STDDEV_POP, PPLBuiltinOperators.STDDEV_POP_NULLABLE);
            this.registerOperator(BuiltinFunctionName.TAKE, PPLBuiltinOperators.TAKE);
            this.registerOperator(BuiltinFunctionName.INTERNAL_PATTERN, PPLBuiltinOperators.INTERNAL_PATTERN);
            this.registerOperator(BuiltinFunctionName.LIST, PPLBuiltinOperators.LIST);
            this.registerOperator(BuiltinFunctionName.VALUES, PPLBuiltinOperators.VALUES);
            this.register(BuiltinFunctionName.AVG, (distinct, field, argList, ctx) -> ctx.relBuilder.avg(distinct, null, field), PPLFuncImpTable.wrapSqlOperandTypeChecker(SqlStdOperatorTable.AVG.getOperandTypeChecker(), BuiltinFunctionName.AVG.name(), false));
            this.register(BuiltinFunctionName.COUNT, (distinct, field, argList, ctx) -> {
                if (field == null) {
                    return ctx.relBuilder.count(distinct, null, new RexNode[0]);
                }
                return ctx.relBuilder.count(distinct, null, new RexNode[]{field});
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker((SqlOperandTypeChecker)PPLOperandTypes.OPTIONAL_ANY, BuiltinFunctionName.COUNT.name(), false));
            this.register(BuiltinFunctionName.PERCENTILE_APPROX, (distinct, field, argList, ctx) -> {
                if (field.getType() == null) {
                    throw new IllegalArgumentException("Field type cannot be null");
                }
                List<RexNode> newArgList = argList.stream().map(PlanUtils::derefMapCall).collect(Collectors.toList());
                newArgList.add((RexNode)ctx.rexBuilder.makeFlag((Enum)field.getType().getSqlTypeName()));
                return UserDefinedFunctionUtils.makeAggregateCall(PPLBuiltinOperators.PERCENTILE_APPROX, List.of(field), newArgList, ctx.relBuilder);
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker(PPLFuncImpTable.extractTypeCheckerFromUDF((SqlOperator)PPLBuiltinOperators.PERCENTILE_APPROX), BuiltinFunctionName.PERCENTILE_APPROX.name(), false));
            this.register(BuiltinFunctionName.MEDIAN, (distinct, field, argList, ctx) -> {
                if (distinct) {
                    throw new IllegalArgumentException("MEDIAN does not support DISTINCT");
                }
                if (!argList.isEmpty()) {
                    throw new IllegalArgumentException("MEDIAN takes no additional arguments");
                }
                if (field.getType() == null) {
                    throw new IllegalArgumentException("Field type cannot be null");
                }
                List<RexLiteral> medianArgList = List.of(ctx.rexBuilder.makeExactLiteral(BigDecimal.valueOf(50.0)), ctx.rexBuilder.makeFlag((Enum)field.getType().getSqlTypeName()));
                return UserDefinedFunctionUtils.makeAggregateCall(PPLBuiltinOperators.PERCENTILE_APPROX, List.of(field), medianArgList, ctx.relBuilder);
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker(PPLOperandTypes.NUMERIC.getInnerTypeChecker(), BuiltinFunctionName.MEDIAN.name(), false));
            this.register(BuiltinFunctionName.EARLIEST, (distinct, field, argList, ctx) -> {
                List<RexNode> args = PPLFuncImpTable.resolveTimeField(argList, ctx);
                return UserDefinedFunctionUtils.makeAggregateCall((SqlAggFunction)SqlStdOperatorTable.ARG_MIN, List.of(field), args, ctx.relBuilder);
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker((SqlOperandTypeChecker)PPLOperandTypes.ANY_OPTIONAL_TIMESTAMP, BuiltinFunctionName.EARLIEST.name(), false));
            this.register(BuiltinFunctionName.LATEST, (distinct, field, argList, ctx) -> {
                List<RexNode> args = PPLFuncImpTable.resolveTimeField(argList, ctx);
                return UserDefinedFunctionUtils.makeAggregateCall((SqlAggFunction)SqlStdOperatorTable.ARG_MAX, List.of(field), args, ctx.relBuilder);
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker((SqlOperandTypeChecker)PPLOperandTypes.ANY_OPTIONAL_TIMESTAMP, BuiltinFunctionName.EARLIEST.name(), false));
            this.register(BuiltinFunctionName.FIRST, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(PPLBuiltinOperators.FIRST, new RexNode[]{field}), PPLFuncImpTable.wrapSqlOperandTypeChecker(PPLBuiltinOperators.FIRST.getOperandTypeChecker(), BuiltinFunctionName.FIRST.name(), false));
            this.register(BuiltinFunctionName.LAST, (distinct, field, argList, ctx) -> ctx.relBuilder.aggregateCall(PPLBuiltinOperators.LAST, new RexNode[]{field}), PPLFuncImpTable.wrapSqlOperandTypeChecker(PPLBuiltinOperators.LAST.getOperandTypeChecker(), BuiltinFunctionName.LAST.name(), false));
        }
    }

    @FunctionalInterface
    public static interface AggHandler {
        public RelBuilder.AggCall apply(boolean var1, RexNode var2, List<RexNode> var3, CalcitePlanContext var4);
    }

    public static interface FunctionImp {
        public static final RelDataType ANY_TYPE = OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY);

        public RexNode resolve(RexBuilder var1, RexNode ... var2);
    }

    private static abstract class AbstractBuilder {
        private AbstractBuilder() {
        }

        abstract void register(BuiltinFunctionName var1, FunctionImp var2, PPLTypeChecker var3);

        protected void registerOperator(BuiltinFunctionName functionName, SqlOperator ... operators) {
            for (SqlOperator operator : operators) {
                SqlOperandTypeChecker typeChecker;
                if (operator instanceof SqlUserDefinedFunction) {
                    SqlUserDefinedFunction udfOperator = (SqlUserDefinedFunction)operator;
                    typeChecker = PPLFuncImpTable.extractTypeCheckerFromUDF((SqlOperator)udfOperator);
                } else {
                    typeChecker = operator.getOperandTypeChecker();
                }
                PPLTypeChecker pplTypeChecker = PPLFuncImpTable.wrapSqlOperandTypeChecker(typeChecker, operator.getName(), operator instanceof SqlUserDefinedFunction);
                this.registerOperator(functionName, operator, pplTypeChecker);
            }
        }

        protected void registerOperator(BuiltinFunctionName functionName, SqlOperator operator, PPLTypeChecker typeChecker) {
            this.register(functionName, (builder, args) -> builder.makeCall(operator, args), typeChecker);
        }

        protected void registerDivideFunction(BuiltinFunctionName functionName) {
            this.register(functionName, (builder, left, right) -> {
                SqlOperator operator = CalcitePlanContext.isLegacyPreferred() ? PPLBuiltinOperators.DIVIDE : SqlLibraryOperators.SAFE_DIVIDE;
                return builder.makeCall(operator, new RexNode[]{left, right});
            }, PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC));
        }

        void populate() {
            this.registerOperator(BuiltinFunctionName.NOTEQUAL, new SqlOperator[]{PPLBuiltinOperators.NOT_EQUALS_IP, SqlStdOperatorTable.NOT_EQUALS});
            this.registerOperator(BuiltinFunctionName.EQUAL, new SqlOperator[]{PPLBuiltinOperators.EQUALS_IP, SqlStdOperatorTable.EQUALS});
            this.registerOperator(BuiltinFunctionName.GREATER, new SqlOperator[]{PPLBuiltinOperators.GREATER_IP, SqlStdOperatorTable.GREATER_THAN});
            this.registerOperator(BuiltinFunctionName.GTE, new SqlOperator[]{PPLBuiltinOperators.GTE_IP, SqlStdOperatorTable.GREATER_THAN_OR_EQUAL});
            this.registerOperator(BuiltinFunctionName.LESS, new SqlOperator[]{PPLBuiltinOperators.LESS_IP, SqlStdOperatorTable.LESS_THAN});
            this.registerOperator(BuiltinFunctionName.LTE, new SqlOperator[]{PPLBuiltinOperators.LTE_IP, SqlStdOperatorTable.LESS_THAN_OR_EQUAL});
            this.registerOperator(BuiltinFunctionName.AND, new SqlOperator[]{SqlStdOperatorTable.AND});
            this.registerOperator(BuiltinFunctionName.OR, new SqlOperator[]{SqlStdOperatorTable.OR});
            this.registerOperator(BuiltinFunctionName.NOT, new SqlOperator[]{SqlStdOperatorTable.NOT});
            this.registerOperator(BuiltinFunctionName.ADDFUNCTION, new SqlOperator[]{SqlStdOperatorTable.PLUS});
            this.registerOperator(BuiltinFunctionName.SUBTRACTFUNCTION, (SqlOperator)SqlStdOperatorTable.MINUS, PPLTypeChecker.wrapFamily((ImplicitCastOperandTypeChecker)((FamilyOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC)));
            this.registerOperator(BuiltinFunctionName.SUBTRACT, (SqlOperator)SqlStdOperatorTable.MINUS, PPLTypeChecker.wrapFamily((ImplicitCastOperandTypeChecker)((FamilyOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC)));
            this.registerOperator(BuiltinFunctionName.SUBTRACT, (SqlOperator)SqlStdOperatorTable.MINUS, PPLTypeChecker.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME));
            this.registerOperator(BuiltinFunctionName.MULTIPLY, new SqlOperator[]{SqlStdOperatorTable.MULTIPLY});
            this.registerOperator(BuiltinFunctionName.MULTIPLYFUNCTION, new SqlOperator[]{SqlStdOperatorTable.MULTIPLY});
            this.registerOperator(BuiltinFunctionName.TRUNCATE, new SqlOperator[]{SqlStdOperatorTable.TRUNCATE});
            this.registerOperator(BuiltinFunctionName.ASCII, new SqlOperator[]{SqlStdOperatorTable.ASCII});
            this.registerOperator(BuiltinFunctionName.LENGTH, new SqlOperator[]{SqlStdOperatorTable.CHAR_LENGTH});
            this.registerOperator(BuiltinFunctionName.LOWER, new SqlOperator[]{SqlStdOperatorTable.LOWER});
            this.registerOperator(BuiltinFunctionName.POSITION, new SqlOperator[]{SqlStdOperatorTable.POSITION});
            this.registerOperator(BuiltinFunctionName.LOCATE, new SqlOperator[]{SqlStdOperatorTable.POSITION});
            this.register(BuiltinFunctionName.REPLACE, (builder, args) -> {
                String javaReplacement;
                RexLiteral literal;
                String replacement;
                RexLiteral patternLiteral;
                String pattern;
                if (args.length >= 2 && args[1] instanceof RexLiteral && (pattern = (String)(patternLiteral = (RexLiteral)args[1]).getValueAs(String.class)) != null) {
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException e) {
                        throw new IllegalArgumentException(String.format("Invalid regex pattern '%s': %s", pattern, e.getDescription()), e);
                    }
                }
                if (args.length == 3 && args[2] instanceof RexLiteral && (replacement = (String)(literal = (RexLiteral)args[2]).getValueAs(String.class)) != null && !(javaReplacement = replacement.replaceAll("\\\\(\\d+)", "\\$$1")).equals(replacement)) {
                    RexNode convertedLiteral = builder.makeLiteral((Object)javaReplacement, literal.getType(), literal.getTypeName() != SqlTypeName.CHAR);
                    return builder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_3, new RexNode[]{args[0], args[1], convertedLiteral});
                }
                return builder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE_3, args);
            }, PPLFuncImpTable.wrapSqlOperandTypeChecker(SqlLibraryOperators.REGEXP_REPLACE_3.getOperandTypeChecker(), BuiltinFunctionName.REPLACE.name(), false));
            this.registerOperator(BuiltinFunctionName.UPPER, new SqlOperator[]{SqlStdOperatorTable.UPPER});
            this.registerOperator(BuiltinFunctionName.ABS, new SqlOperator[]{SqlStdOperatorTable.ABS});
            this.registerOperator(BuiltinFunctionName.ACOS, new SqlOperator[]{SqlStdOperatorTable.ACOS});
            this.registerOperator(BuiltinFunctionName.ASIN, new SqlOperator[]{SqlStdOperatorTable.ASIN});
            this.registerOperator(BuiltinFunctionName.ATAN, new SqlOperator[]{SqlStdOperatorTable.ATAN});
            this.registerOperator(BuiltinFunctionName.ATAN2, new SqlOperator[]{SqlStdOperatorTable.ATAN2});
            this.registerOperator(BuiltinFunctionName.CEIL, (SqlOperator)SqlStdOperatorTable.CEIL, PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.NUMERIC_OR_INTERVAL.or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATETIME, SqlTypeFamily.ANY})), false));
            this.registerOperator(BuiltinFunctionName.CEILING, (SqlOperator)SqlStdOperatorTable.CEIL, PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.NUMERIC_OR_INTERVAL.or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATETIME, SqlTypeFamily.ANY})), false));
            this.registerOperator(BuiltinFunctionName.COS, new SqlOperator[]{SqlStdOperatorTable.COS});
            this.registerOperator(BuiltinFunctionName.COT, new SqlOperator[]{SqlStdOperatorTable.COT});
            this.registerOperator(BuiltinFunctionName.DEGREES, new SqlOperator[]{SqlStdOperatorTable.DEGREES});
            this.registerOperator(BuiltinFunctionName.EXP, new SqlOperator[]{SqlStdOperatorTable.EXP});
            this.registerOperator(BuiltinFunctionName.FLOOR, (SqlOperator)SqlStdOperatorTable.FLOOR, PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.NUMERIC_OR_INTERVAL.or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATETIME, SqlTypeFamily.ANY})), false));
            this.registerOperator(BuiltinFunctionName.LN, new SqlOperator[]{SqlStdOperatorTable.LN});
            this.registerOperator(BuiltinFunctionName.LOG10, new SqlOperator[]{SqlStdOperatorTable.LOG10});
            this.registerOperator(BuiltinFunctionName.PI, new SqlOperator[]{SqlStdOperatorTable.PI});
            this.registerOperator(BuiltinFunctionName.POW, new SqlOperator[]{SqlStdOperatorTable.POWER});
            this.registerOperator(BuiltinFunctionName.POWER, new SqlOperator[]{SqlStdOperatorTable.POWER});
            this.registerOperator(BuiltinFunctionName.RADIANS, new SqlOperator[]{SqlStdOperatorTable.RADIANS});
            this.registerOperator(BuiltinFunctionName.RAND, new SqlOperator[]{SqlStdOperatorTable.RAND});
            this.registerOperator(BuiltinFunctionName.ROUND, (SqlOperator)SqlStdOperatorTable.ROUND, PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.NUMERIC.or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER})), false));
            this.registerOperator(BuiltinFunctionName.SIGN, new SqlOperator[]{SqlStdOperatorTable.SIGN});
            this.registerOperator(BuiltinFunctionName.SIGNUM, new SqlOperator[]{SqlStdOperatorTable.SIGN});
            this.registerOperator(BuiltinFunctionName.SIN, new SqlOperator[]{SqlStdOperatorTable.SIN});
            this.registerOperator(BuiltinFunctionName.CBRT, new SqlOperator[]{SqlStdOperatorTable.CBRT});
            this.registerOperator(BuiltinFunctionName.IFNULL, new SqlOperator[]{SqlStdOperatorTable.COALESCE});
            this.registerOperator(BuiltinFunctionName.EARLIEST, PPLBuiltinOperators.EARLIEST);
            this.registerOperator(BuiltinFunctionName.LATEST, PPLBuiltinOperators.LATEST);
            this.registerOperator(BuiltinFunctionName.COALESCE, PPLBuiltinOperators.ENHANCED_COALESCE);
            this.registerOperator(BuiltinFunctionName.REGEXP, new SqlOperator[]{SqlLibraryOperators.REGEXP});
            this.registerOperator(BuiltinFunctionName.REGEXP_MATCH, new SqlOperator[]{SqlLibraryOperators.REGEXP_CONTAINS});
            this.registerOperator(BuiltinFunctionName.CONCAT, new SqlOperator[]{SqlLibraryOperators.CONCAT_FUNCTION});
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, new SqlOperator[]{SqlLibraryOperators.CONCAT_WS});
            this.registerOperator(BuiltinFunctionName.CONCAT_WS, new SqlOperator[]{SqlLibraryOperators.CONCAT_WS});
            this.registerOperator(BuiltinFunctionName.REVERSE, new SqlOperator[]{SqlLibraryOperators.REVERSE});
            this.registerOperator(BuiltinFunctionName.RIGHT, new SqlOperator[]{SqlLibraryOperators.RIGHT});
            this.registerOperator(BuiltinFunctionName.LEFT, new SqlOperator[]{SqlLibraryOperators.LEFT});
            this.registerOperator(BuiltinFunctionName.LOG2, new SqlOperator[]{SqlLibraryOperators.LOG2});
            this.registerOperator(BuiltinFunctionName.MD5, new SqlOperator[]{SqlLibraryOperators.MD5});
            this.registerOperator(BuiltinFunctionName.SHA1, new SqlOperator[]{SqlLibraryOperators.SHA1});
            this.registerOperator(BuiltinFunctionName.CRC32, new SqlOperator[]{SqlLibraryOperators.CRC32});
            this.registerOperator(BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_PG_4, new SqlOperator[]{SqlLibraryOperators.REGEXP_REPLACE_PG_4});
            this.registerOperator(BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_5, new SqlOperator[]{SqlLibraryOperators.REGEXP_REPLACE_5});
            this.registerOperator(BuiltinFunctionName.INTERNAL_TRANSLATE3, new SqlOperator[]{SqlLibraryOperators.TRANSLATE3});
            this.registerOperator(BuiltinFunctionName.MAX, PPLBuiltinOperators.SCALAR_MAX);
            this.registerOperator(BuiltinFunctionName.MIN, PPLBuiltinOperators.SCALAR_MIN);
            this.registerOperator(BuiltinFunctionName.COSH, PPLBuiltinOperators.COSH);
            this.registerOperator(BuiltinFunctionName.SINH, PPLBuiltinOperators.SINH);
            this.registerOperator(BuiltinFunctionName.EXPM1, PPLBuiltinOperators.EXPM1);
            this.registerOperator(BuiltinFunctionName.RINT, PPLBuiltinOperators.RINT);
            this.registerOperator(BuiltinFunctionName.SPAN, PPLBuiltinOperators.SPAN);
            this.registerOperator(BuiltinFunctionName.SPAN_BUCKET, PPLBuiltinOperators.SPAN_BUCKET);
            this.registerOperator(BuiltinFunctionName.WIDTH_BUCKET, PPLBuiltinOperators.WIDTH_BUCKET);
            this.registerOperator(BuiltinFunctionName.MINSPAN_BUCKET, PPLBuiltinOperators.MINSPAN_BUCKET);
            this.registerOperator(BuiltinFunctionName.RANGE_BUCKET, PPLBuiltinOperators.RANGE_BUCKET);
            this.registerOperator(BuiltinFunctionName.E, PPLBuiltinOperators.E);
            this.registerOperator(BuiltinFunctionName.CONV, PPLBuiltinOperators.CONV);
            this.registerOperator(BuiltinFunctionName.MOD, PPLBuiltinOperators.MOD);
            this.registerOperator(BuiltinFunctionName.MODULUS, PPLBuiltinOperators.MOD);
            this.registerOperator(BuiltinFunctionName.MODULUSFUNCTION, PPLBuiltinOperators.MOD);
            this.registerDivideFunction(BuiltinFunctionName.DIVIDE);
            this.registerDivideFunction(BuiltinFunctionName.DIVIDEFUNCTION);
            this.registerOperator(BuiltinFunctionName.SHA2, PPLBuiltinOperators.SHA2);
            this.registerOperator(BuiltinFunctionName.CIDRMATCH, PPLBuiltinOperators.CIDRMATCH);
            this.registerOperator(BuiltinFunctionName.INTERNAL_GROK, PPLBuiltinOperators.GROK);
            this.registerOperator(BuiltinFunctionName.INTERNAL_PARSE, PPLBuiltinOperators.PARSE);
            this.registerOperator(BuiltinFunctionName.MATCH, PPLBuiltinOperators.MATCH);
            this.registerOperator(BuiltinFunctionName.MATCH_PHRASE, PPLBuiltinOperators.MATCH_PHRASE);
            this.registerOperator(BuiltinFunctionName.MATCH_BOOL_PREFIX, PPLBuiltinOperators.MATCH_BOOL_PREFIX);
            this.registerOperator(BuiltinFunctionName.MATCH_PHRASE_PREFIX, PPLBuiltinOperators.MATCH_PHRASE_PREFIX);
            this.registerOperator(BuiltinFunctionName.SIMPLE_QUERY_STRING, PPLBuiltinOperators.SIMPLE_QUERY_STRING);
            this.registerOperator(BuiltinFunctionName.QUERY_STRING, PPLBuiltinOperators.QUERY_STRING);
            this.registerOperator(BuiltinFunctionName.MULTI_MATCH, PPLBuiltinOperators.MULTI_MATCH);
            this.registerOperator(BuiltinFunctionName.REX_EXTRACT, PPLBuiltinOperators.REX_EXTRACT);
            this.registerOperator(BuiltinFunctionName.REX_EXTRACT_MULTI, PPLBuiltinOperators.REX_EXTRACT_MULTI);
            this.registerOperator(BuiltinFunctionName.REX_OFFSET, PPLBuiltinOperators.REX_OFFSET);
            this.registerOperator(BuiltinFunctionName.TIMESTAMP, PPLBuiltinOperators.TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.DATE, PPLBuiltinOperators.DATE);
            this.registerOperator(BuiltinFunctionName.TIME, PPLBuiltinOperators.TIME);
            this.registerOperator(BuiltinFunctionName.UTC_TIME, PPLBuiltinOperators.UTC_TIME);
            this.registerOperator(BuiltinFunctionName.UTC_DATE, PPLBuiltinOperators.UTC_DATE);
            this.registerOperator(BuiltinFunctionName.UTC_TIMESTAMP, PPLBuiltinOperators.UTC_TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.YEAR, PPLBuiltinOperators.YEAR);
            this.registerOperator(BuiltinFunctionName.YEARWEEK, PPLBuiltinOperators.YEARWEEK);
            this.registerOperator(BuiltinFunctionName.WEEKDAY, PPLBuiltinOperators.WEEKDAY);
            this.registerOperator(BuiltinFunctionName.UNIX_TIMESTAMP, PPLBuiltinOperators.UNIX_TIMESTAMP);
            this.registerOperator(BuiltinFunctionName.STRFTIME, PPLBuiltinOperators.STRFTIME);
            this.registerOperator(BuiltinFunctionName.TO_SECONDS, PPLBuiltinOperators.TO_SECONDS);
            this.registerOperator(BuiltinFunctionName.TO_DAYS, PPLBuiltinOperators.TO_DAYS);
            this.registerOperator(BuiltinFunctionName.ADDTIME, PPLBuiltinOperators.ADDTIME);
            this.registerOperator(BuiltinFunctionName.SUBTIME, PPLBuiltinOperators.SUBTIME);
            this.registerOperator(BuiltinFunctionName.ADDDATE, PPLBuiltinOperators.ADDDATE);
            this.registerOperator(BuiltinFunctionName.SUBDATE, PPLBuiltinOperators.SUBDATE);
            this.registerOperator(BuiltinFunctionName.DATE_ADD, PPLBuiltinOperators.DATE_ADD);
            this.registerOperator(BuiltinFunctionName.DATE_SUB, PPLBuiltinOperators.DATE_SUB);
            this.registerOperator(BuiltinFunctionName.EXTRACT, PPLBuiltinOperators.EXTRACT);
            this.registerOperator(BuiltinFunctionName.QUARTER, PPLBuiltinOperators.QUARTER);
            this.registerOperator(BuiltinFunctionName.MONTH, PPLBuiltinOperators.MONTH);
            this.registerOperator(BuiltinFunctionName.MONTH_OF_YEAR, PPLBuiltinOperators.MONTH);
            this.registerOperator(BuiltinFunctionName.DAY, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAYOFMONTH, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAY_OF_MONTH, PPLBuiltinOperators.DAY);
            this.registerOperator(BuiltinFunctionName.DAYOFWEEK, PPLBuiltinOperators.DAY_OF_WEEK);
            this.registerOperator(BuiltinFunctionName.DAY_OF_WEEK, PPLBuiltinOperators.DAY_OF_WEEK);
            this.registerOperator(BuiltinFunctionName.DAYOFYEAR, PPLBuiltinOperators.DAY_OF_YEAR);
            this.registerOperator(BuiltinFunctionName.DAY_OF_YEAR, PPLBuiltinOperators.DAY_OF_YEAR);
            this.registerOperator(BuiltinFunctionName.HOUR, PPLBuiltinOperators.HOUR);
            this.registerOperator(BuiltinFunctionName.HOUR_OF_DAY, PPLBuiltinOperators.HOUR);
            this.registerOperator(BuiltinFunctionName.MINUTE, PPLBuiltinOperators.MINUTE);
            this.registerOperator(BuiltinFunctionName.MINUTE_OF_HOUR, PPLBuiltinOperators.MINUTE);
            this.registerOperator(BuiltinFunctionName.MINUTE_OF_DAY, PPLBuiltinOperators.MINUTE_OF_DAY);
            this.registerOperator(BuiltinFunctionName.SECOND, PPLBuiltinOperators.SECOND);
            this.registerOperator(BuiltinFunctionName.SECOND_OF_MINUTE, PPLBuiltinOperators.SECOND);
            this.registerOperator(BuiltinFunctionName.MICROSECOND, PPLBuiltinOperators.MICROSECOND);
            this.registerOperator(BuiltinFunctionName.CURRENT_TIMESTAMP, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.NOW, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.LOCALTIMESTAMP, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.LOCALTIME, PPLBuiltinOperators.NOW);
            this.registerOperator(BuiltinFunctionName.CURTIME, PPLBuiltinOperators.CURRENT_TIME);
            this.registerOperator(BuiltinFunctionName.CURRENT_TIME, PPLBuiltinOperators.CURRENT_TIME);
            this.registerOperator(BuiltinFunctionName.CURRENT_DATE, PPLBuiltinOperators.CURRENT_DATE);
            this.registerOperator(BuiltinFunctionName.CURDATE, PPLBuiltinOperators.CURRENT_DATE);
            this.registerOperator(BuiltinFunctionName.DATE_FORMAT, PPLBuiltinOperators.DATE_FORMAT);
            this.registerOperator(BuiltinFunctionName.TIME_FORMAT, PPLBuiltinOperators.TIME_FORMAT);
            this.registerOperator(BuiltinFunctionName.DAYNAME, PPLBuiltinOperators.DAYNAME);
            this.registerOperator(BuiltinFunctionName.MONTHNAME, PPLBuiltinOperators.MONTHNAME);
            this.registerOperator(BuiltinFunctionName.CONVERT_TZ, PPLBuiltinOperators.CONVERT_TZ);
            this.registerOperator(BuiltinFunctionName.DATEDIFF, PPLBuiltinOperators.DATEDIFF);
            this.registerOperator(BuiltinFunctionName.DATETIME, PPLBuiltinOperators.DATETIME);
            this.registerOperator(BuiltinFunctionName.TIMESTAMPDIFF, PPLBuiltinOperators.TIMESTAMPDIFF);
            this.registerOperator(BuiltinFunctionName.LAST_DAY, PPLBuiltinOperators.LAST_DAY);
            this.registerOperator(BuiltinFunctionName.FROM_DAYS, PPLBuiltinOperators.FROM_DAYS);
            this.registerOperator(BuiltinFunctionName.FROM_UNIXTIME, PPLBuiltinOperators.FROM_UNIXTIME);
            this.registerOperator(BuiltinFunctionName.GET_FORMAT, PPLBuiltinOperators.GET_FORMAT);
            this.registerOperator(BuiltinFunctionName.MAKEDATE, PPLBuiltinOperators.MAKEDATE);
            this.registerOperator(BuiltinFunctionName.MAKETIME, PPLBuiltinOperators.MAKETIME);
            this.registerOperator(BuiltinFunctionName.PERIOD_ADD, PPLBuiltinOperators.PERIOD_ADD);
            this.registerOperator(BuiltinFunctionName.PERIOD_DIFF, PPLBuiltinOperators.PERIOD_DIFF);
            this.registerOperator(BuiltinFunctionName.SEC_TO_TIME, PPLBuiltinOperators.SEC_TO_TIME);
            this.registerOperator(BuiltinFunctionName.STR_TO_DATE, PPLBuiltinOperators.STR_TO_DATE);
            this.registerOperator(BuiltinFunctionName.SYSDATE, PPLBuiltinOperators.SYSDATE);
            this.registerOperator(BuiltinFunctionName.TIME_TO_SEC, PPLBuiltinOperators.TIME_TO_SEC);
            this.registerOperator(BuiltinFunctionName.TIMEDIFF, PPLBuiltinOperators.TIMEDIFF);
            this.registerOperator(BuiltinFunctionName.TIMESTAMPADD, PPLBuiltinOperators.TIMESTAMPADD);
            this.registerOperator(BuiltinFunctionName.WEEK, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.WEEK_OF_YEAR, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.WEEKOFYEAR, PPLBuiltinOperators.WEEK);
            this.registerOperator(BuiltinFunctionName.INTERNAL_PATTERN_PARSER, PPLBuiltinOperators.PATTERN_PARSER);
            this.registerOperator(BuiltinFunctionName.TOSTRING, PPLBuiltinOperators.TOSTRING);
            this.register(BuiltinFunctionName.TOSTRING, (builder, source) -> builder.makeCast(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR, true), source), PPLTypeChecker.family(SqlTypeFamily.ANY));
            this.register(BuiltinFunctionName.MVJOIN, (builder, array, delimiter) -> builder.makeCall((SqlOperator)SqlLibraryOperators.ARRAY_JOIN, new RexNode[]{array, delimiter}), PPLTypeChecker.family(SqlTypeFamily.ARRAY, SqlTypeFamily.CHARACTER));
            this.register(BuiltinFunctionName.MVINDEX, new MVIndexFunctionImp(), PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER})), false));
            this.registerOperator(BuiltinFunctionName.ARRAY, PPLBuiltinOperators.ARRAY);
            this.registerOperator(BuiltinFunctionName.MVAPPEND, PPLBuiltinOperators.MVAPPEND);
            this.registerOperator(BuiltinFunctionName.MVDEDUP, new SqlOperator[]{SqlLibraryOperators.ARRAY_DISTINCT});
            this.registerOperator(BuiltinFunctionName.MAP_APPEND, PPLBuiltinOperators.MAP_APPEND);
            this.registerOperator(BuiltinFunctionName.MAP_CONCAT, new SqlOperator[]{SqlLibraryOperators.MAP_CONCAT});
            this.registerOperator(BuiltinFunctionName.MAP_REMOVE, PPLBuiltinOperators.MAP_REMOVE);
            this.registerOperator(BuiltinFunctionName.ARRAY_LENGTH, new SqlOperator[]{SqlLibraryOperators.ARRAY_LENGTH});
            this.registerOperator(BuiltinFunctionName.ARRAY_SLICE, new SqlOperator[]{SqlLibraryOperators.ARRAY_SLICE});
            this.registerOperator(BuiltinFunctionName.FORALL, PPLBuiltinOperators.FORALL);
            this.registerOperator(BuiltinFunctionName.EXISTS, PPLBuiltinOperators.EXISTS);
            this.registerOperator(BuiltinFunctionName.FILTER, PPLBuiltinOperators.FILTER);
            this.registerOperator(BuiltinFunctionName.TRANSFORM, PPLBuiltinOperators.TRANSFORM);
            this.registerOperator(BuiltinFunctionName.REDUCE, PPLBuiltinOperators.REDUCE);
            this.register(BuiltinFunctionName.JSON_ARRAY, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, (RexNode[])Stream.concat(Stream.of(builder.makeFlag((Enum)SqlJsonConstructorNullClause.NULL_ON_NULL)), Arrays.stream(args)).toArray(RexNode[]::new)), null);
            this.register(BuiltinFunctionName.JSON_OBJECT, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, (RexNode[])Stream.concat(Stream.of(builder.makeFlag((Enum)SqlJsonConstructorNullClause.NULL_ON_NULL)), Arrays.stream(args)).toArray(RexNode[]::new)), null);
            this.registerOperator(BuiltinFunctionName.JSON, PPLBuiltinOperators.JSON);
            this.registerOperator(BuiltinFunctionName.JSON_ARRAY_LENGTH, PPLBuiltinOperators.JSON_ARRAY_LENGTH);
            this.registerOperator(BuiltinFunctionName.JSON_EXTRACT, PPLBuiltinOperators.JSON_EXTRACT);
            this.registerOperator(BuiltinFunctionName.JSON_KEYS, PPLBuiltinOperators.JSON_KEYS);
            this.registerOperator(BuiltinFunctionName.JSON_VALID, new SqlOperator[]{SqlStdOperatorTable.IS_JSON_VALUE});
            this.registerOperator(BuiltinFunctionName.JSON_SET, PPLBuiltinOperators.JSON_SET);
            this.registerOperator(BuiltinFunctionName.JSON_DELETE, PPLBuiltinOperators.JSON_DELETE);
            this.registerOperator(BuiltinFunctionName.JSON_APPEND, PPLBuiltinOperators.JSON_APPEND);
            this.registerOperator(BuiltinFunctionName.JSON_EXTEND, PPLBuiltinOperators.JSON_EXTEND);
            this.registerOperator(BuiltinFunctionName.JSON_EXTRACT_ALL, PPLBuiltinOperators.JSON_EXTRACT_ALL);
            this.registerOperator(BuiltinFunctionName.ADD, (SqlOperator)SqlStdOperatorTable.CONCAT, PPLTypeChecker.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER));
            this.registerOperator(BuiltinFunctionName.ADD, (SqlOperator)SqlStdOperatorTable.PLUS, PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC));
            this.registerOperator(BuiltinFunctionName.INTERNAL_ITEM, SqlStdOperatorTable.ITEM, PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.ANY})), false));
            this.registerOperator(BuiltinFunctionName.XOR, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, PPLTypeChecker.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN));
            this.registerOperator(BuiltinFunctionName.IF, (SqlOperator)SqlStdOperatorTable.CASE, PPLTypeChecker.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.ANY, SqlTypeFamily.ANY));
            this.registerOperator(BuiltinFunctionName.IS_NOT_NULL, (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, PPLTypeChecker.family(SqlTypeFamily.IGNORE));
            this.registerOperator(BuiltinFunctionName.IS_PRESENT, (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, PPLTypeChecker.family(SqlTypeFamily.IGNORE));
            this.registerOperator(BuiltinFunctionName.IS_NULL, (SqlOperator)SqlStdOperatorTable.IS_NULL, PPLTypeChecker.family(SqlTypeFamily.IGNORE));
            this.register(BuiltinFunctionName.TRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), builder.makeLiteral(" "), arg}), PPLTypeChecker.family(SqlTypeFamily.CHARACTER));
            this.register(BuiltinFunctionName.LTRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.LEADING), builder.makeLiteral(" "), arg}), PPLTypeChecker.family(SqlTypeFamily.CHARACTER));
            this.register(BuiltinFunctionName.RTRIM, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), builder.makeLiteral(" "), arg}), PPLTypeChecker.family(SqlTypeFamily.CHARACTER));
            this.registerOperator(BuiltinFunctionName.ATAN, (SqlOperator)SqlStdOperatorTable.ATAN2, PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC));
            this.register(BuiltinFunctionName.STRCMP, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.STRCMP, new RexNode[]{arg2, arg1}), PPLTypeChecker.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER));
            this.register(BuiltinFunctionName.SUBSTRING, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, args), PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER})), false));
            this.register(BuiltinFunctionName.SUBSTR, (builder, args) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, args), PPLTypeChecker.wrapComposite((CompositeOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER}).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER})), false));
            this.register(BuiltinFunctionName.LOG, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg2, arg1}), PPLTypeChecker.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC));
            this.register(BuiltinFunctionName.LOG, (builder, arg) -> builder.makeCall((SqlOperator)SqlLibraryOperators.LOG, new RexNode[]{arg, builder.makeApproxLiteral(BigDecimal.valueOf(Math.E))}), PPLTypeChecker.family(SqlTypeFamily.NUMERIC));
            this.register(BuiltinFunctionName.SQRT, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{arg, builder.makeApproxLiteral(BigDecimal.valueOf(0.5))}), PPLTypeChecker.family(SqlTypeFamily.NUMERIC));
            this.register(BuiltinFunctionName.TYPEOF, (builder, arg) -> builder.makeLiteral(OpenSearchTypeFactory.getLegacyTypeName(arg.getType(), QueryType.PPL)), null);
            this.register(BuiltinFunctionName.NULLIF, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{arg1, arg2}), builder.makeNullLiteral(arg1.getType()), arg1}), PPLTypeChecker.wrapComparable((SameOperandTypeChecker)OperandTypes.SAME_SAME));
            this.register(BuiltinFunctionName.IS_EMPTY, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg}), builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_EMPTY, new RexNode[]{arg})}), PPLTypeChecker.family(SqlTypeFamily.ANY));
            this.register(BuiltinFunctionName.IS_BLANK, (builder, arg) -> builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg}), builder.makeCall((SqlOperator)SqlStdOperatorTable.IS_EMPTY, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{builder.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), builder.makeLiteral(" "), arg})})}), PPLTypeChecker.family(SqlTypeFamily.ANY));
            this.register(BuiltinFunctionName.ILIKE, (builder, arg1, arg2) -> builder.makeCall((SqlOperator)SqlLibraryOperators.ILIKE, new RexNode[]{arg1, arg2, builder.makeLiteral("\\")}), PPLTypeChecker.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING));
            this.register(BuiltinFunctionName.LIKE, (builder, arg1, arg2, arg3) -> (Boolean)((RexLiteral)arg3).getValueAs(Boolean.class) != false ? builder.makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{arg1, arg2, builder.makeLiteral("\\")}) : builder.makeCall((SqlOperator)SqlLibraryOperators.ILIKE, new RexNode[]{arg1, arg2, builder.makeLiteral("\\")}), PPLTypeChecker.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.BOOLEAN));
        }
    }

    public static interface FunctionImp3
    extends FunctionImp {
        public RexNode resolve(RexBuilder var1, RexNode var2, RexNode var3, RexNode var4);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 3) {
                throw new IllegalArgumentException("This function requires exactly 3 arguments");
            }
            return this.resolve(builder, args[0], args[1], args[2]);
        }
    }

    public static interface FunctionImp2
    extends FunctionImp {
        public RexNode resolve(RexBuilder var1, RexNode var2, RexNode var3);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException("This function requires exactly 2 arguments");
            }
            return this.resolve(builder, args[0], args[1]);
        }
    }

    public static interface FunctionImp1
    extends FunctionImp {
        public RexNode resolve(RexBuilder var1, RexNode var2);

        @Override
        default public RexNode resolve(RexBuilder builder, RexNode ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException("This function requires exactly 1 arguments");
            }
            return this.resolve(builder, args[0]);
        }
    }
}

