/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import lombok.Generated;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.mapper.NormalizeVectorTransformer;
import org.opensearch.knn.index.mapper.VectorTransformer;

public final class VectorTransformerFactory {
    public static final VectorTransformer NOOP_VECTOR_TRANSFORMER = new VectorTransformer(){};
    private static final NormalizeVectorTransformer DEFAULT_VECTOR_TRANSFORMER = new NormalizeVectorTransformer();

    public static VectorTransformer getVectorTransformer(KNNEngine knnEngine, SpaceType spaceType) {
        return VectorTransformerFactory.shouldNormalizeVector(knnEngine, spaceType) ? DEFAULT_VECTOR_TRANSFORMER : NOOP_VECTOR_TRANSFORMER;
    }

    private static boolean shouldNormalizeVector(KNNEngine knnEngine, SpaceType spaceType) {
        return knnEngine == KNNEngine.FAISS && spaceType == SpaceType.COSINESIMIL;
    }

    @Generated
    private VectorTransformerFactory() {
    }
}

