/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SP80038FWrapEngine
extends SP80038FWrapper {
    public SP80038FWrapEngine(BlockCipher blockCipher, boolean bl) {
        super(blockCipher, ivKW, bl);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KW";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n3 = n2 / this.delta;
        if (n3 * this.delta != n2) {
            throw new DataLengthException("wrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[n2 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, n, byArray2, this.iv.length, n2);
        if (n3 == 1) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("wrap data must be at least " + 2 * this.delta + " bytes");
            }
            this.engine.init(this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray2, 0, byArray2, 0);
            return byArray2;
        }
        return this.W(n3, byArray2);
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n3 = n2 / this.delta;
        if (n3 * this.delta != n2) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] byArray2 = new byte[this.iv.length];
        byte[] byArray3 = new byte[n2 - this.iv.length];
        if (n3 == 2) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("wrapped data must be at least " + 3 * this.delta + " bytes");
            }
            byte[] byArray4 = new byte[2 * this.delta];
            System.arraycopy(byArray, 0, byArray4, 0, byArray4.length);
            this.engine.init(!this.wrapCipherMode, this.param);
            this.engine.processBlock(byArray4, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, byArray2, 0, this.iv.length);
            System.arraycopy(byArray4, this.iv.length, byArray3, 0, n2 - this.iv.length);
        } else {
            System.arraycopy(byArray, n, byArray2, 0, this.iv.length);
            System.arraycopy(byArray, n + this.iv.length, byArray3, 0, n2 - this.iv.length);
            this.invW(n3, byArray3, byArray2);
        }
        if (!Arrays.constantTimeAreEqual(byArray2, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray3;
    }
}

