/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_relevance;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.search_relevance.GetStatsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetStatsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetStatsRequest> {
    @Nullable
    private final String flatStatPaths;
    @Nullable
    private final String includeAllNodes;
    @Nullable
    private final String includeIndividualNodes;
    @Nullable
    private final String includeInfo;
    @Nullable
    private final String includeMetadata;
    @Nullable
    private final String stat;
    public static final Endpoint<GetStatsRequest, GetStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetStatsRequest, GetStatsResponse>(request -> "GET", request -> {
        boolean _stat = true;
        boolean propsSet = false;
        if (request.stat() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_search_relevance/stats";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_search_relevance/stats/");
            SimpleEndpoint.pathEncode(request.stat, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetStatsResponse._DESERIALIZER);

    private GetStatsRequest(Builder builder) {
        super(builder);
        this.flatStatPaths = builder.flatStatPaths;
        this.includeAllNodes = builder.includeAllNodes;
        this.includeIndividualNodes = builder.includeIndividualNodes;
        this.includeInfo = builder.includeInfo;
        this.includeMetadata = builder.includeMetadata;
        this.stat = builder.stat;
    }

    public static GetStatsRequest of(Function<Builder, ObjectBuilder<GetStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String flatStatPaths() {
        return this.flatStatPaths;
    }

    @Nullable
    public final String includeAllNodes() {
        return this.includeAllNodes;
    }

    @Nullable
    public final String includeIndividualNodes() {
        return this.includeIndividualNodes;
    }

    @Nullable
    public final String includeInfo() {
        return this.includeInfo;
    }

    @Nullable
    public final String includeMetadata() {
        return this.includeMetadata;
    }

    @Nullable
    public final String stat() {
        return this.stat;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.flatStatPaths != null) {
            params.put("flat_stat_paths", this.flatStatPaths);
        }
        if (this.includeAllNodes != null) {
            params.put("include_all_nodes", this.includeAllNodes);
        }
        if (this.includeIndividualNodes != null) {
            params.put("include_individual_nodes", this.includeIndividualNodes);
        }
        if (this.includeInfo != null) {
            params.put("include_info", this.includeInfo);
        }
        if (this.includeMetadata != null) {
            params.put("include_metadata", this.includeMetadata);
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.flatStatPaths);
        result = 31 * result + Objects.hashCode(this.includeAllNodes);
        result = 31 * result + Objects.hashCode(this.includeIndividualNodes);
        result = 31 * result + Objects.hashCode(this.includeInfo);
        result = 31 * result + Objects.hashCode(this.includeMetadata);
        result = 31 * result + Objects.hashCode(this.stat);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStatsRequest other = (GetStatsRequest)o;
        return Objects.equals(this.flatStatPaths, other.flatStatPaths) && Objects.equals(this.includeAllNodes, other.includeAllNodes) && Objects.equals(this.includeIndividualNodes, other.includeIndividualNodes) && Objects.equals(this.includeInfo, other.includeInfo) && Objects.equals(this.includeMetadata, other.includeMetadata) && Objects.equals(this.stat, other.stat);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetStatsRequest> {
        @Nullable
        private String flatStatPaths;
        @Nullable
        private String includeAllNodes;
        @Nullable
        private String includeIndividualNodes;
        @Nullable
        private String includeInfo;
        @Nullable
        private String includeMetadata;
        @Nullable
        private String stat;

        public Builder() {
        }

        private Builder(GetStatsRequest o) {
            super(o);
            this.flatStatPaths = o.flatStatPaths;
            this.includeAllNodes = o.includeAllNodes;
            this.includeIndividualNodes = o.includeIndividualNodes;
            this.includeInfo = o.includeInfo;
            this.includeMetadata = o.includeMetadata;
            this.stat = o.stat;
        }

        private Builder(Builder o) {
            super(o);
            this.flatStatPaths = o.flatStatPaths;
            this.includeAllNodes = o.includeAllNodes;
            this.includeIndividualNodes = o.includeIndividualNodes;
            this.includeInfo = o.includeInfo;
            this.includeMetadata = o.includeMetadata;
            this.stat = o.stat;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder flatStatPaths(@Nullable String value) {
            this.flatStatPaths = value;
            return this;
        }

        @Nonnull
        public final Builder includeAllNodes(@Nullable String value) {
            this.includeAllNodes = value;
            return this;
        }

        @Nonnull
        public final Builder includeIndividualNodes(@Nullable String value) {
            this.includeIndividualNodes = value;
            return this;
        }

        @Nonnull
        public final Builder includeInfo(@Nullable String value) {
            this.includeInfo = value;
            return this;
        }

        @Nonnull
        public final Builder includeMetadata(@Nullable String value) {
            this.includeMetadata = value;
            return this;
        }

        @Nonnull
        public final Builder stat(@Nullable String value) {
            this.stat = value;
            return this;
        }

        @Override
        @Nonnull
        public GetStatsRequest build() {
            this._checkSingleUse();
            return new GetStatsRequest(this);
        }
    }
}

