/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.opensearch.nodes.stats.Stats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodesStatsResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, NodesStatsResponse> {
    @Nullable
    private final String clusterName;
    @Nonnull
    private final Map<String, Stats> nodes;
    public static final JsonpDeserializer<NodesStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodesStatsResponse::setupNodesStatsResponseDeserializer);

    private NodesStatsResponse(Builder builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static NodesStatsResponse of(Function<Builder, ObjectBuilder<NodesStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final Map<String, Stats> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, Stats> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodesStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        NodesStatsResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(Stats._DESERIALIZER), "nodes");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + this.nodes.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesStatsResponse other = (NodesStatsResponse)o;
        return Objects.equals(this.clusterName, other.clusterName) && this.nodes.equals(other.nodes);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodesStatsResponse> {
        @Nullable
        private String clusterName;
        private Map<String, Stats> nodes;

        public Builder() {
        }

        private Builder(NodesStatsResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, Stats> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Stats value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<Stats.Builder, ObjectBuilder<Stats>> fn) {
            return this.nodes(key, fn.apply(new Stats.Builder()).build());
        }

        @Override
        @Nonnull
        public NodesStatsResponse build() {
            this._checkSingleUse();
            return new NodesStatsResponse(this);
        }
    }
}

