/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.RetentionLease;
import org.opensearch.client.opensearch.indices.SoftDeletesRetention;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SoftDeletes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SoftDeletes> {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final SoftDeletesRetention retention;
    @Nullable
    private final RetentionLease retentionLease;
    public static final JsonpDeserializer<SoftDeletes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SoftDeletes::setupSoftDeletesDeserializer);

    private SoftDeletes(Builder builder) {
        this.enabled = builder.enabled;
        this.retention = builder.retention;
        this.retentionLease = builder.retentionLease;
    }

    public static SoftDeletes of(Function<Builder, ObjectBuilder<SoftDeletes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final SoftDeletesRetention retention() {
        return this.retention;
    }

    @Nullable
    public final RetentionLease retentionLease() {
        return this.retentionLease;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
        if (this.retentionLease != null) {
            generator.writeKey("retention_lease");
            this.retentionLease.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSoftDeletesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::retention, SoftDeletesRetention._DESERIALIZER, "retention");
        op.add(Builder::retentionLease, RetentionLease._DESERIALIZER, "retention_lease");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.retention);
        result = 31 * result + Objects.hashCode(this.retentionLease);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftDeletes other = (SoftDeletes)o;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.retention, other.retention) && Objects.equals(this.retentionLease, other.retentionLease);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SoftDeletes> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private SoftDeletesRetention retention;
        @Nullable
        private RetentionLease retentionLease;

        public Builder() {
        }

        private Builder(SoftDeletes o) {
            this.enabled = o.enabled;
            this.retention = o.retention;
            this.retentionLease = o.retentionLease;
        }

        private Builder(Builder o) {
            this.enabled = o.enabled;
            this.retention = o.retention;
            this.retentionLease = o.retentionLease;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public final Builder retention(@Nullable SoftDeletesRetention value) {
            this.retention = value;
            return this;
        }

        @Nonnull
        public final Builder retention(Function<SoftDeletesRetention.Builder, ObjectBuilder<SoftDeletesRetention>> fn) {
            return this.retention(fn.apply(new SoftDeletesRetention.Builder()).build());
        }

        @Nonnull
        public final Builder retentionLease(@Nullable RetentionLease value) {
            this.retentionLease = value;
            return this;
        }

        @Nonnull
        public final Builder retentionLease(Function<RetentionLease.Builder, ObjectBuilder<RetentionLease>> fn) {
            return this.retentionLease(fn.apply(new RetentionLease.Builder()).build());
        }

        @Override
        @Nonnull
        public SoftDeletes build() {
            this._checkSingleUse();
            return new SoftDeletes(this);
        }
    }
}

