/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.search.Queries;

@PublicApi(since="1.0.0")
public class ParsedQuery {
    private final Query query;
    private final Map<String, Query> namedFilters;

    public ParsedQuery(Query query, Map<String, Query> namedFilters) {
        this.query = query;
        this.namedFilters = namedFilters;
    }

    public ParsedQuery(Query query, ParsedQuery parsedQuery) {
        this.query = query;
        this.namedFilters = parsedQuery.namedFilters;
    }

    public ParsedQuery(Query query) {
        this.query = query;
        this.namedFilters = Collections.emptyMap();
    }

    public Query query() {
        return this.query;
    }

    public Map<String, Query> namedFilters() {
        return this.namedFilters;
    }

    public static ParsedQuery parsedMatchAllQuery() {
        return new ParsedQuery(Queries.newMatchAllQuery(), Collections.emptyMap());
    }
}

