/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.allocation.AllocationDecision;
import org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public abstract class AbstractAllocationDecision
implements ToXContentFragment,
Writeable {
    @Nullable
    protected final DiscoveryNode targetNode;
    @Nullable
    protected final List<NodeAllocationResult> nodeDecisions;

    protected AbstractAllocationDecision(@Nullable DiscoveryNode targetNode, @Nullable List<NodeAllocationResult> nodeDecisions) {
        this.targetNode = targetNode;
        this.nodeDecisions = nodeDecisions != null ? this.sortNodeDecisions(nodeDecisions) : null;
    }

    protected AbstractAllocationDecision(StreamInput in) throws IOException {
        this.targetNode = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
        this.nodeDecisions = in.readBoolean() ? Collections.unmodifiableList(in.readList(NodeAllocationResult::new)) : null;
    }

    public abstract boolean isDecisionTaken();

    @Nullable
    public DiscoveryNode getTargetNode() {
        this.checkDecisionState();
        return this.targetNode;
    }

    @Nullable
    public List<NodeAllocationResult> getNodeDecisions() {
        this.checkDecisionState();
        return this.nodeDecisions;
    }

    public abstract String getExplanation();

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((stream, node) -> node.writeToWithAttribute(stream), (Writeable)this.targetNode);
        if (this.nodeDecisions != null) {
            out.writeBoolean(true);
            out.writeList(this.nodeDecisions);
        } else {
            out.writeBoolean(false);
        }
    }

    protected void checkDecisionState() {
        if (!this.isDecisionTaken()) {
            throw new IllegalStateException("decision was not taken, individual object fields cannot be accessed");
        }
    }

    public static XContentBuilder discoveryNodeToXContent(DiscoveryNode node, boolean outerObjectWritten, XContentBuilder builder) throws IOException {
        builder.field(outerObjectWritten ? "id" : "node_id", node.getId());
        builder.field(outerObjectWritten ? "name" : "node_name", node.getName());
        builder.field("transport_address", node.getAddress().toString());
        if (!node.getAttributes().isEmpty()) {
            builder.startObject(outerObjectWritten ? "attributes" : "node_attributes");
            for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
        }
        return builder;
    }

    public List<NodeAllocationResult> sortNodeDecisions(List<NodeAllocationResult> nodeDecisions) {
        return Collections.unmodifiableList(nodeDecisions.stream().sorted().collect(Collectors.toList()));
    }

    public XContentBuilder nodeDecisionsToXContent(List<NodeAllocationResult> nodeDecisions, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (nodeDecisions != null && !nodeDecisions.isEmpty()) {
            builder.startArray("node_allocation_decisions");
            for (NodeAllocationResult explanation : nodeDecisions) {
                explanation.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }

    protected boolean atLeastOneNodeWithYesDecision() {
        if (this.nodeDecisions == null) {
            return false;
        }
        for (NodeAllocationResult result : this.nodeDecisions) {
            if (result.getNodeDecision() != AllocationDecision.YES) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractAllocationDecision)) {
            return false;
        }
        AbstractAllocationDecision that = (AbstractAllocationDecision)other;
        return Objects.equals(this.targetNode, that.targetNode) && Objects.equals(this.nodeDecisions, that.nodeDecisions);
    }

    public int hashCode() {
        return Objects.hash(this.targetNode, this.nodeDecisions);
    }
}

