/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.io.Serializable;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.collection.BitSet;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$;
import org.apache.spark.util.collection.OpenHashSet$Hasher$mcI$sp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Private
public class OpenHashSet$mcI$sp
extends OpenHashSet<Object> {
    public final OpenHashSet.Hasher<Object> hasher$mcI$sp;
    public int[] _data$mcI$sp;
    private final int initialCapacity;
    private final double loadFactor;
    private final ClassTag<Object> evidence$1;

    @Override
    public OpenHashSet.Hasher<Object> hasher$mcI$sp() {
        return this.hasher$mcI$sp;
    }

    @Override
    public OpenHashSet.Hasher<Object> hasher() {
        return this.hasher$mcI$sp();
    }

    @Override
    public int[] _data$mcI$sp() {
        return this._data$mcI$sp;
    }

    public int[] _data() {
        return this._data$mcI$sp();
    }

    @Override
    public void _data$mcI$sp_$eq(int[] x$1) {
        this._data$mcI$sp = x$1;
    }

    public void _data_$eq(int[] x$1) {
        this._data$mcI$sp_$eq(x$1);
    }

    @Override
    public boolean contains(int k) {
        return this.contains$mcI$sp(k);
    }

    @Override
    public boolean contains$mcI$sp(int k) {
        return this.getPos$mcI$sp(k) != OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public void add(int k) {
        this.add$mcI$sp(k);
    }

    @Override
    public void add$mcI$sp(int k) {
        this.addWithoutResize$mcI$sp(k);
        this.rehashIfNeeded$mcI$sp(k, OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$grow(), OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$move());
    }

    @Override
    public OpenHashSet<Object> union(OpenHashSet<Object> other) {
        return this.union$mcI$sp(other);
    }

    @Override
    public OpenHashSet<Object> union$mcI$sp(OpenHashSet<Object> other) {
        Iterator<Object> iterator = other.iterator();
        while (iterator.hasNext()) {
            this.add$mcI$sp(BoxesRunTime.unboxToInt((Object)iterator.next()));
        }
        return this;
    }

    @Override
    public boolean keyExistsAtPos(int k, int pos) {
        return this.keyExistsAtPos$mcI$sp(k, pos);
    }

    @Override
    public boolean keyExistsAtPos$mcI$sp(int k, int pos) {
        return ((Object)BoxesRunTime.boxToInteger((int)this._data()[pos])).equals(BoxesRunTime.boxToInteger((int)k));
    }

    @Override
    public int addWithoutResize(int k) {
        return this.addWithoutResize$mcI$sp(k);
    }

    @Override
    public int addWithoutResize$mcI$sp(int k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(k)) & this._mask();
        int delta = 1;
        while (true) {
            if (!this._bitset().get(pos)) {
                this._data()[pos] = k;
                this._bitset().set(pos);
                this._size_$eq(this._size() + 1);
                return pos | OpenHashSet$.MODULE$.NONEXISTENCE_MASK();
            }
            if (this.keyExistsAtPos$mcI$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this._mask();
            ++delta;
        }
    }

    @Override
    public void rehashIfNeeded(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehashIfNeeded$mcI$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehashIfNeeded$mcI$sp(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        block0: {
            if (this._size() <= this._growThreshold()) break block0;
            this.rehash$mcI$sp(k, allocateFunc, moveFunc);
        }
    }

    @Override
    public int getPos(int k) {
        return this.getPos$mcI$sp(k);
    }

    @Override
    public int getPos$mcI$sp(int k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(k)) & this._mask();
        int delta = 1;
        while (this._bitset().get(pos)) {
            if (this.keyExistsAtPos$mcI$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this._mask();
            ++delta;
        }
        return OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public int getValue(int pos) {
        return this.getValue$mcI$sp(pos);
    }

    @Override
    public int getValue$mcI$sp(int pos) {
        return this._data()[pos];
    }

    @Override
    public int getValueSafe(int pos) {
        return this.getValueSafe$mcI$sp(pos);
    }

    @Override
    public int getValueSafe$mcI$sp(int pos) {
        Predef$.MODULE$.assert(this._bitset().get(pos));
        return this._data()[pos];
    }

    @Override
    public void rehash(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehash$mcI$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehash$mcI$sp(int k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        int newCapacity = this._capacity() * 2;
        Predef$.MODULE$.require(newCapacity > 0 && newCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0 & Serializable)() -> new StringBuilder(33).append("Can't contain more than ").append((int)($this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)OpenHashSet$.MODULE$.MAX_CAPACITY())).append(" elements").toString());
        allocateFunc.apply$mcVI$sp(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        int[] newData = (int[])this.org$apache$spark$util$collection$OpenHashSet$$evidence$1.newArray(newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity(); ++oldPos) {
            if (!this._bitset().get(oldPos)) continue;
            int key = this._data()[oldPos];
            int newPos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcI$sp(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (!newBitset.get(newPos)) {
                    newData[newPos] = key;
                    newBitset.set(newPos);
                    moveFunc.apply$mcVII$sp(oldPos, newPos);
                    keepGoing = false;
                    continue;
                }
                int delta = i++;
                newPos = newPos + delta & newMask;
            }
        }
        this._bitset_$eq(newBitset);
        this._data_$eq(newData);
        this._capacity_$eq(newCapacity);
        this._mask_$eq(newMask);
        this._growThreshold_$eq((int)(this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)newCapacity));
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public OpenHashSet$mcI$sp(int initialCapacity, double loadFactor, ClassTag<Object> evidence$1) {
        OpenHashSet.Hasher hasher;
        ClassTag mt;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.evidence$1 = evidence$1;
        super(initialCapacity, loadFactor, evidence$1);
        Predef$.MODULE$.require(initialCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$1);
        Predef$.MODULE$.require(initialCapacity >= 0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$2);
        Predef$.MODULE$.require(loadFactor < 1.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$3);
        Predef$.MODULE$.require(loadFactor > 0.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$4);
        ClassTag classTag = mt = package$.MODULE$.classTag(this.org$apache$spark$util$collection$OpenHashSet$$evidence$1);
        ManifestFactory.LongManifest longManifest = ClassTag$.MODULE$.Long();
        if (!(classTag != null ? !classTag.equals(longManifest) : longManifest != null)) {
            hasher = new OpenHashSet.LongHasher();
        } else {
            ClassTag classTag2 = mt;
            ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
            if (!(classTag2 != null ? !classTag2.equals(intManifest) : intManifest != null)) {
                hasher = new OpenHashSet.IntHasher();
            } else {
                ClassTag classTag3 = mt;
                ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                if (!(classTag3 != null ? !classTag3.equals(doubleManifest) : doubleManifest != null)) {
                    hasher = new OpenHashSet.DoubleHasher();
                } else {
                    ClassTag classTag4 = mt;
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    hasher = !(classTag4 != null ? !classTag4.equals(floatManifest) : floatManifest != null) ? new OpenHashSet.FloatHasher() : new OpenHashSet$Hasher$mcI$sp();
                }
            }
        }
        this.hasher$mcI$sp = hasher;
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity = this.org$apache$spark$util$collection$OpenHashSet$$nextPowerOf2(initialCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask = this._capacity() - 1;
        this.org$apache$spark$util$collection$OpenHashSet$$_size = 0;
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold = (int)(loadFactor * (double)this._capacity());
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset = new BitSet(this._capacity());
        this._data_$eq(evidence$1.newArray(this._capacity()));
    }

    public OpenHashSet$mcI$sp(int initialCapacity, ClassTag<Object> evidence$2) {
        this(initialCapacity, 0.7, evidence$2);
    }

    public OpenHashSet$mcI$sp(ClassTag<Object> evidence$3) {
        this(64, evidence$3);
    }
}

