/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.repository;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.RemoteClusterAwareRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/replication/action/repository/RemoteClusterRepositoryRequest;", "T", "Lorg/opensearch/action/support/single/shard/SingleShardRequest;", "Lorg/opensearch/transport/RemoteClusterAwareRequest;", "restoreUUID", "", "node", "Lorg/opensearch/cluster/node/DiscoveryNode;", "leaderShardId", "Lorg/opensearch/core/index/shard/ShardId;", "followerCluster", "followerShardId", "<init>", "(Ljava/lang/String;Lorg/opensearch/cluster/node/DiscoveryNode;Lorg/opensearch/core/index/shard/ShardId;Ljava/lang/String;Lorg/opensearch/core/index/shard/ShardId;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getRestoreUUID", "()Ljava/lang/String;", "getNode", "()Lorg/opensearch/cluster/node/DiscoveryNode;", "getLeaderShardId", "()Lorg/opensearch/core/index/shard/ShardId;", "getFollowerCluster", "getFollowerShardId", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "getPreferredTargetNode", "opensearch-cross-cluster-replication"})
public abstract class RemoteClusterRepositoryRequest<T extends SingleShardRequest<T>>
extends SingleShardRequest<T>
implements RemoteClusterAwareRequest {
    @NotNull
    private final String restoreUUID;
    @NotNull
    private final DiscoveryNode node;
    @NotNull
    private final ShardId leaderShardId;
    @NotNull
    private final String followerCluster;
    @NotNull
    private final ShardId followerShardId;

    @NotNull
    public final String getRestoreUUID() {
        return this.restoreUUID;
    }

    @NotNull
    public final DiscoveryNode getNode() {
        return this.node;
    }

    @NotNull
    public final ShardId getLeaderShardId() {
        return this.leaderShardId;
    }

    @NotNull
    public final String getFollowerCluster() {
        return this.followerCluster;
    }

    @NotNull
    public final ShardId getFollowerShardId() {
        return this.followerShardId;
    }

    public RemoteClusterRepositoryRequest(@NotNull String restoreUUID, @NotNull DiscoveryNode node, @NotNull ShardId leaderShardId, @NotNull String followerCluster, @NotNull ShardId followerShardId) {
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerCluster, (String)"followerCluster");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        super(leaderShardId.getIndexName());
        this.restoreUUID = restoreUUID;
        this.node = node;
        this.leaderShardId = leaderShardId;
        this.followerCluster = followerCluster;
        this.followerShardId = followerShardId;
    }

    public RemoteClusterRepositoryRequest(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.restoreUUID = string;
        this.node = new DiscoveryNode(input);
        this.leaderShardId = new ShardId(input);
        String string2 = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        this.followerCluster = string2;
        this.followerShardId = new ShardId(input);
        this.index = this.leaderShardId.getIndexName();
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.restoreUUID);
        this.node.writeTo(out);
        this.leaderShardId.writeTo(out);
        out.writeString(this.followerCluster);
        this.followerShardId.writeTo(out);
    }

    @NotNull
    public DiscoveryNode getPreferredTargetNode() {
        return this.node;
    }
}

