/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.SearchMonitorRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

@ToolAnnotation(value="SearchMonitorsTool")
public class SearchMonitorsTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchMonitorsTool.class);
    public static final String TYPE = "SearchMonitorsTool";
    private static final String DEFAULT_DESCRIPTION = "This is a tool that searches alerting monitors. It takes 10 optional arguments named monitorId which defines the monitor ID to filter for (default is null), and monitorName which defines explicit name of the monitor (default is null), and monitorNamePattern which is a wildcard query to match monitor name (default is null), and enabled which defines whether the monitor is enabled (default is null, indicating both enabled and disabled), and hasTriggers which defines whether the monitor has triggers enabled (default is null, indicating both), and indices which defines the index being monitored (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0).  The tool returns 2 values: a list of alerting monitors (each containining monitor ID, monitor name, monitor type (indicating query-level, document-level, or bucket-level monitor types), enabled, enabled time in epoch milliseconds, last update time in epoch milliseconds), and the total number of alerting monitors.";
    private String name = "SearchMonitorsTool";
    private String description = "This is a tool that searches alerting monitors. It takes 10 optional arguments named monitorId which defines the monitor ID to filter for (default is null), and monitorName which defines explicit name of the monitor (default is null), and monitorNamePattern which is a wildcard query to match monitor name (default is null), and enabled which defines whether the monitor is enabled (default is null, indicating both enabled and disabled), and hasTriggers which defines whether the monitor has triggers enabled (default is null, indicating both), and indices which defines the index being monitored (default is null), and sortOrder which defines the order of the results (options are asc or desc, and default is asc), and sortString which defines how to sort the results (default is name.keyword), and size which defines the size of the request to be returned (default is 20), and startIndex which defines the paginated index to start from (default is 0).  The tool returns 2 values: a list of alerting monitors (each containining monitor ID, monitor name, monitor type (indicating query-level, document-level, or bucket-level monitor types), enabled, enabled time in epoch milliseconds, last update time in epoch milliseconds), and the total number of alerting monitors.";
    private String type;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser<?, ?> outputParser;
    private Map<String, Object> attributes;

    public SearchMonitorsTool(Client client) {
        this.client = client;
        this.outputParser = new Parser<Object, Object>(this){

            public Object parse(Object o) {
                List mlModelOutputs = (List)o;
                return ((ModelTensor)((ModelTensors)mlModelOutputs.get(0)).getMlModelTensors().get(0)).getDataAsMap().get("response");
            }
        };
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
        String monitorId = parameters.getOrDefault("monitorId", null);
        String monitorName = parameters.getOrDefault("monitorName", null);
        String monitorNamePattern = parameters.getOrDefault("monitorNamePattern", null);
        Boolean enabled = parameters.containsKey("enabled") ? Boolean.valueOf(Boolean.parseBoolean((String)parameters.get("enabled"))) : null;
        Boolean hasTriggers = parameters.containsKey("hasTriggers") ? Boolean.valueOf(Boolean.parseBoolean((String)parameters.get("hasTriggers"))) : null;
        String indices = parameters.getOrDefault("indices", null);
        String sortOrderStr = parameters.getOrDefault("sortOrder", "asc");
        SortOrder sortOrder = "asc".equalsIgnoreCase(sortOrderStr) ? SortOrder.ASC : SortOrder.DESC;
        String sortString = parameters.getOrDefault("sortString", "monitor.name.keyword");
        int size = parameters.containsKey("size") && StringUtils.isNumeric((CharSequence)((CharSequence)parameters.get("size"))) ? Integer.parseInt((String)parameters.get("size")) : 20;
        int startIndex = parameters.containsKey("startIndex") && StringUtils.isNumeric((CharSequence)((CharSequence)parameters.get("startIndex"))) ? Integer.parseInt((String)parameters.get("startIndex")) : 0;
        ArrayList<Object> mustList = new ArrayList<Object>();
        if (monitorId != null) {
            mustList.add(new TermQueryBuilder("_id", monitorId));
        }
        if (monitorName != null) {
            mustList.add(new TermQueryBuilder("monitor.name.keyword", monitorName));
        }
        if (monitorNamePattern != null) {
            mustList.add(new WildcardQueryBuilder("monitor.name.keyword", monitorNamePattern));
        }
        if (enabled != null) {
            mustList.add(new TermQueryBuilder("monitor.enabled", (Object)enabled));
        }
        if (hasTriggers != null) {
            NestedQueryBuilder nestedTriggerQuery = new NestedQueryBuilder("monitor.triggers", (QueryBuilder)new ExistsQueryBuilder("monitor.triggers"), ScoreMode.None);
            BoolQueryBuilder triggerQuery = new BoolQueryBuilder();
            if (hasTriggers.booleanValue()) {
                triggerQuery.must((QueryBuilder)nestedTriggerQuery);
            } else {
                triggerQuery.mustNot((QueryBuilder)nestedTriggerQuery);
            }
            mustList.add(triggerQuery);
        }
        if (indices != null) {
            mustList.add(new NestedQueryBuilder("monitor.inputs", (QueryBuilder)new WildcardQueryBuilder("monitor.inputs.search.indices", indices), ScoreMode.None));
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must().addAll(mustList);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).size(size).from(startIndex).sort(sortString, sortOrder);
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-alerting-config"});
        SearchMonitorRequest searchMonitorRequest = new SearchMonitorRequest(searchRequest);
        ActionListener searchMonitorListener = ActionListener.wrap(response -> {
            List<SearchHit> hits = Arrays.asList(response.getHits().getHits());
            Map<String, SearchHit> hitsAsMap = hits.stream().collect(Collectors.toMap(SearchHit::getId, hit -> hit));
            this.processHits(hitsAsMap, listener);
        }, e -> {
            if (e.getMessage().contains("Configured indices are not found")) {
                this.processHits(Collections.emptyMap(), listener);
            } else {
                log.error("Failed to search monitors.", (Throwable)e);
                listener.onFailure(e);
            }
        });
        AlertingPluginInterface.INSTANCE.searchMonitors((NodeClient)this.client, searchMonitorRequest, searchMonitorListener);
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    public String getType() {
        return TYPE;
    }

    private <T> void processHits(Map<String, SearchHit> hitsAsMap, ActionListener<T> listener) {
        StringBuilder sb = new StringBuilder();
        sb.append("Monitors=[");
        for (SearchHit hit : hitsAsMap.values()) {
            Map monitorAsMap = (Map)hit.getSourceAsMap().get("monitor");
            sb.append("{");
            sb.append("id=").append(hit.getId()).append(",");
            sb.append("name=").append(monitorAsMap.get("name")).append(",");
            sb.append("type=").append(monitorAsMap.get("monitor_type")).append(",");
            sb.append("enabled=").append(monitorAsMap.get("enabled")).append(",");
            sb.append("enabledTime=").append(monitorAsMap.get("enabled_time")).append(",");
            sb.append("lastUpdateTime=").append(monitorAsMap.get("last_update_time"));
            sb.append("}");
        }
        sb.append("]");
        sb.append("TotalMonitors=").append(hitsAsMap.size());
        listener.onResponse((Object)sb.toString());
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser<?, ?> outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static class Factory
    implements Tool.Factory<SearchMonitorsTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchMonitorsTool> clazz = SearchMonitorsTool.class;
            synchronized (SearchMonitorsTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public SearchMonitorsTool create(Map<String, Object> map) {
            return new SearchMonitorsTool(this.client);
        }

        public String getDefaultDescription() {
            return SearchMonitorsTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchMonitorsTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

