/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.flowframework.exception.ApiSpecParseException;
import org.opensearch.rest.RestRequest;

public class ApiSpecFetcher {
    private static final Logger logger = LogManager.getLogger(ApiSpecFetcher.class);
    private static final ParseOptions OPTIMIZED_PARSE_OPTIONS = new ParseOptions();
    private static final OpenAPIV3Parser OPENAPI_PARSER = new OpenAPIV3Parser();
    private static final ConcurrentMap<String, OpenAPI> SPEC_CACHE = new ConcurrentHashMap<String, OpenAPI>();
    private static final ConcurrentMap<String, List<String>> REQUIRED_FIELDS_CACHE = new ConcurrentHashMap<String, List<String>>();

    private ApiSpecFetcher() {
    }

    public static OpenAPI fetchApiSpec(String apiSpecUri) {
        return ApiSpecFetcher.fetchApiSpec(apiSpecUri, true);
    }

    public static OpenAPI fetchApiSpec(String apiSpecUri, boolean useOptimizedParsing) {
        logger.info("Parsing API spec from URI: {}", (Object)apiSpecUri);
        OpenAPI cachedSpec = (OpenAPI)SPEC_CACHE.get(apiSpecUri);
        if (cachedSpec != null) {
            logger.debug("Using cached API spec for URI: {}", (Object)apiSpecUri);
            return cachedSpec;
        }
        SwaggerParseResult result = OPENAPI_PARSER.readLocation(apiSpecUri, null, OPTIMIZED_PARSE_OPTIONS);
        OpenAPI openApi = result.getOpenAPI();
        if (openApi == null) {
            throw new ApiSpecParseException("Unable to parse spec from URI: " + apiSpecUri, result.getMessages());
        }
        SPEC_CACHE.put(apiSpecUri, openApi);
        return openApi;
    }

    public static boolean compareRequiredFields(List<String> requiredEnumParams, String apiSpecUri, String path, RestRequest.Method method) throws IllegalArgumentException, ApiSpecParseException {
        String cacheKey = apiSpecUri + ":" + path + ":" + method.name();
        List cachedRequiredFields = (List)REQUIRED_FIELDS_CACHE.get(cacheKey);
        if (cachedRequiredFields != null) {
            logger.debug("Using cached required fields for: {}", (Object)cacheKey);
            return cachedRequiredFields.stream().allMatch(requiredEnumParams::contains);
        }
        OpenAPI openAPI = ApiSpecFetcher.fetchApiSpec(apiSpecUri, true);
        PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)path);
        if (pathItem == null) {
            throw new IllegalArgumentException("Path not found in API spec: " + path);
        }
        List requiredApiParams = null;
        try {
            Schema schema;
            Content content = ApiSpecFetcher.getContent(method, pathItem);
            if (content == null) {
                return ApiSpecFetcher.handleUnresolvedRequestBody(openAPI, pathItem, method, requiredEnumParams, cacheKey);
            }
            MediaType mediaType = (MediaType)content.get((Object)XContentType.JSON.mediaTypeWithoutParameters());
            if (mediaType != null && (schema = mediaType.getSchema()) != null) {
                requiredApiParams = schema.getRequired();
            }
        }
        catch (ApiSpecParseException e) {
            if (e.getMessage().contains("No requestBody defined for this operation")) {
                throw e;
            }
            return ApiSpecFetcher.handleUnresolvedRequestBody(openAPI, pathItem, method, requiredEnumParams, cacheKey);
        }
        if (requiredApiParams != null) {
            REQUIRED_FIELDS_CACHE.put(cacheKey, requiredApiParams);
            logger.debug("Required enum params: {}", requiredEnumParams);
            logger.debug("Required API params: {}", (Object)requiredApiParams);
            return requiredApiParams.stream().allMatch(requiredEnumParams::contains);
        }
        return false;
    }

    private static boolean handleUnresolvedRequestBody(OpenAPI openAPI, PathItem pathItem, RestRequest.Method method, List<String> requiredEnumParams, String cacheKey) {
        try {
            String componentName;
            List<String> requiredFields;
            Operation operation = ApiSpecFetcher.getOperation(method, pathItem);
            if (operation == null) {
                return false;
            }
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody == null) {
                return false;
            }
            String ref = requestBody.get$ref();
            if (ref != null && ref.startsWith("#/components/requestBodies/") && (requiredFields = ApiSpecFetcher.extractRequiredFieldsFromComponent(openAPI, componentName = ref.substring("#/components/requestBodies/".length()))) != null && !requiredFields.isEmpty()) {
                REQUIRED_FIELDS_CACHE.put(cacheKey, requiredFields);
                logger.debug("Required enum params: {}", requiredEnumParams);
                logger.debug("Required API params from component: {}", requiredFields);
                return requiredFields.stream().allMatch(requiredEnumParams::contains);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to handle unresolved requestBody: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static Operation getOperation(RestRequest.Method method, PathItem pathItem) {
        switch (method) {
            case POST: {
                return pathItem.getPost();
            }
            case GET: {
                return pathItem.getGet();
            }
            case PUT: {
                return pathItem.getPut();
            }
            case DELETE: {
                return pathItem.getDelete();
            }
        }
        return null;
    }

    private static List<String> extractRequiredFieldsFromComponent(OpenAPI openAPI, String componentName) {
        if (openAPI.getComponents() == null || openAPI.getComponents().getRequestBodies() == null) {
            return null;
        }
        RequestBody requestBodyComponent = (RequestBody)openAPI.getComponents().getRequestBodies().get(componentName);
        if (requestBodyComponent == null) {
            return null;
        }
        Content content = requestBodyComponent.getContent();
        if (content == null) {
            return null;
        }
        MediaType mediaType = (MediaType)content.get((Object)XContentType.JSON.mediaTypeWithoutParameters());
        if (mediaType == null) {
            return null;
        }
        Schema schema = mediaType.getSchema();
        if (schema == null) {
            return null;
        }
        return schema.getRequired();
    }

    private static Content getContent(RestRequest.Method method, PathItem pathItem) throws IllegalArgumentException, ApiSpecParseException {
        Operation operation = switch (method) {
            case RestRequest.Method.POST -> pathItem.getPost();
            case RestRequest.Method.GET -> pathItem.getGet();
            case RestRequest.Method.PUT -> pathItem.getPut();
            case RestRequest.Method.DELETE -> pathItem.getDelete();
            default -> throw new IllegalArgumentException("Unsupported HTTP method: " + String.valueOf(method));
        };
        if (operation == null) {
            throw new IllegalArgumentException("No operation found for the specified method: " + String.valueOf(method));
        }
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            throw new ApiSpecParseException("No requestBody defined for this operation.");
        }
        return requestBody.getContent();
    }

    static {
        OPTIMIZED_PARSE_OPTIONS.setResolve(false);
        OPTIMIZED_PARSE_OPTIONS.setResolveFully(false);
        OPTIMIZED_PARSE_OPTIONS.setResolveCombinators(false);
        OPTIMIZED_PARSE_OPTIONS.setFlatten(false);
        OPTIMIZED_PARSE_OPTIONS.setValidateExternalRefs(false);
    }
}

