/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.transforms.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ResolveAttributesInput {
    private final String TableName;
    private final Map<String, AttributeValue> Item;
    private final int Version;

    protected ResolveAttributesInput(BuilderImpl builder) {
        this.TableName = builder.TableName();
        this.Item = builder.Item();
        this.Version = builder.Version();
    }

    public String TableName() {
        return this.TableName;
    }

    public Map<String, AttributeValue> Item() {
        return this.Item;
    }

    public int Version() {
        return this.Version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String TableName;
        protected Map<String, AttributeValue> Item;
        protected int Version;
        private boolean _VersionSet = false;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ResolveAttributesInput model) {
            this.TableName = model.TableName();
            this.Item = model.Item();
            this.Version = model.Version();
            this._VersionSet = true;
        }

        @Override
        public Builder TableName(String TableName2) {
            this.TableName = TableName2;
            return this;
        }

        @Override
        public String TableName() {
            return this.TableName;
        }

        @Override
        public Builder Item(Map<String, AttributeValue> Item) {
            this.Item = Item;
            return this;
        }

        @Override
        public Map<String, AttributeValue> Item() {
            return this.Item;
        }

        @Override
        public Builder Version(int Version2) {
            this.Version = Version2;
            this._VersionSet = true;
            return this;
        }

        @Override
        public int Version() {
            return this.Version;
        }

        @Override
        public ResolveAttributesInput build() {
            if (Objects.isNull(this.TableName())) {
                throw new IllegalArgumentException("Missing value for required field `TableName`");
            }
            if (Objects.nonNull(this.TableName()) && this.TableName().length() < 3) {
                throw new IllegalArgumentException("The size of `TableName` must be greater than or equal to 3");
            }
            if (Objects.nonNull(this.TableName()) && this.TableName().length() > 255) {
                throw new IllegalArgumentException("The size of `TableName` must be less than or equal to 255");
            }
            if (Objects.isNull(this.Item())) {
                throw new IllegalArgumentException("Missing value for required field `Item`");
            }
            if (this._VersionSet && this.Version() < 1) {
                throw new IllegalArgumentException("`Version` must be greater than or equal to 1");
            }
            return new ResolveAttributesInput(this);
        }
    }

    public static interface Builder {
        public Builder TableName(String var1);

        public String TableName();

        public Builder Item(Map<String, AttributeValue> var1);

        public Map<String, AttributeValue> Item();

        public Builder Version(int var1);

        public int Version();

        public ResolveAttributesInput build();
    }
}

