/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.security.Provider;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationProperties;
import org.opensearch.tools.cli.fips.truststore.ConfigurationService;
import org.opensearch.tools.cli.fips.truststore.ConfigureSystemTrustStore;
import org.opensearch.tools.cli.fips.truststore.CreateFipsTrustStore;
import org.opensearch.tools.cli.fips.truststore.ProviderSelectionService;
import org.opensearch.tools.cli.fips.truststore.UserInteractionService;
import picocli.CommandLine;

public class TrustStoreService {
    private final UserInteractionService userInteraction;

    public TrustStoreService(UserInteractionService userInteraction) {
        this.userInteraction = userInteraction;
    }

    public Integer generateTrustStore(CommandLine.Model.CommandSpec spec, CommonOptions options, Path confPath) {
        if (!this.userInteraction.confirmAction(spec, options, "Generate new BCFKS trust store from system defaults?")) {
            spec.commandLine().getOut().println("Operation cancelled.");
            return 0;
        }
        String password = Optional.ofNullable(options.password).orElseGet(() -> {
            if (options.nonInteractive) {
                spec.commandLine().getOut().println("Generated secure password for trust store (non-interactive mode)");
                return this.userInteraction.generateSecurePassword();
            }
            return this.userInteraction.promptForPasswordWithConfirmation(spec, options, "Enter trust store password");
        });
        if (password.isBlank()) {
            spec.commandLine().getOut().println(spec.commandLine().getColorScheme().ansi().string("@|yellow WARNING: Using empty password|@"));
        }
        spec.commandLine().getOut().println("Generating BCFKS trust store...");
        ConfigurationProperties properties = Function.identity().andThen(path -> CreateFipsTrustStore.loadJvmDefaultTrustStore(spec, path)).andThen(trustStore -> CreateFipsTrustStore.convertToBCFKS(spec, trustStore, options, password, confPath)).andThen(bcfksPath -> CreateFipsTrustStore.configureBCFKSTrustStore(bcfksPath, password)).apply(Path.of(System.getProperty("java.home"), new String[0]));
        new ConfigurationService().writeSecurityConfigToJvmOptionsFile(properties, confPath);
        TrustStoreService.finishInstallation(spec, properties);
        return 0;
    }

    public Integer useSystemTrustStore(CommandLine.Model.CommandSpec spec, CommonOptions options, String preselectedPKCS11Provider, Path confPath) {
        if (!this.userInteraction.confirmAction(spec, options, "Use system PKCS11 trust store?")) {
            spec.commandLine().getOut().println("Operation cancelled.");
            return 0;
        }
        spec.commandLine().getOut().println("Configuring system PKCS11 trust store...");
        List<Provider.Service> serviceProviderList = ConfigureSystemTrustStore.findPKCS11ProviderService();
        if (serviceProviderList.isEmpty()) {
            throw new IllegalStateException("No PKCS11 provider found. Please check 'java.security' configuration file for installed providers.");
        }
        Provider.Service selectedService = new ProviderSelectionService(this.userInteraction).selectProvider(spec, options, serviceProviderList, preselectedPKCS11Provider);
        if (selectedService == null) {
            spec.commandLine().getOut().println("Operation cancelled.");
            return 0;
        }
        spec.commandLine().getOut().println("Using PKCS11 provider: " + selectedService.getProvider().getName());
        ConfigurationProperties properties = ConfigureSystemTrustStore.configurePKCS11TrustStore(selectedService);
        new ConfigurationService().writeSecurityConfigToJvmOptionsFile(properties, confPath);
        TrustStoreService.finishInstallation(spec, properties);
        return 0;
    }

    public Integer executeInteractiveSelection(CommandLine.Model.CommandSpec spec, CommonOptions options, Path confPath) {
        if (options.nonInteractive) {
            spec.commandLine().getOut().println("Non-interactive mode: Using generated trust store (default)");
            return this.generateTrustStore(spec, options, confPath);
        }
        PrintWriter out = spec.commandLine().getOut();
        out.println("OpenSearch FIPS Demo Configuration Installer");
        out.println("Please select trust store configuration:");
        out.println("  1. Generate new BCFKS trust store from system defaults");
        out.println("  2. Use existing system PKCS11 trust store");
        int choice = this.userInteraction.promptForChoice(spec, 2, 1);
        return choice == 1 ? this.generateTrustStore(spec, options, confPath) : this.useSystemTrustStore(spec, options, null, confPath);
    }

    private static void finishInstallation(CommandLine.Model.CommandSpec spec, ConfigurationProperties properties) {
        spec.commandLine().getOut().println();
        spec.commandLine().getOut().println("### Success!");
        spec.commandLine().getOut().println("### Execute this script on all your nodes and then start all nodes");
        spec.commandLine().getOut().println("### Trust Store Configuration:");
        spec.commandLine().getOut().print(properties.toString());
        spec.commandLine().getOut().println();
    }
}

