/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.PrivilegedAction;

class Native {
    private static boolean loaded = false;
    private static String extension = "";

    Native() {
    }

    static boolean isLoaded() {
        if (loaded) {
            return true;
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.loadLibrary("qat-java");
            } else {
                PrivilegedAction<Void> pa = () -> {
                    System.loadLibrary("qat-java");
                    return null;
                };
                AccessController.doPrivileged(pa);
            }
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        return loaded;
    }

    static String getLibName() {
        return "/com/intel/qat/" + Native.getOSName() + "/" + Native.getOSArch() + "/libqat-java" + extension;
    }

    static String getOSName() {
        String os = System.getProperty("os.name");
        if (!os.contains("Linux")) {
            throw new UnsupportedOperationException("Operating System is not supported");
        }
        String ret = "linux";
        extension = ".so";
        return ret;
    }

    static String getOSArch() {
        return System.getProperty("os.arch");
    }

    static synchronized void loadLibrary() {
        if (Native.isLoaded()) {
            return;
        }
        String libName = Native.getLibName();
        File tempNativeLib = null;
        File tempNativeLibLock = null;
        try (InputStream in = Native.class.getResourceAsStream(libName);){
            if (in == null) {
                throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + libName + ". Please try building from source.");
            }
            tempNativeLibLock = File.createTempFile("libqat-java", extension + ".lck");
            tempNativeLib = new File(tempNativeLibLock.getAbsolutePath().replaceFirst(".lck$", ""));
            try (FileOutputStream out = new FileOutputStream(tempNativeLib);){
                int bytesRead;
                byte[] buf = new byte[4096];
                while ((bytesRead = in.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
            }
            boolean isSymbolicLink = Files.isSymbolicLink(tempNativeLib.toPath());
            if (isSymbolicLink) {
                throw new IOException("Failed to load native qat-java library." + tempNativeLib.toPath() + " is a symbolic link.");
            }
            File finalTempNativeLib = tempNativeLib;
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.load(finalTempNativeLib.getAbsolutePath());
            } else {
                PrivilegedAction<Void> pa = () -> {
                    System.load(finalTempNativeLib.getAbsolutePath());
                    return null;
                };
                AccessController.doPrivileged(pa);
            }
            loaded = true;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("Failed to load native qat-java library.\n" + e.getMessage());
        }
        finally {
            if (tempNativeLib != null) {
                tempNativeLib.deleteOnExit();
            }
            if (tempNativeLibLock != null) {
                tempNativeLibLock.deleteOnExit();
            }
        }
    }
}

