/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ltr.transport.LTRStatsNodeResponse;

public class LTRStatsNodesResponse
extends BaseNodesResponse<LTRStatsNodeResponse>
implements ToXContent {
    private static final String NODES_KEY = "nodes";
    private final Map<String, Object> clusterStats;

    public LTRStatsNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(LTRStatsNodeResponse::readStats), in.readList(FailedNodeException::new));
        this.clusterStats = in.readMap();
    }

    public LTRStatsNodesResponse(ClusterName clusterName, List<LTRStatsNodeResponse> nodeResponses, List<FailedNodeException> failures, Map<String, Object> clusterStats) {
        super(clusterName, nodeResponses, failures);
        this.clusterStats = clusterStats;
    }

    Map<String, Object> getClusterStats() {
        return this.clusterStats;
    }

    protected List<LTRStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(LTRStatsNodeResponse::readStats);
    }

    protected void writeNodesTo(StreamOutput out, List<LTRStatsNodeResponse> nodeResponses) throws IOException {
        out.writeList(nodeResponses);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.clusterStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, Object> clusterStat : this.clusterStats.entrySet()) {
            builder.field(clusterStat.getKey(), clusterStat.getValue());
        }
        builder.startObject(NODES_KEY);
        for (LTRStatsNodeResponse ltrStats : this.getNodes()) {
            builder.startObject(ltrStats.getNode().getId());
            ltrStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

