/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.searchConfiguration;

import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteSearchConfigurationTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final SearchConfigurationDao searchConfigurationDao;

    @Inject
    public DeleteSearchConfigurationTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchConfigurationDao searchConfigurationDao) {
        super("cluster:admin/opensearch/search_relevance/search_configuration/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.searchConfigurationDao = searchConfigurationDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, ActionListener<DeleteResponse> listener) {
        try {
            String searchConfigurationId = request.getId();
            if (searchConfigurationId == null || searchConfigurationId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("searchConfigurationId cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.searchConfigurationDao.deleteSearchConfiguration(searchConfigurationId, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

