/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.experiment;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.opensearch.searchrelevance.experiment.ExperimentOptions;
import org.opensearch.searchrelevance.experiment.ExperimentVariantHybridSearchDTO;

public class ExperimentOptionsForHybridSearch
implements ExperimentOptions {
    private Set<String> normalizationTechniques;
    private Set<String> combinationTechniques;
    private WeightsRange weightsRange;
    public static final String EXPERIMENT_OPTION_NORMALIZATION_TECHNIQUE = "normalization";
    public static final String EXPERIMENT_OPTION_COMBINATION_TECHNIQUE = "combination";
    public static final String EXPERIMENT_OPTION_WEIGHTS_FOR_COMBINATION = "weights";

    public List<ExperimentVariantHybridSearchDTO> getParameterCombinations(boolean includeWeights) {
        ArrayList<ExperimentVariantHybridSearchDTO> allPossibleParameterCombinations = new ArrayList<ExperimentVariantHybridSearchDTO>();
        for (String normalizationTechnique : this.normalizationTechniques) {
            for (String combinationTechnique : this.combinationTechniques) {
                if (includeWeights) {
                    float min = this.weightsRange.getRangeMin();
                    float max = this.weightsRange.getRangeMax();
                    float increment = this.weightsRange.getIncrement();
                    int steps = Math.round((max - min) / increment) + 1;
                    for (int i = 0; i < steps; ++i) {
                        float queryWeightForCombination = i == steps - 1 ? max : min + (float)i * increment;
                        allPossibleParameterCombinations.add(ExperimentVariantHybridSearchDTO.builder().normalizationTechnique(normalizationTechnique).combinationTechnique(combinationTechnique).queryWeightsForCombination(new float[]{queryWeightForCombination, 1.0f - queryWeightForCombination}).build());
                    }
                    continue;
                }
                allPossibleParameterCombinations.add(ExperimentVariantHybridSearchDTO.builder().normalizationTechnique(normalizationTechnique).combinationTechnique(combinationTechnique).queryWeightsForCombination(new float[]{0.5f, 0.5f}).build());
            }
        }
        return allPossibleParameterCombinations;
    }

    @Generated
    ExperimentOptionsForHybridSearch(Set<String> normalizationTechniques, Set<String> combinationTechniques, WeightsRange weightsRange) {
        this.normalizationTechniques = normalizationTechniques;
        this.combinationTechniques = combinationTechniques;
        this.weightsRange = weightsRange;
    }

    @Generated
    public static ExperimentOptionsForHybridSearchBuilder builder() {
        return new ExperimentOptionsForHybridSearchBuilder();
    }

    @Generated
    public Set<String> getNormalizationTechniques() {
        return this.normalizationTechniques;
    }

    @Generated
    public Set<String> getCombinationTechniques() {
        return this.combinationTechniques;
    }

    @Generated
    public WeightsRange getWeightsRange() {
        return this.weightsRange;
    }

    @Generated
    public void setNormalizationTechniques(Set<String> normalizationTechniques) {
        this.normalizationTechniques = normalizationTechniques;
    }

    @Generated
    public void setCombinationTechniques(Set<String> combinationTechniques) {
        this.combinationTechniques = combinationTechniques;
    }

    @Generated
    public void setWeightsRange(WeightsRange weightsRange) {
        this.weightsRange = weightsRange;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperimentOptionsForHybridSearch)) {
            return false;
        }
        ExperimentOptionsForHybridSearch other = (ExperimentOptionsForHybridSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$normalizationTechniques = this.getNormalizationTechniques();
        Set<String> other$normalizationTechniques = other.getNormalizationTechniques();
        if (this$normalizationTechniques == null ? other$normalizationTechniques != null : !((Object)this$normalizationTechniques).equals(other$normalizationTechniques)) {
            return false;
        }
        Set<String> this$combinationTechniques = this.getCombinationTechniques();
        Set<String> other$combinationTechniques = other.getCombinationTechniques();
        if (this$combinationTechniques == null ? other$combinationTechniques != null : !((Object)this$combinationTechniques).equals(other$combinationTechniques)) {
            return false;
        }
        WeightsRange this$weightsRange = this.getWeightsRange();
        WeightsRange other$weightsRange = other.getWeightsRange();
        return !(this$weightsRange == null ? other$weightsRange != null : !((Object)this$weightsRange).equals(other$weightsRange));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExperimentOptionsForHybridSearch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $normalizationTechniques = this.getNormalizationTechniques();
        result = result * 59 + ($normalizationTechniques == null ? 43 : ((Object)$normalizationTechniques).hashCode());
        Set<String> $combinationTechniques = this.getCombinationTechniques();
        result = result * 59 + ($combinationTechniques == null ? 43 : ((Object)$combinationTechniques).hashCode());
        WeightsRange $weightsRange = this.getWeightsRange();
        result = result * 59 + ($weightsRange == null ? 43 : ((Object)$weightsRange).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExperimentOptionsForHybridSearch(normalizationTechniques=" + String.valueOf(this.getNormalizationTechniques()) + ", combinationTechniques=" + String.valueOf(this.getCombinationTechniques()) + ", weightsRange=" + String.valueOf(this.getWeightsRange()) + ")";
    }

    static class WeightsRange {
        private float rangeMin;
        private float rangeMax;
        private float increment;

        @Generated
        WeightsRange(float rangeMin, float rangeMax, float increment) {
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
            this.increment = increment;
        }

        @Generated
        public static WeightsRangeBuilder builder() {
            return new WeightsRangeBuilder();
        }

        @Generated
        public float getRangeMin() {
            return this.rangeMin;
        }

        @Generated
        public float getRangeMax() {
            return this.rangeMax;
        }

        @Generated
        public float getIncrement() {
            return this.increment;
        }

        @Generated
        public void setRangeMin(float rangeMin) {
            this.rangeMin = rangeMin;
        }

        @Generated
        public void setRangeMax(float rangeMax) {
            this.rangeMax = rangeMax;
        }

        @Generated
        public void setIncrement(float increment) {
            this.increment = increment;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeightsRange)) {
                return false;
            }
            WeightsRange other = (WeightsRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getRangeMin(), other.getRangeMin()) != 0) {
                return false;
            }
            if (Float.compare(this.getRangeMax(), other.getRangeMax()) != 0) {
                return false;
            }
            return Float.compare(this.getIncrement(), other.getIncrement()) == 0;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WeightsRange;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getRangeMin());
            result = result * 59 + Float.floatToIntBits(this.getRangeMax());
            result = result * 59 + Float.floatToIntBits(this.getIncrement());
            return result;
        }

        @Generated
        public String toString() {
            return "ExperimentOptionsForHybridSearch.WeightsRange(rangeMin=" + this.getRangeMin() + ", rangeMax=" + this.getRangeMax() + ", increment=" + this.getIncrement() + ")";
        }

        @Generated
        public static class WeightsRangeBuilder {
            @Generated
            private float rangeMin;
            @Generated
            private float rangeMax;
            @Generated
            private float increment;

            @Generated
            WeightsRangeBuilder() {
            }

            @Generated
            public WeightsRangeBuilder rangeMin(float rangeMin) {
                this.rangeMin = rangeMin;
                return this;
            }

            @Generated
            public WeightsRangeBuilder rangeMax(float rangeMax) {
                this.rangeMax = rangeMax;
                return this;
            }

            @Generated
            public WeightsRangeBuilder increment(float increment) {
                this.increment = increment;
                return this;
            }

            @Generated
            public WeightsRange build() {
                return new WeightsRange(this.rangeMin, this.rangeMax, this.increment);
            }

            @Generated
            public String toString() {
                return "ExperimentOptionsForHybridSearch.WeightsRange.WeightsRangeBuilder(rangeMin=" + this.rangeMin + ", rangeMax=" + this.rangeMax + ", increment=" + this.increment + ")";
            }
        }
    }

    @Generated
    public static class ExperimentOptionsForHybridSearchBuilder {
        @Generated
        private Set<String> normalizationTechniques;
        @Generated
        private Set<String> combinationTechniques;
        @Generated
        private WeightsRange weightsRange;

        @Generated
        ExperimentOptionsForHybridSearchBuilder() {
        }

        @Generated
        public ExperimentOptionsForHybridSearchBuilder normalizationTechniques(Set<String> normalizationTechniques) {
            this.normalizationTechniques = normalizationTechniques;
            return this;
        }

        @Generated
        public ExperimentOptionsForHybridSearchBuilder combinationTechniques(Set<String> combinationTechniques) {
            this.combinationTechniques = combinationTechniques;
            return this;
        }

        @Generated
        public ExperimentOptionsForHybridSearchBuilder weightsRange(WeightsRange weightsRange) {
            this.weightsRange = weightsRange;
            return this;
        }

        @Generated
        public ExperimentOptionsForHybridSearch build() {
            return new ExperimentOptionsForHybridSearch(this.normalizationTechniques, this.combinationTechniques, this.weightsRange);
        }

        @Generated
        public String toString() {
            return "ExperimentOptionsForHybridSearch.ExperimentOptionsForHybridSearchBuilder(normalizationTechniques=" + String.valueOf(this.normalizationTechniques) + ", combinationTechniques=" + String.valueOf(this.combinationTechniques) + ", weightsRange=" + String.valueOf(this.weightsRange) + ")";
        }
    }
}

