/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.transport.client.Client;

public class CorrelationIndices {
    private static final Logger log = LogManager.getLogger(CorrelationIndices.class);
    public static final String CORRELATION_METADATA_INDEX = ".opensearch-sap-correlation-metadata";
    public static final String CORRELATION_HISTORY_INDEX_PATTERN = "<.opensearch-sap-correlation-history-{now/d}-1>";
    public static final String CORRELATION_HISTORY_INDEX_PATTERN_REGEXP = ".opensearch-sap-correlation-history*";
    public static final String CORRELATION_HISTORY_WRITE_INDEX = ".opensearch-sap-correlation-history-write";
    public static final String CORRELATION_ALERT_INDEX = ".opensearch-sap-correlation-alerts";
    public static final long FIXED_HISTORICAL_INTERVAL = 1728000000L;
    private final Client client;
    private final ClusterService clusterService;

    public CorrelationIndices(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public static String correlationMappings() throws IOException {
        return new String(Objects.requireNonNull(CorrelationIndices.class.getClassLoader().getResourceAsStream("mappings/correlation.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initCorrelationIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.correlationIndexExists()) {
            Settings indexSettings = Settings.builder().put("index.hidden", true).put("index.correlation", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20").build();
            CreateIndexRequest indexRequest = new CreateIndexRequest(CORRELATION_HISTORY_INDEX_PATTERN).mapping(CorrelationIndices.correlationMappings()).settings(indexSettings);
            indexRequest.alias(new Alias(CORRELATION_HISTORY_WRITE_INDEX));
            this.client.admin().indices().create(indexRequest, actionListener);
        } else {
            actionListener.onResponse((Object)new CreateIndexResponse(true, true, CORRELATION_HISTORY_INDEX_PATTERN));
        }
    }

    public void initCorrelationMetadataIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.correlationMetadataIndexExists()) {
            Settings indexSettings = Settings.builder().put("index.hidden", true).put("index.correlation", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20").build();
            CreateIndexRequest indexRequest = new CreateIndexRequest(CORRELATION_METADATA_INDEX).mapping(CorrelationIndices.correlationMappings()).settings(indexSettings);
            this.client.admin().indices().create(indexRequest, actionListener);
        } else {
            actionListener.onResponse((Object)new CreateIndexResponse(true, true, CORRELATION_METADATA_INDEX));
        }
    }

    public boolean correlationIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.metadata().hasAlias(CORRELATION_HISTORY_WRITE_INDEX);
    }

    public boolean correlationMetadataIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.metadata().hasIndex(CORRELATION_METADATA_INDEX);
    }

    public boolean correlationAlertIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.metadata().hasIndex(CORRELATION_ALERT_INDEX);
    }

    public void setupCorrelationIndex(TimeValue indexTimeout, Long setupTimestamp, ActionListener<BulkResponse> listener) throws IOException {
        try {
            long currentTimestamp = System.currentTimeMillis();
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.field("root", true);
            builder.field("counter", 0L);
            builder.field("finding1", "");
            builder.field("finding2", "");
            builder.field("logType", "");
            builder.field("timestamp", currentTimestamp);
            builder.field("scoreTimestamp", 0L);
            builder.endObject();
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(CORRELATION_METADATA_INDEX).source(builder).timeout(indexTimeout);
            XContentBuilder scoreBuilder = XContentFactory.jsonBuilder().startObject();
            scoreBuilder.field("scoreTimestamp", setupTimestamp);
            scoreBuilder.field("root", false);
            scoreBuilder.endObject();
            IndexRequest scoreIndexRequest = (IndexRequest)new IndexRequest(CORRELATION_METADATA_INDEX).source(scoreBuilder).timeout(indexTimeout);
            BulkRequest bulkRequest = new BulkRequest();
            bulkRequest.add(indexRequest);
            bulkRequest.add(scoreIndexRequest);
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, listener);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw ex;
        }
    }

    public static String correlationAlertIndexMappings() throws IOException {
        return new String(Objects.requireNonNull(CorrelationIndices.class.getClassLoader().getResourceAsStream("mappings/correlation_alert_mapping.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initCorrelationAlertIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        Settings correlationAlertSettings = Settings.builder().put("index.hidden", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20").build();
        CreateIndexRequest indexRequest = new CreateIndexRequest(CORRELATION_ALERT_INDEX).mapping(CorrelationIndices.correlationAlertIndexMappings()).settings(correlationAlertSettings);
        this.client.admin().indices().create(indexRequest, actionListener);
    }
}

