/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.STIX2IOC;

public class STIX2IOCDto
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(STIX2IOCDto.class);
    private String id;
    private String name;
    private String type;
    private String value;
    private String severity;
    private Instant created;
    private Instant modified;
    private String description;
    private List<String> labels;
    private String specVersion;
    private String feedId;
    private String feedName;
    private long version;

    public STIX2IOCDto() {
    }

    public STIX2IOCDto(String id, String name, String type, String value, String severity, Instant created, Instant modified, String description, List<String> labels, String specVersion, String feedId, String feedName, long version) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.value = value;
        this.severity = severity;
        this.created = created;
        this.modified = modified;
        this.description = description;
        this.labels = labels;
        this.specVersion = specVersion;
        this.feedId = feedId;
        this.feedName = feedName;
        this.version = version;
    }

    public STIX2IOCDto(STIX2IOC ioc) {
        this(ioc.getId(), ioc.getName(), ioc.getType(), ioc.getValue(), ioc.getSeverity(), ioc.getCreated(), ioc.getModified(), ioc.getDescription(), ioc.getLabels(), ioc.getSpecVersion(), ioc.getFeedId(), ioc.getFeedName(), ioc.getVersion());
    }

    public STIX2IOCDto(StreamInput sin) throws IOException {
        this(new STIX2IOC(sin));
    }

    public static STIX2IOCDto readFrom(StreamInput sin) throws IOException {
        return new STIX2IOCDto(sin);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.type.toString());
        out.writeString(this.value);
        out.writeString(this.severity);
        out.writeInstant(this.created);
        out.writeInstant(this.modified);
        out.writeString(this.description);
        out.writeStringCollection(this.labels);
        out.writeString(this.specVersion);
        out.writeString(this.feedId);
        out.writeString(this.feedName);
        out.writeLong(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("id", this.id).field("name", this.name).field("type", this.type.toString()).field("value", this.value).field("severity", this.severity).timeField("created", (Object)this.created).timeField("modified", (Object)this.modified).field("description", this.description).field("labels", this.labels).field("spec_version", this.specVersion).field("feed_id", this.feedId).field("feed_name", this.feedName).field("version", this.version).endObject();
    }

    public static STIX2IOCDto parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = 1L;
        }
        String name = null;
        String type = null;
        String value = null;
        String severity = null;
        Instant created = null;
        Instant modified = null;
        String description = null;
        ArrayList<String> labels = new ArrayList<String>();
        String specVersion = null;
        String feedId = null;
        String feedName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block30: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = STIX2IOCDto.getString(xcp, id);
                    continue block30;
                }
                case "version": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block30;
                    version = xcp.longValue();
                    continue block30;
                }
                case "name": {
                    name = STIX2IOCDto.getString(xcp, name);
                    continue block30;
                }
                case "type": {
                    type = STIX2IOCDto.getString(xcp, type);
                    continue block30;
                }
                case "value": {
                    value = STIX2IOCDto.getString(xcp, value);
                    continue block30;
                }
                case "severity": {
                    severity = STIX2IOCDto.getString(xcp, severity);
                    continue block30;
                }
                case "created": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        created = null;
                        continue block30;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            created = Instant.parse(xcp.text());
                            continue block30;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block30;
                        created = Instant.ofEpochMilli(xcp.longValue());
                        continue block30;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    created = null;
                    continue block30;
                }
                case "modified": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        modified = null;
                        continue block30;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            modified = Instant.parse(xcp.text());
                            continue block30;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block30;
                        modified = Instant.ofEpochMilli(xcp.longValue());
                        continue block30;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    modified = null;
                    continue block30;
                }
                case "description": {
                    description = STIX2IOCDto.getString(xcp, description);
                    continue block30;
                }
                case "labels": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String entry = xcp.textOrNull();
                        if (entry == null) continue;
                        labels.add(entry);
                    }
                    continue block30;
                }
                case "spec_version": {
                    specVersion = STIX2IOCDto.getString(xcp, specVersion);
                    continue block30;
                }
                case "feed_id": {
                    feedId = STIX2IOCDto.getString(xcp, feedId);
                    continue block30;
                }
                case "feed_name": {
                    feedName = STIX2IOCDto.getString(xcp, feedName);
                    continue block30;
                }
            }
            xcp.skipChildren();
        }
        return new STIX2IOCDto(id, name, type, value, severity, created, modified, description, labels, specVersion, feedId, feedName, version);
    }

    private static String getString(XContentParser xcp, String currVal) throws IOException {
        if (xcp.currentToken() != XContentParser.Token.VALUE_NULL) {
            return xcp.text();
        }
        return currVal;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public Instant getModified() {
        return this.modified;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
}

