/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.action.FindingDto;

public class GetFindingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final String TOTAL_FINDINGS_FIELD = "total_findings";
    private static final String FINDINGS_FIELD = "findings";
    private Integer totalFindings;
    private List<FindingDto> findings;

    public GetFindingsResponse(Integer totalFindings, List<FindingDto> findings) {
        this.totalFindings = totalFindings;
        this.findings = findings;
    }

    public GetFindingsResponse(StreamInput sin) throws IOException {
        this.totalFindings = sin.readOptionalInt();
        Collections.unmodifiableList(sin.readList(FindingDto::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.totalFindings);
        out.writeCollection(this.findings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(TOTAL_FINDINGS_FIELD, this.totalFindings).field(FINDINGS_FIELD, this.findings);
        return builder.endObject();
    }

    public Integer getTotalFindings() {
        return this.totalFindings;
    }

    public List<FindingDto> getFindings() {
        return this.findings;
    }
}

