/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.ParseUtils;

public class PipelineProcessor
implements ToXContentObject {
    public static final String TYPE_FIELD = "type";
    public static final String PARAMS_FIELD = "params";
    private final String type;
    private final Map<String, String> params;

    public PipelineProcessor(String type, Map<String, String> params) {
        this.type = type;
        this.params = params;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(TYPE_FIELD, this.type);
        xContentBuilder.field(PARAMS_FIELD);
        ParseUtils.buildStringToStringMap(xContentBuilder, this.params);
        return xContentBuilder.endObject();
    }

    public static PipelineProcessor parse(XContentParser parser) throws IOException {
        String type = null;
        Map<String, String> params = new HashMap<String, String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block8;
                }
                case "params": {
                    params = ParseUtils.parseStringToStringMap(parser);
                    continue block8;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in a pipeline processor object.", RestStatus.BAD_REQUEST);
        }
        if (type == null) {
            throw new FlowFrameworkException("A processor object requires a type field.", RestStatus.BAD_REQUEST);
        }
        return new PipelineProcessor(type, params);
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> params() {
        return this.params;
    }
}

